/*
 * Decompiled with CFR 0.152.
 */
package jas2.hist.util;

import java.util.Observable;
import java.util.Observer;

public class ObserverAdapter
extends Observable
implements Observer {
    private Observable obs;
    private boolean observing = false;

    public ObserverAdapter(Observable obs) {
        this.obs = obs;
    }

    public ObserverAdapter() {
    }

    public synchronized void setObservable(Observable newObs) {
        if (this.observing && this.obs != null) {
            this.obs.deleteObserver(this);
        }
        this.obs = newObs;
        if (this.observing && this.obs != null) {
            this.obs.addObserver(this);
        }
    }

    public synchronized void clearObservable() {
        this.setObservable(null);
    }

    @Override
    public void update(Observable o, Object arg) {
        this.setChanged();
        this.notifyObservers(arg);
    }

    private void observe(boolean set) {
        if (set != this.observing) {
            if (this.obs != null) {
                if (set) {
                    this.obs.addObserver(this);
                } else {
                    this.obs.deleteObserver(this);
                }
            }
            this.observing = set;
        }
    }

    @Override
    public synchronized void addObserver(Observer o) {
        super.addObserver(o);
        this.observe(true);
    }

    @Override
    public synchronized void deleteObserver(Observer o) {
        super.deleteObserver(o);
        if (this.countObservers() == 0) {
            this.observe(false);
        }
    }

    @Override
    public synchronized void deleteObservers() {
        super.deleteObservers();
        this.observe(false);
    }
}

