/*
 * Decompiled with CFR 0.152.
 */
package jas2.hist.test;

import jas2.hist.DataSource;
import jas2.hist.HasSlices;
import jas2.hist.JASHist;
import jas2.hist.JASHistData;
import jas2.hist.Rebinnable1DHistogramData;
import jas2.hist.ScatterPlotSource;
import jas2.hist.test.TestScatterPlotSource;
import jas2.hist.util.ScatterSliceAdapter;
import jas2.hist.util.ScatterTwoDAdapter;
import jas2.hist.util.SliceAdapter;
import jas2.hist.util.SliceEvent;
import jas2.hist.util.SliceListener;
import jas2.hist.util.TwoDSliceAdapter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Hashtable;
import javax.swing.ButtonGroup;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class SliceTest
extends JPanel
implements SliceListener {
    private final ScatterPlotSource source = new TestScatterPlotSource();
    private JASHist hist2;
    private JASHist hist1;
    private Hashtable hash = new Hashtable();

    SliceTest() {
        super(new BorderLayout());
        JPanel p = new JPanel(new GridLayout(1, 2));
        this.hist1 = new JASHist();
        this.hist2 = new JASHist();
        p.add(this.hist1);
        p.add(this.hist2);
        this.add((Component)p, "Center");
        this.add((Component)new ButtonPanel(), "South");
    }

    void setSliceData(Rebinnable1DHistogramData ds) {
        this.hist2.removeAllData();
        if (ds != null) {
            this.hist2.addData(ds).show(true);
        }
    }

    void setData(DataSource ds) {
        this.hist1.removeAllData();
        this.hist2.removeAllData();
        this.hash.clear();
        this.hist1.addData(ds).show(true);
        if (ds instanceof SliceAdapter) {
            ((SliceAdapter)((Object)ds)).addSliceListener(this);
        }
    }

    @Override
    public void sliceAdded(SliceEvent e) {
        HasSlices source = (HasSlices)e.getSource();
        Rebinnable1DHistogramData ds = source.getSlice(e.getIndex());
        JASHistData data = this.hist2.addData(ds);
        data.show(true);
        this.hash.put(ds, data);
    }

    @Override
    public void sliceRemoved(SliceEvent e) {
        HasSlices source = (HasSlices)e.getSource();
        Rebinnable1DHistogramData ds = source.getSlice(e.getIndex());
        JASHistData data = (JASHistData)this.hash.get(ds);
        data.show(false);
    }

    public static void main(String[] argv) {
        JFrame f = new JFrame();
        f.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        f.setContentPane(new SliceTest());
        f.pack();
        f.show();
    }

    class ButtonPanel
    extends JPanel
    implements ActionListener {
        private ButtonGroup g;
        private JRadioButton b1;
        private JRadioButton b2;
        private JRadioButton b3;

        ButtonPanel() {
            super(new FlowLayout());
            this.g = new ButtonGroup();
            this.b1 = new JRadioButton("Scatter Plot");
            this.addButton(this.b1);
            this.b2 = new JRadioButton("Rebinnable 2D Plot");
            this.addButton(this.b2);
            this.b3 = new JRadioButton("NonRebinnable 2D Plot");
            this.addButton(this.b3);
        }

        private void addButton(JRadioButton b) {
            this.add(b);
            this.g.add(b);
            b.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object b = e.getSource();
            if (b == this.b1) {
                SliceTest.this.setData(new ScatterSliceAdapter(SliceTest.this.source));
            } else if (b == this.b2) {
                SliceTest.this.setData(new TwoDSliceAdapter(new ScatterTwoDAdapter(SliceTest.this.source)));
            } else if (b == this.b3) {
                SliceTest.this.setData(new TwoDSliceAdapter(new ScatterTwoDAdapter(SliceTest.this.source){

                    @Override
                    public boolean isRebinnable() {
                        return false;
                    }
                }));
            }
        }
    }
}

