/*
 * Decompiled with CFR 0.152.
 */
package jas2.hist.normalization;

import jas2.hist.DataSource;
import jas2.hist.ExtendedStatistics;
import jas2.hist.HasStatistics;
import jas2.hist.Statistics;
import jas2.hist.normalization.DataSourceNormalizer;

public class StatisticsNormalizer
extends DataSourceNormalizer {
    private String statsName;

    public StatisticsNormalizer(DataSource source, String statsName) {
        super(source);
        this.statsName = statsName;
        this.init();
    }

    @Override
    protected double calculateNormalization() {
        if (this.source instanceof HasStatistics) {
            Statistics stats = ((HasStatistics)((Object)this.source)).getStatistics();
            double stat = stats.getStatistic(this.statsName);
            if (stat == 0.0 && stats instanceof ExtendedStatistics) {
                Object obj = ((ExtendedStatistics)stats).getExtendedStatistic(this.statsName);
                try {
                    stat = Double.parseDouble(obj.toString());
                }
                catch (NumberFormatException e) {
                    stat = 0.0;
                }
            }
            return stat > 0.0 ? stat : 1.0;
        }
        return 1.0;
    }
}

