/*
 * Decompiled with CFR 0.152.
 */
package jas2.hist;

import jas2.hist.Statistics;
import jas2.util.xml.XMLNodeTraverser;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class StatisticsTraverser
extends XMLNodeTraverser
implements Statistics {
    private String[] names;
    private double[] values;
    private int cn = 0;
    private int cv = 0;

    StatisticsTraverser(Node node) throws XMLNodeTraverser.BadXMLException {
        Object[] copy;
        int maxSize = node.getChildNodes().getLength();
        this.names = new String[maxSize];
        this.values = new double[maxSize];
        this.traverse(node);
        if (this.cn < maxSize) {
            copy = new String[this.cn];
            System.arraycopy(this.names, 0, copy, 0, this.cn);
            this.names = copy;
        }
        if (this.cv < maxSize) {
            copy = new double[this.cn];
            System.arraycopy(this.values, 0, copy, 0, this.cv);
            this.values = (double[])copy;
        }
    }

    @Override
    protected void handleElement(Element node, String name) throws XMLNodeTraverser.BadXMLException {
        if (name.equals("statistic")) {
            this.traverse(node);
        } else {
            super.handleElement(node, name);
        }
    }

    @Override
    protected void handleAttributeNode(Attr node, String name, String value) throws XMLNodeTraverser.BadXMLException {
        if (name.equals("value")) {
            this.values[this.cv++] = this.toDouble(value);
        } else if (name.equals("name")) {
            this.names[this.cn++] = value;
        } else {
            super.handleAttributeNode(node, name, value);
        }
    }

    @Override
    public String[] getStatisticNames() {
        return this.names;
    }

    @Override
    public double getStatistic(String name) {
        for (int i = 0; i < this.names.length; ++i) {
            if (!name.equals(this.names[i])) continue;
            return this.values[i];
        }
        return 0.0;
    }
}

