/*
 * Decompiled with CFR 0.152.
 */
package jas2.hist;

import jas2.hist.DateTransformationConverter;
import jas2.hist.JASHist1DHistogramData;
import jas2.hist.JASHist1DHistogramStyle;
import jas2.hist.Rebinnable1DVariableHistogramData;
import jas2.plot.CoordinateTransformation;
import jas2.plot.DateCoordinateTransformation;
import jas2.plot.DoubleCoordinateTransformation;
import jas2.plot.MutableLegendEntry;
import jas2.plot.Overlay;
import jas2.plot.OverlayContainer;
import jas2.plot.PlotGraphics;
import jas2.plot.StringCoordinateTransformation;
import java.awt.BasicStroke;

class OneDOverlay
implements Overlay,
MutableLegendEntry {
    private JASHist1DHistogramData source;
    private OverlayContainer container;
    private double[] data;
    private double[] dataX;
    private String[] labels;
    private double[] minus;
    private double[] plus;
    private double xmax;
    private double xmin;
    private static final float[][] lineStyles = new float[][]{null, {1.0f, 5.0f}, {4.0f, 6.0f}, {6.0f, 4.0f, 2.0f, 4.0f}};

    OneDOverlay(JASHist1DHistogramData d) {
        this.source = d;
    }

    @Override
    public void setTitle(String newTitle) {
        this.source.setLegendText(newTitle);
    }

    @Override
    public String getTitle() {
        return this.source.getLegendText();
    }

    @Override
    public void containerNotify(OverlayContainer c) {
        this.container = c;
    }

    @Override
    public void paint(PlotGraphics g, boolean isPrinting) {
        JASHist1DHistogramStyle style = this.source.style;
        double[] binEdges = null;
        if (this.source.getDataSource() instanceof Rebinnable1DVariableHistogramData) {
            binEdges = ((Rebinnable1DVariableHistogramData)this.source.getDataSource()).getBinEdges();
        }
        CoordinateTransformation xp = this.container.getXTransformation();
        CoordinateTransformation yp = this.container.getYTransformation(this.source.getYAxis());
        if (xp instanceof DateCoordinateTransformation) {
            xp = new DateTransformationConverter((DateCoordinateTransformation)xp);
        }
        if (xp instanceof DoubleCoordinateTransformation && yp instanceof DoubleCoordinateTransformation) {
            DoubleCoordinateTransformation xt = (DoubleCoordinateTransformation)xp;
            DoubleCoordinateTransformation yt = (DoubleCoordinateTransformation)yp;
            int bins = this.data.length;
            double binWidthFixed = (this.xmax - this.xmin) / (double)bins;
            double pixelWidth = (xt.convert(this.xmax) - xt.convert(this.xmin)) / (double)bins;
            boolean outline = pixelWidth > 5.0;
            double errorBarWidth = Math.min(binWidthFixed, 3.0 * binWidthFixed / pixelWidth);
            g.setTransformation(xt, yt);
            double x = this.xmin;
            double oldx = this.xmin;
            double y0 = 0.0;
            if (yt.getPlotMin() > y0) {
                y0 = yt.getPlotMin();
            }
            if (yt.getPlotMax() < y0) {
                y0 = yt.getPlotMax();
            }
            double oldy = y0;
            double[] lpbx = null;
            double[] lpby = null;
            int lpbn = 0;
            if (style.getShowLinesBetweenPoints() || style.getShowDataPoints()) {
                lpbx = new double[bins];
                lpby = new double[bins];
            }
            for (int i = 0; i < bins; ++i) {
                double y = this.data[i];
                double binWidth = binEdges == null ? binWidthFixed : binEdges[i + 1] - binEdges[i];
                x = this.dataX == null ? x + binWidth : this.dataX[i];
                BasicStroke s = new BasicStroke(style.getHistogramBarLineWidth(), 2, 1, 10.0f, lineStyles[style.getHistogramBarLineStyle()], 0.0f);
                g.setStroke(s);
                if (style.getShowHistogramBars()) {
                    if (!Double.isNaN(y)) {
                        g.setColor(style.getHistogramBarColor());
                        if (style.getHistogramFill()) {
                            g.fillRect(oldx, y0, x, y);
                            g.setColor(style.getHistogramBarLineColor());
                            if (outline) {
                                g.drawRect(oldx, y0, x, y);
                            } else {
                                g.drawLine(oldx, oldy, oldx, y);
                                g.drawLine(oldx, y, x, y);
                            }
                        } else {
                            g.setColor(style.getHistogramBarLineColor());
                            g.drawLine(oldx, oldy, oldx, y);
                            g.drawLine(oldx, y, x, y);
                        }
                    } else if (!style.getHistogramFill() || !outline) {
                        g.drawLine(oldx, oldy, oldx, y0);
                    }
                }
                g.setStroke(null);
                if (style.getShowErrorBars() && !Double.isNaN(y)) {
                    g.setColor(style.getErrorBarColor());
                    double xm = binWidth == 0.0 ? x : oldx + binWidth / 2.0;
                    double xe = style.getErrorBarDecoration() >= 0.0f ? (double)style.getErrorBarDecoration() * binWidth / 2.0 : Math.min(binWidth, 3.0 * binWidth / pixelWidth);
                    double yplus = this.data[i] + this.plus[i];
                    double yminus = this.data[i] - this.minus[i];
                    s = new BasicStroke(style.getErrorBarWidth(), 2, 1, 10.0f, lineStyles[style.getErrorBarStyle()], 0.0f);
                    g.setStroke(s);
                    if (!Double.isNaN(yplus) && !Double.isNaN(yminus) && yminus != yplus) {
                        g.drawLine(xm, yplus, xm, yminus);
                        if (outline && style.getErrorBarDecoration() < 0.0f || style.getErrorBarDecoration() > 0.0f) {
                            BasicStroke ss = new BasicStroke(style.getErrorBarWidth(), 2, 1, 10.0f);
                            g.setStroke(ss);
                            g.drawLine(xm - xe, yplus, xm + xe, yplus);
                            g.drawLine(xm - xe, yminus, xm + xe, yminus);
                        }
                    }
                    g.setStroke(null);
                }
                if (lpbx != null) {
                    if (Double.isNaN(y)) {
                        if (lpbn > 0) {
                            if (style.getShowLinesBetweenPoints()) {
                                g.setColor(style.getLineColor());
                                s = new BasicStroke(style.getLinesBetweenPointsWidth(), 2, 1, 10.0f, lineStyles[style.getLinesBetweenPointsStyle()], 0.0f);
                                g.setStroke(s);
                                g.drawPolyLine(lpbx, lpby, lpbn);
                                g.setStroke(null);
                            }
                            if (style.getShowDataPoints()) {
                                g.setColor(style.getDataPointColor());
                                g.drawPolySymbol(lpbx, lpby, style.getDataPointSize(), style.getDataPointStyle(), lpbn);
                            }
                            lpbn = 0;
                        }
                    } else {
                        lpbx[lpbn] = this.dataX == null ? oldx + binWidth / 2.0 : x;
                        lpby[lpbn++] = y;
                    }
                }
                oldx = x;
                oldy = y == Double.NaN ? y0 : y;
            }
            if (lpbn > 0) {
                if (style.getShowLinesBetweenPoints()) {
                    g.setColor(style.getLineColor());
                    BasicStroke s = new BasicStroke(style.getLinesBetweenPointsWidth(), 2, 1, 10.0f, lineStyles[style.getLinesBetweenPointsStyle()], 0.0f);
                    g.setStroke(s);
                    g.drawPolyLine(lpbx, lpby, lpbn);
                    g.setStroke(null);
                }
                if (style.getShowDataPoints()) {
                    g.setColor(style.getDataPointColor());
                    g.drawPolySymbol(lpbx, lpby, style.getDataPointSize(), style.getDataPointStyle(), lpbn);
                }
            }
        } else if (xp instanceof StringCoordinateTransformation && yp instanceof DoubleCoordinateTransformation) {
            StringCoordinateTransformation xt = (StringCoordinateTransformation)xp;
            DoubleCoordinateTransformation yt = (DoubleCoordinateTransformation)yp;
            int bins = this.labels.length;
            double binWidth = xt.binWidth();
            boolean outline = binWidth > 5.0;
            g.setTransformation(null, yt);
            double y0 = 0.0;
            if (yt.getPlotMin() > y0) {
                y0 = yt.getPlotMin();
            }
            if (yt.getPlotMax() < y0) {
                y0 = yt.getPlotMax();
            }
            double oldy = yt.getPlotMin();
            double[] lpbx = null;
            double[] lpby = null;
            int lpbn = 0;
            if (style.getShowLinesBetweenPoints() || style.getShowDataPoints()) {
                lpbx = new double[bins];
                lpby = new double[bins];
            }
            for (int i = 0; i < bins; ++i) {
                double x = xt.convert(this.labels[i]) + binWidth / 2.0;
                double oldx = x - binWidth;
                double y = this.data[i];
                BasicStroke s = new BasicStroke(style.getHistogramBarLineWidth(), 2, 1, 10.0f, lineStyles[style.getHistogramBarLineStyle()], 0.0f);
                g.setStroke(s);
                if (style.getShowHistogramBars()) {
                    if (!Double.isNaN(y)) {
                        g.setColor(style.getHistogramBarColor());
                        if (style.getHistogramFill()) {
                            g.fillRect(oldx, oldy, x, y);
                            g.setColor(style.getHistogramBarLineColor());
                            if (outline) {
                                g.drawRect(oldx, oldy, x, y);
                            } else {
                                g.drawLine(oldx, oldy, oldx, y);
                                g.drawLine(oldx, y, x, y);
                            }
                        } else {
                            g.setColor(style.getHistogramBarLineColor());
                            g.drawLine(oldx, oldy, oldx, y);
                            g.drawLine(oldx, y, x, y);
                        }
                    } else if (!style.getHistogramFill() || !outline) {
                        g.drawLine(oldx, oldy, oldx, y0);
                    }
                }
                g.setStroke(null);
                if (style.getShowErrorBars() && !Double.isNaN(y)) {
                    s = new BasicStroke(style.getErrorBarWidth(), 2, 1, 10.0f, lineStyles[style.getErrorBarStyle()], 0.0f);
                    g.setStroke(s);
                    g.setColor(style.getErrorBarColor());
                    double xm = x - binWidth / 2.0;
                    double xe = style.getErrorBarDecoration() >= 0.0f ? (double)style.getErrorBarDecoration() * binWidth / 2.0 : Math.min(3.0, binWidth / 2.0);
                    double yplus = this.data[i] + this.plus[i];
                    double yminus = this.data[i] - this.minus[i];
                    if (!Double.isNaN(yplus) && !Double.isNaN(yminus) && yminus != yplus) {
                        g.drawLine(xm, yplus, xm, yminus);
                        if (outline && style.getErrorBarDecoration() < 0.0f || style.getErrorBarDecoration() > 0.0f) {
                            BasicStroke ss = new BasicStroke(style.getErrorBarWidth(), 2, 1, 10.0f);
                            g.setStroke(ss);
                            g.drawLine(xm - xe, yplus, xm + xe, yplus);
                            g.drawLine(xm - xe, yminus, xm + xe, yminus);
                        }
                    }
                    g.setStroke(null);
                }
                if (lpbx != null) {
                    if (Double.isNaN(y)) {
                        if (lpbn > 0) {
                            if (style.getShowLinesBetweenPoints()) {
                                g.setColor(style.getLineColor());
                                s = new BasicStroke(style.getLinesBetweenPointsWidth(), 2, 1, 10.0f, lineStyles[style.getLinesBetweenPointsStyle()], 0.0f);
                                g.setStroke(s);
                                g.drawPolyLine(lpbx, lpby, lpbn);
                                g.setStroke(null);
                            }
                            if (style.getShowDataPoints()) {
                                g.setColor(style.getDataPointColor());
                                g.drawPolySymbol(lpbx, lpby, style.getDataPointSize(), style.getDataPointStyle(), lpbn);
                            }
                            lpbn = 0;
                        }
                    } else {
                        lpbx[lpbn] = this.dataX == null ? oldx + binWidth / 2.0 : x;
                        lpby[lpbn++] = y;
                    }
                }
                oldx = x;
            }
            if (lpbn > 0) {
                if (style.getShowLinesBetweenPoints()) {
                    g.setColor(style.getLineColor());
                    BasicStroke s = new BasicStroke(style.getLinesBetweenPointsWidth(), 2, 1, 10.0f, lineStyles[style.getLinesBetweenPointsStyle()], 0.0f);
                    g.setStroke(s);
                    g.drawPolyLine(lpbx, lpby, lpbn);
                    g.setStroke(null);
                }
                if (style.getShowDataPoints()) {
                    g.setColor(style.getDataPointColor());
                    g.drawPolySymbol(lpbx, lpby, style.getDataPointSize(), style.getDataPointStyle(), lpbn);
                }
            }
        }
    }

    @Override
    public void paintIcon(PlotGraphics g, int width, int height) {
        JASHist1DHistogramStyle style = this.source.style;
        if (style.getShowDataPoints()) {
            g.setColor(style.getDataPointColor());
            g.drawSymbol(width / 2, height / 2, width / 2, style.getDataPointStyle());
        } else if (style.getShowHistogramBars()) {
            if (style.getHistogramFill()) {
                g.setColor(style.getHistogramBarColor());
                g.fillRect(1.0, 1.0, width - 2, height - 2);
            } else {
                g.setColor(style.getHistogramBarLineColor());
                float flw = style.getHistogramBarLineWidth() * 3.0f;
                if (flw > (float)(width / 2)) {
                    flw = width / 2 - 1;
                }
                BasicStroke s = new BasicStroke(flw, 2, 1, 10.0f, lineStyles[style.getHistogramBarLineStyle()], 0.0f);
                g.setStroke(s);
                g.drawLine(1.0, height / 2, width - 2, height / 2);
                g.setStroke(null);
            }
        } else if (style.getShowLinesBetweenPoints()) {
            g.setColor(style.getLineColor());
            float flw = style.getHistogramBarLineWidth() * 3.0f;
            if (flw > (float)(width / 2)) {
                flw = width > 2 ? (float)(width / 2 - 1) : 1.0f;
            }
            BasicStroke s = new BasicStroke(flw, 2, 1, 10.0f, lineStyles[style.getLinesBetweenPointsStyle()], 0.0f);
            g.setStroke(s);
            g.drawLine(1.0, height / 2, width - 2, height / 2);
            g.setStroke(null);
        } else if (style.getShowErrorBars()) {
            g.setColor(style.getErrorBarColor());
            BasicStroke s = new BasicStroke(style.getErrorBarWidth(), 2, 1, 10.0f, lineStyles[style.getErrorBarStyle()], 0.0f);
            g.setStroke(s);
            g.drawLine(1.0, height / 2, width - 2, height / 2);
            g.setStroke(null);
        } else if (style.getHistogramFill()) {
            g.setColor(style.getHistogramBarColor());
            g.fillRect(1.0, 1.0, width - 2, height - 2);
        }
    }

    @Override
    public boolean titleIsChanged() {
        return this.source.isLegendChanged();
    }

    void setData(double[] data, double[] plusError, double[] minusError, double xMin, double xMax) {
        this.data = data;
        this.plus = plusError;
        this.minus = minusError;
        this.xmin = xMin;
        this.xmax = xMax;
    }

    void setData(double[] x, double[] y, double[] plusError, double[] minusError) {
        this.dataX = x;
        this.data = y;
        this.plus = plusError;
        this.minus = minusError;
    }

    void setData(double[] data, double[] plusError, double[] minusError, String[] labels) {
        this.data = data;
        this.plus = plusError;
        this.minus = minusError;
        this.labels = labels;
    }
}

