/*
 * Decompiled with CFR 0.152.
 */
package jas2.hist;

import jas2.hist.Basic1DFunction;
import jas2.hist.DataRenderer;
import jas2.hist.FitUpdate;
import jas2.hist.Fittable1DFunction;
import jas2.hist.Fitter;
import jas2.hist.FitterFactory;
import jas2.hist.FitterRegistry;
import jas2.hist.FunctionAdvancedOptions;
import jas2.hist.FunctionFactory;
import jas2.hist.FunctionFactoryError;
import jas2.hist.FunctionRegistry;
import jas2.hist.InvalidFunctionParameter;
import jas2.hist.JASHist;
import jas2.hist.JASHist1DFunctionData;
import jas2.hist.JASHist1DHistogramData;
import jas2.hist.JASHistData;
import jas2.hist.JASHistPropDataStyle;
import jas2.hist.JASHistPropFunctionStyle;
import jas2.hist.XYDataSource;
import jas2.util.JASIcon;
import jas2.util.JASTextField;
import jas2.util.PropertyPage;
import jas2.util.PropertySite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.NumberFormat;
import java.util.Enumeration;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

class JASHistPropFunctions
extends PropertyPage
implements ListSelectionListener,
PropertySite {
    private JASHistPropFunctionStyle m_propStyle;
    private JASHistPropDataStyle m_dataStyle;
    private ParamManager m_paramManager;
    private FitManager m_fitManager;
    private boolean m_init = false;
    private JASHist1DFunctionData m_selected;
    private JList m_list;
    private DefaultListModel m_listModel;
    private TextField m_value;
    private JASHist m_jHist;
    private NumberFormat format = NumberFormat.getInstance();
    private JButton advanced;
    private ListNameChangeListener m_listNameChangeListener = new ListNameChangeListener();

    public JASHistPropFunctions() {
        this.setLayout(new BorderLayout());
        JPanel p1 = new JPanel(new BorderLayout());
        this.m_listModel = new DefaultListModel();
        this.m_list = new JList(this.m_listModel);
        this.m_list.setCellRenderer(DataRenderer.createRenderer());
        this.m_list.addListSelectionListener(this);
        JScrollPane scroll = new JScrollPane();
        scroll.setViewportView(this.m_list);
        scroll.setPreferredSize(new Dimension(100, 120));
        p1.add((Component)scroll, "Center");
        JPanel p2 = new JPanel();
        JButton add = new JButton("Add...");
        add.addActionListener(new AddButtonListener());
        add.setMnemonic('d');
        p2.add(add);
        JButton remove = new JButton("Remove");
        remove.addActionListener(new RemoveButtonListener());
        remove.setMnemonic('R');
        p2.add(remove);
        p1.add((Component)p2, "South");
        this.add((Component)p1, "West");
        JPanel p = new JPanel(new BorderLayout());
        JPanel b = new JPanel(new FlowLayout(0));
        this.m_propStyle = new JASHistPropFunctionStyle();
        this.m_propStyle.setPropertySite(this);
        b.add(this.m_propStyle);
        this.m_dataStyle = new JASHistPropDataStyle();
        this.m_dataStyle.setPropertySite(this);
        b.add(this.m_dataStyle);
        this.advanced = new JButton("Advanced...");
        this.advanced.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    FunctionAdvancedOptions fao = (FunctionAdvancedOptions)((Object)JASHistPropFunctions.this.m_selected.getFunction());
                    Container w = JASHistPropFunctions.this;
                    while (!(w instanceof Frame)) {
                        w = w.getParent();
                    }
                    fao.openAdvancedDialog((Frame)w, JASHistPropFunctions.this.m_jHist);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.advanced.setMnemonic('v');
        b.add(this.advanced);
        p.add((Component)b, "North");
        p.setBorder(BorderFactory.createTitledBorder("Function"));
        this.m_paramManager = new ParamManager();
        p.add((Component)this.m_paramManager, "Center");
        this.m_fitManager = new FitManager();
        p.add((Component)this.m_fitManager, "South");
        this.add((Component)p, "Center");
        this.updateAdvanced();
    }

    @Override
    public String getHelpTopic() {
        return "functionsAndFilters.functions";
    }

    @Override
    public synchronized void doDataExchange(boolean set, Object bean) {
        if (!this.m_init) {
            JASHist hist = (JASHist)bean;
            Enumeration e = hist.get1DFunctions();
            while (e.hasMoreElements()) {
                JASHist1DFunctionData d = (JASHist1DFunctionData)e.nextElement();
                this.m_listModel.addElement(d);
                Basic1DFunction f = d.getFunction();
                if (!(f instanceof FunctionAdvancedOptions)) continue;
                f.addObserver(this.m_listNameChangeListener);
            }
            if (this.m_listModel.size() > 0) {
                this.m_selected = (JASHist1DFunctionData)this.m_listModel.elementAt(0);
                this.m_list.setSelectedValue(this.m_selected, true);
            } else {
                this.m_selected = null;
            }
            this.m_jHist = hist;
            this.m_fitManager.init(hist);
            this.m_init = true;
        }
        if (this.m_selected != null) {
            this.m_propStyle.doDataExchange(set, this.m_selected.getStyle());
            this.m_dataStyle.doDataExchange(set, this.m_selected);
            this.m_paramManager.doDataExchange(set, this.m_selected.getFunction());
            this.m_fitManager.setFunction(this.m_selected);
        }
        this.setChanged(false);
        this.updateAdvanced();
    }

    private synchronized void addFunction(JASHist1DFunctionData d) {
        this.m_selected = d;
        this.m_listModel.addElement(d);
        this.m_list.setSelectedValue(d, true);
        this.doDataExchange(true, this.m_jHist);
    }

    private synchronized void removeFunction() {
        this.m_selected.delete();
        this.m_listModel.removeElement(this.m_selected);
        this.doDataExchange(true, this.m_jHist);
    }

    @Override
    public void valueChanged(ListSelectionEvent evt) {
        if (!this.m_init) {
            return;
        }
        this.doDataExchange(true, this.m_jHist);
        if (this.m_listModel.getSize() > 0) {
            this.m_selected = (JASHist1DFunctionData)this.m_list.getSelectedValue();
            this.doDataExchange(false, this.m_jHist);
            this.updateAdvanced();
        }
    }

    private void updateAdvanced() {
        this.advanced.setEnabled(this.m_selected != null && this.m_selected.getFunction() instanceof FunctionAdvancedOptions);
    }

    @Override
    public void callEnable() {
        this.setChanged(true);
    }

    @Override
    protected void deactivate() {
        this.m_paramManager.deactivate();
        this.m_fitManager.deactivate();
    }

    public JASHist getHist() {
        return this.m_jHist;
    }

    private class ListNameChangeListener
    implements Observer {
        private ListNameChangeListener() {
        }

        @Override
        public void update(Observable o, Object arg) {
            JASHistPropFunctions.this.m_list.repaint();
        }
    }

    private class FitManager
    extends JPanel
    implements Observer,
    ItemListener {
        private Fittable1DFunction m_function;
        private JASHist1DFunctionData m_fd;
        private JLabel m_state;
        private JCheckBox m_fit;
        private JComboBox m_choice;
        private JComboBox m_fitterChoice;
        private JLabel m_chi2;
        private FitWatcher m_fitWatcher;
        private Icon[] states = new Icon[5];

        FitManager() {
            this.states[1] = JASIcon.create(this, "tick.gif");
            this.states[2] = JASIcon.create(this, "cross.gif");
            this.states[0] = JASIcon.create(this, "running.gif");
            this.states[3] = this.states[1];
            this.states[4] = this.states[2];
            JPanel p4 = new JPanel();
            this.m_state = new JLabel(this.states[1]);
            p4.add(this.m_state);
            this.m_chi2 = new JLabel(" "){

                @Override
                public Dimension getPreferredSize() {
                    Dimension result = super.getPreferredSize();
                    result.width = 100;
                    return result;
                }
            };
            this.m_chi2.setIcon(JASIcon.create(this, "chi2.gif"));
            p4.add(this.m_chi2);
            JPanel p2 = new JPanel(new BorderLayout());
            p2.add("North", p4);
            JProgressBar bar = new JProgressBar();
            this.m_fitWatcher = new FitWatcher(bar.getModel());
            p2.add("Center", bar);
            JPanel p3 = new JPanel();
            p3.add(new JLabel("Using"));
            this.m_fitterChoice = new JComboBox();
            this.m_fitterChoice.addItemListener(this);
            p3.add(this.m_fitterChoice);
            JPanel p1 = new JPanel();
            p1.add(new JLabel("Data"));
            this.m_choice = new JComboBox();
            p1.add(this.m_choice);
            JPanel p5 = new JPanel(new GridLayout(0, 1));
            p5.add(p3);
            p5.add(p1);
            this.setLayout(new BorderLayout());
            this.m_fit = new JCheckBox("Fit");
            this.m_fit.addActionListener(new FitNowHandler());
            this.m_fit.setMnemonic('F');
            this.setBorder(BorderFactory.createTitledBorder("Fit"));
            this.add("North", this.m_fit);
            this.add("West", p5);
            this.add("Center", p2);
            this.setEnabled(false);
        }

        void init(JASHist hist) {
            Enumeration e = hist.getDataSources();
            if (e.hasMoreElements()) {
                this.m_choice.setRenderer(DataRenderer.createRenderer());
                this.m_choice.addItemListener(this);
            } else {
                this.m_choice.setEnabled(false);
            }
            while (e.hasMoreElements()) {
                JASHist1DHistogramData d = (JASHist1DHistogramData)e.nextElement();
                this.m_choice.addItem(d.getFittableDataSource());
            }
            e = FitterRegistry.instance().elements();
            while (e.hasMoreElements()) {
                FitterFactory ff = (FitterFactory)e.nextElement();
                this.m_fitterChoice.addItem(ff);
            }
            this.m_fitterChoice.setSelectedItem(FitterRegistry.instance().getDefaultFitterFactory());
        }

        void setFunction(JASHist1DFunctionData fd) {
            if (this.m_function != null) {
                this.m_function.deleteObserver(this);
            }
            this.m_fitWatcher.clearFit();
            if (fd != null && fd.getFunction() instanceof Fittable1DFunction && this.m_choice.getItemCount() > 0 && this.m_fitterChoice.getItemCount() > 0) {
                this.m_fd = fd;
                this.m_function = (Fittable1DFunction)fd.getFunction();
                this.m_function.addObserver(this);
                Fitter fitter = this.m_function.getFit();
                if (fitter != null) {
                    this.m_fitWatcher.setFit(fitter);
                }
                this.update();
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
                this.m_function = null;
                this.m_fd = null;
            }
        }

        private void update() {
            Fitter fitter = this.m_function.getFit();
            this.m_fit.setSelected(fitter != null);
            if (fitter != null) {
                this.m_chi2.setText(JASHistPropFunctions.this.format.format(fitter.getChiSquared()));
                XYDataSource data = fitter.getData();
                if (data != null) {
                    this.m_choice.setSelectedItem(data);
                }
            }
        }

        @Override
        public void update(Observable obs, Object arg) {
            if (obs == this.m_function) {
                this.update();
            }
        }

        void deactivate() {
            this.setFunction(null);
        }

        @Override
        public void setEnabled(boolean state) {
            this.m_fit.setEnabled(state);
            this.m_choice.setEnabled(state);
            this.m_fitterChoice.setEnabled(state);
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
        }

        private class FitWatcher
        implements Observer {
            private BoundedRangeModel model;
            private Fitter m_fitter;

            FitWatcher(BoundedRangeModel model) {
                model.setMinimum(0);
                model.setMaximum(100);
                this.model = model;
                this.clearFit();
            }

            void setFit(Fitter fit) {
                this.m_fitter = fit;
                this.m_fitter.addObserver(this);
                FitManager.this.m_state.setEnabled(true);
                FitManager.this.m_state.repaint();
                FitManager.this.m_chi2.setEnabled(true);
                FitManager.this.m_chi2.repaint();
            }

            Fitter clearFit() {
                Fitter fit = this.m_fitter;
                if (fit != null) {
                    fit.deleteObserver(this);
                    this.m_fitter = null;
                }
                FitManager.this.m_state.setEnabled(false);
                FitManager.this.m_state.repaint();
                FitManager.this.m_chi2.setEnabled(false);
                FitManager.this.m_chi2.repaint();
                return fit;
            }

            @Override
            public void update(Observable obs, Object arg) {
                if (arg instanceof FitUpdate) {
                    FitUpdate fu = (FitUpdate)arg;
                    int state = fu.getState();
                    if (state == 5) {
                        this.clearFit();
                    } else {
                        this.model.setValue(fu.getPercent());
                        FitManager.this.m_state.setIcon(FitManager.this.states[state]);
                        if (state == 2) {
                            Container w = JASHistPropFunctions.this;
                            while (!(w instanceof Frame)) {
                                w = w.getParent();
                            }
                            JOptionPane.showMessageDialog(w, fu.getReason(), "Fit error...", 0);
                        }
                    }
                }
            }
        }

        private class FitNowHandler
        implements ActionListener {
            private FitNowHandler() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                if (FitManager.this.m_fit.isSelected()) {
                    FitterFactory ff = (FitterFactory)FitManager.this.m_fitterChoice.getSelectedItem();
                    Fitter fitter = ff.createFitter();
                    fitter.setFunction(FitManager.this.m_function);
                    XYDataSource data = (XYDataSource)FitManager.this.m_choice.getSelectedItem();
                    fitter.setData(data);
                    FitManager.this.m_fitWatcher.setFit(fitter);
                    fitter.start();
                } else {
                    FitManager.this.m_fitWatcher.clearFit().dispose();
                }
            }
        }
    }

    private class ParamManager
    extends JPanel {
        private JTable m_table;
        private Basic1DFunction m_f = null;
        private ParamTableModel m_model;

        ParamManager() {
            this.setLayout(new BorderLayout());
            this.m_model = new ParamTableModel();
            this.m_table = new JTable(this.m_model);
            this.m_table.setAutoCreateColumnsFromModel(false);
            TableColumn col = this.m_table.getColumn("Value");
            col.setCellRenderer(new ParamCellRenderer());
            col.setCellEditor(new DefaultCellEditor(new JTextField("")));
            JScrollPane scrollpane = new JScrollPane(this.m_table);
            scrollpane.setPreferredSize(new Dimension(350, 100));
            this.add("Center", scrollpane);
        }

        void doDataExchange(boolean set, Basic1DFunction f) {
            if (this.m_f != f) {
                this.m_model.setFunction(f);
                this.m_f = f;
            }
        }

        void deactivate() {
            this.m_model.deactivate();
            this.m_f = null;
        }

        private class FitHeaderRenderer
        implements TableCellRenderer {
            private TableCellRenderer m_renderer;
            private JTable m_table;

            FitHeaderRenderer(JTable table, TableCellRenderer renderer) {
                this.m_table = table;
                this.m_renderer = renderer;
            }

            @Override
            public Component getTableCellRendererComponent(JTable table, Object obj, boolean sel, boolean hasFocus, int col, int row) {
                if (table == null) {
                    table = this.m_table;
                }
                return this.m_renderer.getTableCellRendererComponent(table, obj, sel, hasFocus, col, row);
            }
        }

        private class ParamCellRenderer
        implements TableCellRenderer {
            private JASTextField text = new JASTextField();
            private Color f = this.text.getForeground();
            private Color b = this.text.getBackground();

            private ParamCellRenderer() {
            }

            @Override
            public Component getTableCellRendererComponent(JTable table, Object obj, boolean sel, boolean hasFocus, int col, int row) {
                if (obj != null) {
                    this.text.setText(obj.toString());
                }
                if (sel) {
                    this.text.setBackground(UIManager.getColor("textHighlight"));
                    this.text.setForeground(UIManager.getColor("textHighlightText"));
                } else {
                    this.text.setBackground(this.b);
                    this.text.setForeground(this.f);
                }
                this.text.setScrollOffset(0);
                return this.text;
            }
        }
    }

    private class ParamTableModel
    extends AbstractTableModel
    implements Observer {
        private String[] columns = new String[]{"Parameter", "Value", "Fit", "Error"};
        private Basic1DFunction f = null;

        ParamTableModel() {
            JASHistPropFunctions.this.format.setMaximumFractionDigits(6);
        }

        void setFunction(Basic1DFunction f) {
            if (f != null) {
                f.deleteObserver(this);
            }
            this.f = f;
            f.addObserver(this);
            this.fireTableChanged(new TableModelEvent(this, -1));
        }

        void deactivate() {
            if (this.f != null) {
                this.f.deleteObserver(this);
            }
        }

        @Override
        public void update(Observable obs, Object arg) {
            if (obs == this.f) {
                this.fireTableChanged(new TableModelEvent(this, -1));
            }
        }

        @Override
        public int getRowCount() {
            if (this.f == null) {
                return 0;
            }
            String[] names = this.f.getParameterNames();
            return names == null ? 0 : names.length;
        }

        @Override
        public int getColumnCount() {
            return this.columns.length;
        }

        @Override
        public Object getValueAt(int row, int col) {
            Fittable1DFunction func;
            Fitter fit;
            if (col == 0) {
                return this.f.getParameterNames()[row];
            }
            if (col == 1) {
                return JASHistPropFunctions.this.format.format(this.f.getParameterValues()[row]);
            }
            if (col == 2) {
                boolean value = this.f instanceof Fittable1DFunction ? ((Fittable1DFunction)this.f).getIncludeParametersInFit()[row] : false;
                return new Boolean(value);
            }
            if (col == 3 && this.f instanceof Fittable1DFunction && (fit = (func = (Fittable1DFunction)this.f).getFit()) != null) {
                boolean[] inFit = func.getIncludeParametersInFit();
                if (!inFit[row]) {
                    return "Not in fit";
                }
                int j = 0;
                for (int i = 0; i < row; ++i) {
                    if (!inFit[i]) continue;
                    ++j;
                }
                return JASHistPropFunctions.this.format.format(fit.getParameterSigmas()[j]);
            }
            return null;
        }

        @Override
        public String getColumnName(int col) {
            return this.columns[col];
        }

        public Class getColumnClass(int col) {
            if (col == 2) {
                return Boolean.class;
            }
            if (col == 1) {
                return String.class;
            }
            return super.getColumnClass(col);
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col == 2 || col == 1;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            if (col == 1) {
                try {
                    double d = Double.valueOf((String)value);
                    this.f.setParameter(row, d);
                }
                catch (InvalidFunctionParameter e) {
                    JASHistPropFunctions.this.getToolkit().beep();
                }
                catch (NumberFormatException e) {
                    JASHistPropFunctions.this.getToolkit().beep();
                }
            } else if (col == 2) {
                if (this.f instanceof Fittable1DFunction) {
                    boolean b = (Boolean)value;
                    ((Fittable1DFunction)this.f).setIncludeParameterInFit(row, b);
                } else {
                    JASHistPropFunctions.this.getToolkit().beep();
                }
            }
        }
    }

    private class RemoveButtonListener
    implements ActionListener {
        private RemoveButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            JASHistPropFunctions.this.removeFunction();
        }
    }

    private class AddButtonListener
    implements ActionListener {
        private AddButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            FunctionRegistry fr = FunctionRegistry.instance();
            Container w = JASHistPropFunctions.this;
            while (!(w instanceof Frame)) {
                w = w.getParent();
            }
            FunctionFactory ff = fr.chooseFunction((Frame)w);
            if (ff != null) {
                try {
                    Basic1DFunction f = ff.createFunction(JASHistPropFunctions.this.m_jHist);
                    JASHistData d = JASHistPropFunctions.this.m_jHist.addData(f);
                    d.show(true);
                    JASHistPropFunctions.this.addFunction((JASHist1DFunctionData)d);
                    if (f instanceof FunctionAdvancedOptions) {
                        f.addObserver(JASHistPropFunctions.this.m_listNameChangeListener);
                    }
                }
                catch (FunctionFactoryError x) {
                    x.printStackTrace();
                }
            }
        }
    }
}

