/*
 * Decompiled with CFR 0.152.
 */
package jas2.hist;

import jas2.hist.DataSource;
import jas2.hist.JASHist;
import jas2.hist.JASHistData;
import jas2.hist.ScatterDataManager;
import jas2.hist.StatisticsBlock;
import jas2.plot.DataArea;
import jas2.plot.DateAxis;
import jas2.plot.DoubleAxis;
import jas2.plot.Legend;
import java.util.TimeZone;

final class DateScatterDataManager
extends ScatterDataManager {
    private DateAxis xAxisType;

    DateScatterDataManager(JASHist plot, DataArea da, Legend l, StatisticsBlock stats) {
        super(plot, da, l, stats);
        DoubleAxis yAxisType;
        if (this.xm.getType() instanceof DateAxis) {
            this.xAxisType = (DateAxis)this.xm.getType();
        } else {
            this.xAxisType = new DateAxis();
            this.xm.setType(this.xAxisType);
        }
        if (this.ym[0].getType() instanceof DoubleAxis) {
            yAxisType = (DoubleAxis)this.ym[0].getType();
        } else {
            yAxisType = new DoubleAxis();
            this.ym[0].setType(yAxisType);
        }
        this.xm.setDataManager(this, false, this.xAxisType);
        this.ym[0].setDataManager(this, false, yAxisType);
    }

    @Override
    protected final void calcMinMaxXBins(double x1, double x2) {
        long iLow = (long)(x1 * 1000.0);
        long iHigh = (long)(x2 * 1000.0);
        long oldXMin = this.xAxisType.getAxisMin();
        long oldXMax = this.xAxisType.getAxisMax();
        if (iLow < oldXMin || iHigh > oldXMax || (double)((iHigh - iLow) / (oldXMax - oldXMin)) < 0.75) {
            this.xAxisType.setMin(iLow);
            this.xAxisType.setMax(iHigh);
            this.xm.invalidate();
        }
    }

    @Override
    JASHistData add(DataSource ds) {
        JASHistData jhd = super.add(ds);
        TimeZone tz = jhd.getStyle().getTimeZone();
        if (tz != null) {
            this.xAxisType.setTimeZone(tz);
        }
        return jhd;
    }

    @Override
    void styleUpdate(JASHistData data) {
        TimeZone tz = data.getStyle().getTimeZone();
        if (tz != null) {
            this.xAxisType.setTimeZone(tz);
        }
        super.styleUpdate(data);
    }
}

