/*
 * Decompiled with CFR 0.152.
 */
package jas2.hist;

import jas2.util.xml.XMLNodeTraverser;
import java.util.StringTokenizer;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

class Bins1DNodeTraverser
extends XMLNodeTraverser {
    private String title;
    private double[][] data;

    Bins1DNodeTraverser(Node node) throws XMLNodeTraverser.BadXMLException {
        this.traverse(node);
    }

    @Override
    protected void handleAttributeNode(Attr node, String name, String value) throws XMLNodeTraverser.BadXMLException {
        if (name.equals("title")) {
            this.title = value;
        } else {
            super.handleAttributeNode(node, name, value);
        }
    }

    @Override
    protected void handleTextNode(Text node, String name) throws XMLNodeTraverser.BadXMLException {
        StringTokenizer lineTokens = new StringTokenizer(node.getData());
        int lines = lineTokens.countTokens();
        int l = 0;
        while (lineTokens.hasMoreTokens()) {
            StringTokenizer valueTokens = new StringTokenizer(lineTokens.nextToken().trim(), ",");
            int n = valueTokens.countTokens();
            if (this.data == null) {
                this.data = new double[n][lines];
            } else if (n != this.data.length) {
                throw new XMLNodeTraverser.BadXMLException("Inconsistent number of entries in bins1d data at line " + l);
            }
            for (int i = 0; i < n; ++i) {
                this.data[i][l] = this.toDouble(valueTokens.nextToken());
            }
            ++l;
        }
    }

    String getTitle() {
        return this.title;
    }

    double[][] getData() {
        return this.data;
    }
}

