/*
 * Decompiled with CFR 0.152.
 */
package jas2.hep;

import hepjas.analysis.Style;
import hepjas.analysis.partition.Abstract2DPartition;
import jas2.hep.PartitionAdapter;
import jas2.hist.CustomOverlay;
import jas2.hist.HasStyle;
import jas2.hist.JASHist2DHistogramStyle;
import jas2.hist.JASHistStyle;
import jas2.hist.Rebinnable2DHistogramData;
import java.awt.Color;

public class Partition2DAdapter
extends PartitionAdapter
implements Rebinnable2DHistogramData,
HasStyle {
    private Abstract2DPartition m_partition;

    public Partition2DAdapter(Abstract2DPartition p) {
        super(p);
        this.m_partition = p;
    }

    @Override
    public double[][][] rebin(int xbins, double xmin, double xmax, int ybins, double ymin, double ymax, boolean wantErrors, boolean hurry, boolean overflow) {
        int size = 1;
        if (this.m_partition.isRebinnable()) {
            this.m_partition.setXBinning(xbins, xmin, xmax);
            this.m_partition.setYBinning(ybins, ymin, ymax);
        }
        double[][][] result = new double[size][][];
        result[0] = this.m_partition.getBins();
        return result;
    }

    @Override
    public boolean isRebinnable() {
        return this.m_partition.isRebinnable();
    }

    @Override
    public double getXMin() {
        return this.m_partition.getXMin();
    }

    @Override
    public double getXMax() {
        return this.m_partition.getXMax();
    }

    @Override
    public double getYMin() {
        return this.m_partition.getYMin();
    }

    @Override
    public double getYMax() {
        return this.m_partition.getYMax();
    }

    @Override
    public int getXBins() {
        return this.m_partition.getNumberOfXBins();
    }

    @Override
    public int getYBins() {
        return this.m_partition.getNumberOfYBins();
    }

    @Override
    public int getXAxisType() {
        return this.m_partition.getXAxisType();
    }

    @Override
    public int getYAxisType() {
        return this.m_partition.getYAxisType();
    }

    @Override
    public String[] getXAxisLabels() {
        return null;
    }

    @Override
    public String[] getYAxisLabels() {
        return null;
    }

    @Override
    public JASHistStyle getStyle() {
        Style s = this.m_partition.getStyle();
        if (s == null) {
            return null;
        }
        JASHist2DHistogramStyle hs = this.createStyle();
        if (s.get("histStyle") != null) {
            hs.setHistStyle((Integer)s.get("histStyle"));
        }
        if (s.get("colorMapScheme") != null) {
            hs.setColorMapScheme((Integer)s.get("colorMapScheme"));
        }
        if (s.get("shapeColor") != null) {
            hs.setShapeColor((Color)s.get("shapeColor"));
        }
        if (s.get("overflowBinColor") != null) {
            hs.setOverflowBinColor((Color)s.get("overflowBinColor"));
        }
        if (s.get("startDataColor") != null) {
            hs.setStartDataColor((Color)s.get("startDataColor"));
        }
        if (s.get("endDataColor") != null) {
            hs.setEndDataColor((Color)s.get("endDataColor"));
        }
        if (s.get("showOverflow") != null) {
            hs.setShowOverflow((Boolean)s.get("showOverflow"));
        }
        if (s.get("customOverlay") != null) {
            hs.setCustomOverlay((CustomOverlay)s.get("customOverlay"));
        }
        return hs;
    }

    protected JASHist2DHistogramStyle createStyle() {
        return new JASHist2DHistogramStyle();
    }
}

