/*
 * Decompiled with CFR 0.152.
 */
package jas2.hep;

import hepjas.analysis.Style;
import hepjas.analysis.partition.Abstract1DPartition;
import jas2.hep.PartitionAdapter;
import jas2.hist.CustomOverlay;
import jas2.hist.HasStyle;
import jas2.hist.JASHist1DHistogramStyle;
import jas2.hist.JASHistStyle;
import jas2.hist.Rebinnable1DHistogramData;
import java.awt.Color;

class Partition1DAdapter
extends PartitionAdapter
implements Rebinnable1DHistogramData,
HasStyle {
    private Abstract1DPartition m_partition;

    Partition1DAdapter(Abstract1DPartition p) {
        super(p);
        this.m_partition = p;
    }

    @Override
    public double[][] rebin(int bins, double min, double max, boolean wantErrors, boolean hurry) {
        int size = 1;
        if (this.m_partition.isRebinnable()) {
            this.m_partition.setBinning(bins, min, max);
        }
        if (wantErrors) {
            size = this.m_partition.hasSimpleQuadraticErrorBars() ? 1 : (this.m_partition.hasAsymmetricErrorBars() ? 3 : 2);
        }
        double[][] result = new double[size][];
        result[0] = this.m_partition.getBins();
        if (size > 1) {
            result[1] = this.m_partition.getPlusErrors();
        }
        if (size > 2) {
            result[2] = this.m_partition.getMinusErrors();
        }
        return result;
    }

    @Override
    public double getMin() {
        return this.m_partition.getMin();
    }

    @Override
    public double getMax() {
        return this.m_partition.getMax();
    }

    @Override
    public int getBins() {
        return this.m_partition.getNumberOfBins();
    }

    @Override
    public int getAxisType() {
        return this.m_partition.getAxisType();
    }

    @Override
    public boolean isRebinnable() {
        return this.m_partition.isRebinnable();
    }

    @Override
    public String[] getAxisLabels() {
        return this.m_partition.getAxisLabels();
    }

    @Override
    public JASHistStyle getStyle() {
        Style s = this.m_partition.getStyle();
        if (s == null) {
            return null;
        }
        JASHist1DHistogramStyle hs = new JASHist1DHistogramStyle();
        if (s.get("dataPointColor") != null) {
            hs.setDataPointColor((Color)s.get("dataPointColor"));
        }
        if (s.get("errorBarColor") != null) {
            hs.setErrorBarColor((Color)s.get("errorBarColor"));
        }
        if (s.get("histogramBarColor") != null) {
            hs.setHistogramBarColor((Color)s.get("histogramBarColor"));
        }
        if (s.get("lineColor") != null) {
            hs.setLineColor((Color)s.get("lineColor"));
        }
        if (s.get("showErrorBars") != null) {
            hs.setShowErrorBars((Boolean)s.get("showErrorBars"));
        }
        if (s.get("showHistogramBars") != null) {
            hs.setShowHistogramBars((Boolean)s.get("showHistogramBars"));
        }
        if (s.get("showLinesBetweenPoints") != null) {
            hs.setShowLinesBetweenPoints((Boolean)s.get("showLinesBetweenPoints"));
        }
        if (s.get("showDataPoints") != null) {
            hs.setShowDataPoints((Boolean)s.get("showDataPoints"));
        }
        if (s.get("histogramFill") != null) {
            hs.setHistogramFill((Boolean)s.get("histogramFill"));
        }
        if (s.get("dataPointSize") != null) {
            hs.setDataPointSize((Integer)s.get("dataPointSize"));
        }
        if (s.get("dataPointSymbol") != null) {
            hs.setDataPointStyle((Integer)s.get("dataPointSymbol"));
        }
        if (s.get("customOverlay") != null) {
            hs.setCustomOverlay((CustomOverlay)s.get("customOverlay"));
        }
        return hs;
    }
}

