/*
 * Decompiled with CFR 0.152.
 */
package htmllayout;

class Scanner {
    static final int LT = 0;
    static final int GT = 1;
    static final int EQ = 3;
    static final int STR = 4;
    static final int EOF = -1;
    static final int ERROR = -2;
    String currentString;
    int lastTok;
    boolean inTag;
    String source;
    int pos;
    int end;

    Scanner(String source) {
        this.source = source;
        this.end = source.length();
    }

    int scanU() {
        int s = this.scan();
        if (s == 4) {
            this.currentString = this.currentString.toUpperCase();
        }
        return s;
    }

    int scan() {
        this.lastTok = this.sscan();
        return this.lastTok;
    }

    private int sscan() {
        block6: while (true) {
            if (this.pos == this.end) {
                return -1;
            }
            switch (this.source.charAt(this.pos)) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    ++this.pos;
                    continue block6;
                }
                case '<': {
                    if (this.inTag) {
                        return -2;
                    }
                    ++this.pos;
                    this.inTag = true;
                    return 0;
                }
                case '>': {
                    if (!this.inTag) {
                        return -2;
                    }
                    ++this.pos;
                    this.inTag = false;
                    return 1;
                }
                case '=': {
                    if (!this.inTag) break block6;
                    ++this.pos;
                    return 3;
                }
            }
            break;
        }
        return this.doString();
    }

    private int doString() {
        char c;
        boolean usingQuote;
        boolean bl = usingQuote = this.inTag && this.source.charAt(this.pos) == '\"';
        if (usingQuote) {
            ++this.pos;
        }
        int start = this.pos;
        while (!(this.pos >= this.end || (c = this.source.charAt(this.pos)) == '>' || c == '<' || this.inTag && c == '=')) {
            if (c == '\"' && usingQuote) {
                this.currentString = this.source.substring(start, this.pos);
                ++this.pos;
                return 4;
            }
            if (this.inTag && !usingQuote && this.isWhitespace(c)) break;
            ++this.pos;
        }
        this.currentString = this.source.substring(start, this.pos);
        if (!this.inTag) {
            this.currentString = this.currentString.trim();
        }
        if (this.currentString.length() == 0) {
            return this.scan();
        }
        return 4;
    }

    private boolean isWhitespace(char c) {
        return c <= ' ' && (c == ' ' || c == '\t' || c == '\n' || c == '\r' || c == '\f');
    }
}

