/*
 * Decompiled with CFR 0.152.
 */
package htmllayout;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.RandomAccessFile;

public class ProcHtml {
    public static void main(String[] args) throws Exception {
        if (args.length == 0 || args[0].length() == 0) {
            System.err.println("ProcHtml [-numtabs] filename [...]");
            System.err.println("\tReads in each file \"filename\" and writes it out to a file\n\t\"filename.out\" in a Java String suitable for embedding\n\tin a Java source file.");
        }
        int numtabs = 2;
        int firstArg = 0;
        if (args[0].charAt(0) == '-') {
            numtabs = Integer.parseInt(args[0].substring(1));
            ++firstArg;
        }
        for (int i = firstArg; i < args.length; ++i) {
            String s;
            RandomAccessFile in = new RandomAccessFile(args[i], "r");
            BufferedWriter out = new BufferedWriter(new FileWriter(args[i] + ".out"));
            boolean first = true;
            while ((s = in.readLine()) != null) {
                int q;
                if (!first) {
                    out.write(" +\n");
                }
                for (int t = 0; t < numtabs; ++t) {
                    out.write(9);
                }
                out.write("\" ");
                int p = 0;
                while ((q = s.indexOf("\"", p)) != -1) {
                    out.write(s.substring(p, q));
                    out.write("\\\"");
                    p = q + 1;
                }
                out.write(s.substring(p));
                out.write(" \"");
                first = false;
            }
            out.write(";\n");
            in.close();
            out.close();
        }
    }
}

