/*
 * Decompiled with CFR 0.152.
 */
package hepjas.physics;

import hepjas.physics.Particle;
import hepjas.physics.ParticleEnumeration;
import java.io.PrintStream;
import java.io.PrintWriter;

public class HEPUtilities {
    private HEPUtilities() {
    }

    public static void dumpParticleHierarchy(Particle p) {
        HEPUtilities.dumpParticleHierarchy(p, System.out);
    }

    public static void dumpParticleHierarchy(Particle p, PrintStream out) {
        PrintWriter pw = new PrintWriter(out);
        HEPUtilities.dumpParticleHierarchy(p, pw);
        pw.flush();
    }

    public static void dumpParticleHierarchy(Particle p, PrintWriter out) {
        HEPUtilities.dumpParticleHierarchy(p, out, "", "");
    }

    private static void dumpParticleHierarchy(Particle p, PrintWriter out, String indent, String prefix) {
        out.println(indent + prefix + p.getType().toString());
        ParticleEnumeration e = p.getDaughters();
        boolean more = e.hasMoreParticles();
        while (more) {
            Particle next = e.nextParticle();
            more = e.hasMoreParticles();
            HEPUtilities.dumpParticleHierarchy(next, out, indent + (prefix.equals("+--") ? "|  " : "   "), more ? "+--" : "\\--");
        }
    }
}

