/*
 * Decompiled with CFR 0.152.
 */
package hepjas.physics;

import hepjas.physics.BasicHep3Vector;
import hepjas.physics.Hep3Vector;
import hepjas.physics.HepLorentzVector;
import hepjas.physics.VecOp;
import java.io.Serializable;

public class BasicHepLorentzVector
implements HepLorentzVector,
Serializable {
    private double m_dt;
    private Hep3Vector m_v;
    private boolean m_vIsOwned = false;

    public BasicHepLorentzVector() {
        this.m_dt = 0.0;
        this.m_v = new BasicHep3Vector();
        this.m_vIsOwned = true;
    }

    public BasicHepLorentzVector(double t, double x, double y, double z) {
        this.m_dt = t;
        this.m_v = new BasicHep3Vector(x, y, z);
        this.m_vIsOwned = true;
    }

    public BasicHepLorentzVector(double t, Hep3Vector v) {
        this.m_dt = t;
        this.m_v = v;
        this.m_vIsOwned = false;
    }

    public void setV3(double t, double x, double y, double z) {
        this.m_dt = t;
        if (this.m_vIsOwned) {
            ((BasicHep3Vector)this.m_v).setV(x, y, z);
        } else {
            this.m_v = new BasicHep3Vector(x, y, z);
            this.m_vIsOwned = true;
        }
    }

    public void setV3(double t, Hep3Vector v) {
        this.m_dt = t;
        this.m_v = v;
        this.m_vIsOwned = false;
    }

    public void setT(double t) {
        this.m_dt = t;
    }

    @Override
    public double t() {
        return this.m_dt;
    }

    @Override
    public Hep3Vector v3() {
        return this.m_v;
    }

    @Override
    public double lorMag2() {
        return VecOp.dot(this, this);
    }

    @Override
    public double lorMag() {
        return Math.sqrt(this.lorMag2());
    }
}

