/*
 * Decompiled with CFR 0.152.
 */
package hepjas.physics;

import hepjas.physics.Hep3Matrix;

public class BasicHep3Matrix
implements Hep3Matrix {
    private double[][] m_dmat = new double[3][3];

    public BasicHep3Matrix() {
        for (int i = 0; i < 3; ++i) {
            for (int j = i; j < 3; ++j) {
                this.m_dmat[i][j] = 0.0;
            }
        }
    }

    public BasicHep3Matrix(double e11, double e12, double e13, double e21, double e22, double e23, double e31, double e32, double e33) {
        this.m_dmat[0][0] = e11;
        this.m_dmat[0][1] = e12;
        this.m_dmat[0][2] = e13;
        this.m_dmat[1][0] = e21;
        this.m_dmat[1][1] = e22;
        this.m_dmat[1][2] = e23;
        this.m_dmat[2][0] = e31;
        this.m_dmat[2][1] = e32;
        this.m_dmat[2][2] = e33;
    }

    @Override
    public double e(int row, int column) {
        if (row < 1 | 3 < row) {
            throw new IllegalArgumentException("Row index out of bounds.");
        }
        if (column < 1 | 3 < column) {
            throw new IllegalArgumentException("Column index out of bounds.");
        }
        return this.m_dmat[row - 1][column - 1];
    }

    @Override
    public double det() {
        double cofact1 = this.m_dmat[1][1] * this.m_dmat[2][2] - this.m_dmat[1][2] * this.m_dmat[2][1];
        double cofact2 = this.m_dmat[0][1] * this.m_dmat[2][2] - this.m_dmat[0][2] * this.m_dmat[2][1];
        double cofact3 = this.m_dmat[0][1] * this.m_dmat[1][2] - this.m_dmat[0][2] * this.m_dmat[1][1];
        return this.m_dmat[0][0] * cofact1 - this.m_dmat[1][0] * cofact2 + this.m_dmat[2][0] * cofact3;
    }

    @Override
    public double trace() {
        return this.m_dmat[0][0] + this.m_dmat[1][1] + this.m_dmat[2][2];
    }

    public void setElement(int row, int column, int value) {
        if (row < 1 | 3 < row) {
            throw new IllegalArgumentException("Row index out of bounds.");
        }
        if (column < 1 | 3 < column) {
            throw new IllegalArgumentException("Column index out of bounds.");
        }
        this.m_dmat[row - 1][column - 1] = value;
    }

    public void setPassiveEuler(double phi, double theta, double psi) {
        double cth = Math.cos(theta);
        double sth = Math.sin(theta);
        double cphi = Math.cos(phi);
        double sphi = Math.sin(phi);
        double cpsi = Math.cos(psi);
        double spsi = Math.sin(psi);
        this.m_dmat[0][0] = cpsi * cphi - cth * sphi * spsi;
        this.m_dmat[0][1] = cpsi * sphi + cth * cphi * spsi;
        this.m_dmat[0][2] = spsi * sth;
        this.m_dmat[1][0] = -spsi * cphi - cth * sphi * cpsi;
        this.m_dmat[1][1] = -spsi * sphi + cth * cphi * cpsi;
        this.m_dmat[1][2] = cpsi * sth;
        this.m_dmat[2][0] = sth * sphi;
        this.m_dmat[2][1] = -sth * cphi;
        this.m_dmat[2][2] = cth;
    }

    public void setActiveEuler(double phi, double theta, double psi) {
        double cth = Math.cos(theta);
        double sth = Math.sin(theta);
        double cphi = Math.cos(phi);
        double sphi = Math.sin(phi);
        double cpsi = Math.cos(psi);
        double spsi = Math.sin(psi);
        this.m_dmat[0][0] = cpsi * cphi - cth * sphi * spsi;
        this.m_dmat[1][0] = cpsi * sphi + cth * cphi * spsi;
        this.m_dmat[2][0] = spsi * sth;
        this.m_dmat[0][1] = -spsi * cphi - cth * sphi * cpsi;
        this.m_dmat[1][1] = -spsi * sphi + cth * cphi * cpsi;
        this.m_dmat[2][1] = cpsi * sth;
        this.m_dmat[0][2] = sth * sphi;
        this.m_dmat[1][2] = -sth * cphi;
        this.m_dmat[2][2] = cth;
    }
}

