/*
 * Decompiled with CFR 0.152.
 */
package hepjas.analysis.standalone;

import hepjas.analysis.EndOfDataException;
import hepjas.analysis.EventAnalyzer;
import hepjas.analysis.EventData;
import hepjas.analysis.EventSource;
import hepjas.analysis.Job;
import hepjas.analysis.NamedObject;
import hepjas.analysis.PeerSupport;
import hepjas.analysis.peer.JobPeer;
import hepjas.analysis.standalone.NoEventSourceSet;
import java.io.OutputStream;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;

class StandAloneJob
implements JobPeer {
    private static StandAloneJob theJob;
    private Job m_hepJob;
    private EventSource m_source;
    private Vector m_analyzer = new Vector();
    private String m_name;
    private boolean m_atStart;

    StandAloneJob(String name, Job job) {
        this.m_name = name;
        theJob = this;
        this.m_hepJob = job;
    }

    @Override
    public void sendMessage(String message) {
        System.out.println(message);
    }

    @Override
    public OutputStream getLogStream() {
        return System.out;
    }

    @Override
    public void setEventSource(EventSource s) {
        this.m_source = s;
        this.m_atStart = true;
    }

    @Override
    public void addEventAnalyzer(EventAnalyzer a) {
        this.m_analyzer.addElement(a);
    }

    @Override
    public void removeEventAnalyzer(EventAnalyzer a) {
        this.m_analyzer.removeElement(a);
    }

    @Override
    public void removeAllEventAnalyzers() {
        this.m_analyzer.removeAllElements();
    }

    private void resetFolders() {
        PeerSupport.resetFolders(this.m_hepJob);
    }

    private void goEnded() {
        PeerSupport.done(this.m_hepJob);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void go(int n) {
        int i;
        if (n < 0) {
            throw new IllegalArgumentException("Argument to go < 0");
        }
        if (this.m_source == null) {
            throw new NoEventSourceSet();
        }
        if (this.m_atStart) {
            this.beforeFirstEvent();
            this.m_atStart = false;
        }
        Date start = new Date();
        System.out.println("Start go at: " + start);
        try {
            for (i = 0; n == 0 || i < n; ++i) {
                EventData data = this.m_source.getNextEvent();
                this.processEvent(data);
            }
        }
        catch (EndOfDataException e) {
            this.afterLastEvent();
        }
        finally {
            this.goEnded();
        }
        Date end = new Date();
        System.out.println("End go at: " + end);
        System.out.println("Analyzed " + i + " events in " + (end.getTime() - start.getTime()) + " milliSeconds");
    }

    @Override
    public void rewind() {
        this.m_atStart = true;
    }

    private void beforeFirstEvent() {
        this.m_source.beforeFirstEvent();
        Enumeration e = this.m_analyzer.elements();
        while (e.hasMoreElements()) {
            EventAnalyzer a = (EventAnalyzer)e.nextElement();
            this.resetFolders();
            a.beforeFirstEvent();
        }
    }

    private void afterLastEvent() {
        this.m_source.afterLastEvent();
        Enumeration e = this.m_analyzer.elements();
        while (e.hasMoreElements()) {
            EventAnalyzer a = (EventAnalyzer)e.nextElement();
            this.resetFolders();
            a.afterLastEvent();
        }
    }

    private void processEvent(EventData data) {
        Enumeration e = this.m_analyzer.elements();
        while (e.hasMoreElements()) {
            EventAnalyzer a = (EventAnalyzer)e.nextElement();
            this.resetFolders();
            a.processEvent(data);
        }
    }

    @Override
    public void addNotify(NamedObject h) {
    }

    @Override
    public void removeNotify(NamedObject h) {
    }

    @Override
    public void changeNotify(NamedObject h, String oldName) {
    }
}

