/*
 * Decompiled with CFR 0.152.
 */
package hepjas.analysis.partition;

import hepjas.analysis.partition.AbstractTwoDFillable;
import hepjas.analysis.partition.PartitionEnumeration;
import hepjas.analysis.partition.PartitionFillException;
import hepjas.analysis.partition.PartitionVector;
import hepjas.analysis.partition.ScatterEnumeration;
import hepjas.analysis.partition.TwoDFillable;
import hepjas.analysis.partition.TwoDStorer;

public class SimpleScatterStorer
extends AbstractTwoDFillable
implements TwoDStorer {
    private PartitionVector m_simple = new PartitionVector(2);
    private double[] m_currentSimple;
    private int m_countSimple;
    private int m_simpleEntriesFilled;
    static final long serialVersionUID = 7972941040483599277L;

    public SimpleScatterStorer() {
        this.clear();
    }

    @Override
    public void fill(double x, double y) {
        try {
            this.m_currentSimple[this.m_countSimple++] = x;
            this.m_currentSimple[this.m_countSimple++] = y;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.m_currentSimple = this.m_simple.newArray();
            this.m_countSimple = 0;
            this.m_currentSimple[this.m_countSimple++] = x;
            this.m_currentSimple[this.m_countSimple++] = y;
        }
        ++this.m_simpleEntriesFilled;
    }

    @Override
    public void fillW(double x, double y, double weight) {
        throw new PartitionFillException();
    }

    @Override
    public void fillData(TwoDFillable fill) {
        PartitionEnumeration e = this.m_simple.elements();
        e.setEndPoint(this.m_simpleEntriesFilled);
        while (e.hasMoreElements()) {
            fill.fill(e.nextValue(), e.nextValue());
        }
    }

    public ScatterEnumeration startEnumeration() {
        final PartitionEnumeration enum1 = this.m_simple.elements();
        enum1.setEndPoint(this.m_simpleEntriesFilled);
        return new ScatterEnumeration(){

            @Override
            public final boolean getNextPoint(double[] a) {
                if (!enum1.hasMoreElements()) {
                    return false;
                }
                a[0] = enum1.nextValue();
                a[1] = enum1.nextValue();
                return true;
            }

            @Override
            public final void resetEndPoint() {
                enum1.setEndPoint(SimpleScatterStorer.this.m_simpleEntriesFilled);
            }

            @Override
            public final void restart() {
                enum1.restart();
            }
        };
    }

    public ScatterEnumeration startEnumeration(final double xMin, final double xMax, final double yMin, final double yMax) {
        final PartitionEnumeration enum1 = this.m_simple.elements();
        enum1.setEndPoint(this.m_simpleEntriesFilled);
        return new ScatterEnumeration(){

            @Override
            public final boolean getNextPoint(double[] a) {
                double y;
                double x;
                do {
                    if (!enum1.hasMoreElements()) {
                        return false;
                    }
                    x = enum1.nextValue();
                    y = enum1.nextValue();
                } while (x < xMin || x > xMax || y < yMin || y > yMax);
                a[0] = x;
                a[1] = y;
                return true;
            }

            @Override
            public final void resetEndPoint() {
                enum1.setEndPoint(SimpleScatterStorer.this.m_simpleEntriesFilled);
            }

            @Override
            public final void restart() {
                enum1.restart();
            }
        };
    }

    @Override
    public void clear() {
        this.m_simple.clear();
        this.m_currentSimple = this.m_simple.newArray();
        this.m_countSimple = 0;
        this.m_simpleEntriesFilled = 0;
    }
}

