/*
 * Decompiled with CFR 0.152.
 */
package hepjas.analysis.partition;

import hepjas.analysis.NoSuchBinException;
import hepjas.analysis.Partition;
import hepjas.analysis.partition.BinType;
import hepjas.analysis.partition.PartitionFillException;
import hepjas.analysis.partition.SimplePartition;
import java.util.Date;

public class SimpleDatePartition
extends SimplePartition {
    static final long serialVersionUID = -4393124536374441534L;

    public SimpleDatePartition() {
    }

    public SimpleDatePartition(int bins) {
        super(bins);
    }

    public SimpleDatePartition(BinType type) {
        super(type);
    }

    public SimpleDatePartition(Date min, Date max) {
        super((double)min.getTime() / 1000.0, (double)max.getTime() / 1000.0);
    }

    public SimpleDatePartition(Date min, Date max, int bins) {
        super((double)min.getTime() / 1000.0, (double)max.getTime() / 1000.0, bins);
    }

    public SimpleDatePartition(Date min, Date max, BinType type) {
        super((double)min.getTime() / 1000.0, (double)max.getTime() / 1000.0, type);
    }

    @Override
    public void fill(Date x) {
        super.fill((double)x.getTime() / 1000.0);
    }

    @Override
    public void fillW(Date x, double v) {
        super.fillW((double)x.getTime() / 1000.0, v);
    }

    @Override
    public void fill(double x, double v) {
        throw new PartitionFillException(this);
    }

    public void fill(int x, double v) {
        throw new PartitionFillException(this);
    }

    @Override
    public int getBinAt(Date x) throws NoSuchBinException {
        return super.getBinAt((double)x.getTime() / 1000.0);
    }

    @Override
    public int getBinAt(double x) throws NoSuchBinException {
        throw new PartitionFillException(this);
    }

    @Override
    public int getAxisType() {
        return 3;
    }

    @Override
    public Partition makeCopy() {
        if (this.m_autoRange) {
            return new SimpleDatePartition(this.m_defaultBins);
        }
        return new SimpleDatePartition(new Date((long)(this.m_min * 1000.0)), new Date((long)(this.m_max * 1000.0)), this.m_defaultBins);
    }
}

