/*
 * Decompiled with CFR 0.152.
 */
package hepjas.analysis.partition;

import hepjas.analysis.partition.AbstractBinFinder;
import hepjas.analysis.partition.BinInfo;

public class SimpleBinFinder
extends AbstractBinFinder
implements BinInfo {
    private double min;
    private double max;
    private double binWidth;
    private int bins;
    private int underflow;
    private int overflow;
    public static final int UNDERFLOW = -1;
    public static final int OVERFLOW = -2;
    static final long serialVersionUID = 3140155930261652478L;

    SimpleBinFinder(int bins, double min, double max, boolean overflowFlag) {
        this.bins = bins;
        this.min = min;
        this.max = max;
        this.binWidth = (max - min) / (double)bins;
        if (overflowFlag) {
            this.underflow = bins;
            this.overflow = bins + 1;
        } else {
            this.overflow = -2;
            this.underflow = -1;
        }
    }

    @Override
    public int getBinAt(double d) {
        int result = (int)Math.floor((d - this.min) / this.binWidth);
        if (result < 0) {
            result = this.underflow;
        } else if (result >= this.bins) {
            result = this.overflow;
        }
        return result;
    }

    @Override
    public double getMin() {
        return this.min;
    }

    @Override
    public double getMax() {
        return this.max;
    }

    @Override
    public int getNumberOfBins() {
        return this.bins;
    }
}

