/*
 * Decompiled with CFR 0.152.
 */
package hepjas.analysis.partition;

import hepjas.analysis.partition.PartitionEnumeration;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Vector;

final class PartitionVector
implements Serializable {
    private final Vector m_vector = new Vector();
    private final int m_arraySize;
    private final int m_batchSize;
    static final long serialVersionUID = 838382118100866710L;

    PartitionVector(int batchSize) {
        this.m_batchSize = batchSize;
        int approxArraySize = 500;
        this.m_arraySize = 500 - 500 % batchSize;
    }

    double[] newArray() {
        double[] array = new double[this.m_arraySize];
        this.m_vector.addElement(array);
        return array;
    }

    PartitionEnumeration elements() {
        return new PartitionEnumeration(){
            private int m_count = 0;
            private int m_end = 0;
            private Enumeration m_enum = PartitionVector.access$200(PartitionVector.this).elements();
            private double[] m_array;
            private int m_currentIndex = PartitionVector.access$100(PartitionVector.this);

            @Override
            public final void setEndPoint(int endPoint) {
                this.m_end = endPoint * PartitionVector.this.m_batchSize;
            }

            @Override
            public final boolean hasMoreElements() {
                return this.m_count < this.m_end;
            }

            @Override
            public final double nextValue() {
                if (++this.m_count > this.m_end) {
                    throw new NoSuchElementException("passed end point");
                }
                if (this.m_currentIndex == PartitionVector.this.m_arraySize) {
                    this.m_array = (double[])this.m_enum.nextElement();
                    this.m_currentIndex = 0;
                }
                return this.m_array[this.m_currentIndex++];
            }

            @Override
            public final int count() {
                return this.m_count / PartitionVector.this.m_batchSize;
            }

            @Override
            public final void restart() {
                this.m_count = 0;
                this.m_enum = PartitionVector.this.m_vector.elements();
                this.m_currentIndex = PartitionVector.this.m_arraySize;
            }
        };
    }

    void clear() {
        this.m_vector.removeAllElements();
    }
}

