/*
 * Decompiled with CFR 0.152.
 */
package hepjas.analysis.partition;

import hepjas.analysis.partition.AbstractOneDFillable;
import hepjas.analysis.partition.RangeChangeListener;
import hepjas.analysis.partition.Statistics;
import hepjas.analysis.partition.StatisticsProvider;

public class OneDStatisticsProvider
extends AbstractOneDFillable
implements StatisticsProvider {
    private double m_low;
    private double m_high;
    private double m_binWidth;
    private double m_totalWeight;
    private double m_mean;
    private double m_rms;
    private double m_min;
    private double m_max;
    private double m_underflow;
    private double m_overflow;
    private int m_entries;
    private RangeChangeListener m_range;
    static final long serialVersionUID = -5062359468376470137L;

    OneDStatisticsProvider(double low, double high, int bins) {
        this.clear();
        this.m_binWidth = (high - low) / (double)bins;
        this.m_low = low;
        this.m_high = high;
    }

    OneDStatisticsProvider() {
        this.clear();
    }

    OneDStatisticsProvider(RangeChangeListener l) {
        this.clear();
        this.m_range = l;
    }

    void setRangeChangeListener(RangeChangeListener l) {
        this.m_range = l;
    }

    @Override
    public void fillW(double x, double v) {
        boolean b2;
        this.m_totalWeight += v;
        this.m_mean += x * v;
        this.m_rms += x * x * v;
        if (x >= this.m_high) {
            this.m_overflow += v;
        }
        if (x < this.m_low) {
            this.m_underflow += v;
        }
        if (this.m_entries++ == 0) {
            this.m_min = this.m_max = x;
            if (this.m_range != null) {
                this.m_range.rangeChanged(x, x);
            }
            return;
        }
        boolean b1 = x < this.m_min;
        boolean bl = b2 = x > this.m_max;
        if (b1 || b2) {
            if (b1) {
                this.m_min = x;
            }
            if (b2) {
                this.m_max = x;
            }
            if (this.m_range != null) {
                this.m_range.rangeChanged(this.m_min, this.m_max);
            }
        }
    }

    @Override
    public void clear() {
        this.m_entries = 0;
        this.m_totalWeight = 0.0;
        this.m_binWidth = 0.0;
        this.m_mean = 0.0;
        this.m_rms = 0.0;
        this.m_min = 0.0;
        this.m_max = 0.0;
        this.m_underflow = 0.0;
        this.m_overflow = 0.0;
    }

    public int getEntries() {
        return this.m_entries;
    }

    public double getArea() {
        return this.m_totalWeight * this.m_binWidth;
    }

    public double getMean() {
        return this.m_mean / this.m_totalWeight;
    }

    public double getRMS() {
        return Math.sqrt(this.m_rms / this.m_totalWeight - this.m_mean * this.m_mean / this.m_totalWeight / this.m_totalWeight);
    }

    public double getMin() {
        return this.m_min;
    }

    public double getMax() {
        return this.m_max;
    }

    public double getUnderflow() {
        return this.m_underflow;
    }

    public double getOverflow() {
        return this.m_overflow;
    }

    @Override
    public Statistics getStatistics() {
        Statistics stats = new Statistics(6);
        stats.setStatistic("entries", this.getEntries());
        if (this.m_binWidth > 0.0) {
            stats.setStatistic("area", this.getArea());
            stats.setStatistic("overflow", this.getOverflow());
            stats.setStatistic("underflow", this.getUnderflow());
        } else {
            stats.setStatistic("min", this.getMin());
            stats.setStatistic("max", this.getMax());
        }
        stats.setStatistic("mean", this.getMean());
        stats.setStatistic("rms", this.getRMS());
        return stats;
    }
}

