/*
 * Decompiled with CFR 0.152.
 */
package hepjas.analysis.partition;

import hepjas.analysis.Partition;
import hepjas.analysis.partition.SimpleBinFinder;
import hepjas.analysis.partition.SimpleBinner;
import hepjas.analysis.partition.SimpleTwoDDataSourceAdapter;
import hepjas.analysis.partition.TwoDBinAdapter;
import hepjas.analysis.partition.TwoDBinTypeAdapter;
import hepjas.analysis.partition.TwoDDelegatingPartition;
import hepjas.analysis.partition.TwoDFillableTee;
import hepjas.analysis.partition.TwoDStatisticsProvider;

public class FixedPartition2D
extends TwoDDelegatingPartition {
    private SimpleBinFinder m_finderX;
    private SimpleBinFinder m_finderY;
    static final long serialVersionUID = 1906868307094838112L;

    public FixedPartition2D(double lowX, double highX, int binsX, double lowY, double highY, int binsY) {
        this(lowX, highX, lowY, highY, new TwoDBinTypeAdapter(new SimpleBinner(0), binsX, binsY));
    }

    public FixedPartition2D(double lowX, double highX, double lowY, double highY, TwoDBinTypeAdapter binner) {
        int binsX = binner.getNumberOfXBins();
        int binsY = binner.getNumberOfYBins();
        TwoDStatisticsProvider stats = new TwoDStatisticsProvider();
        this.m_finderX = new SimpleBinFinder(binsX, lowX, highX, false);
        this.m_finderY = new SimpleBinFinder(binsY, lowY, highY, false);
        TwoDBinAdapter filler = new TwoDBinAdapter(this.m_finderX, this.m_finderY, binner);
        TwoDFillableTee tee = new TwoDFillableTee(stats, filler);
        this.setFillable(tee);
        this.setStatisticsProvider(stats);
        this.setBinInfoX(this.m_finderX);
        this.setBinInfoY(this.m_finderY);
        this.setDataSource(new SimpleTwoDDataSourceAdapter(this.m_finderX, this.m_finderY, binner));
    }

    @Override
    public Partition makeCopy() {
        return new FixedPartition2D(this.m_finderX.getMin(), this.m_finderX.getMax(), this.m_finderX.getNumberOfBins(), this.m_finderY.getMin(), this.m_finderY.getMax(), this.m_finderY.getNumberOfBins());
    }
}

