/*
 * Decompiled with CFR 0.152.
 */
package hepjas.analysis;

import hepjas.analysis.Folder;
import hepjas.analysis.FolderException;
import hepjas.analysis.Job;
import java.io.PrintWriter;

abstract class FolderSet {
    private Job m_job;
    private Folder m_root;
    private Folder m_current;

    abstract Folder createFolder(Folder var1, String var2);

    FolderSet(Job job, String name) {
        this.m_job = job;
        this.m_root = this.m_current = this.createFolder(job.getJobFolder(), name);
    }

    Folder getRootFolder() {
        return this.m_root;
    }

    Folder getCurrentFolder() {
        return this.m_current;
    }

    Folder setCurrentFolder() {
        this.m_current = this.m_root;
        return this.m_current;
    }

    Folder setCurrentFolder(Folder f) {
        this.m_current = f;
        return f;
    }

    Folder setCurrentFolder(String s) throws FolderException {
        if (s.charAt(0) != '/') {
            return this.setCurrentFolder(this.m_current, s);
        }
        return this.setCurrentFolder(this.m_root, s.substring(1));
    }

    Folder setCurrentFolder(Folder f, String s) throws FolderException {
        Folder current = f;
        int currPos = 0;
        int index = 0;
        while (index >= 0) {
            String path;
            index = s.indexOf(47, currPos);
            String string = path = index < 0 ? s.substring(currPos) : s.substring(currPos, index);
            if (!path.equals("") && !path.equals(".")) {
                if (path.equals("..")) {
                    if ((current = current.getFolder()) == null) {
                        throw new FolderException("Cannot navigate up from root folder");
                    }
                } else {
                    Folder sub = current.findSubfolder(path);
                    if (sub == null) {
                        sub = this.createFolder(current, path);
                    }
                    current = sub;
                }
            }
            currPos = index + 1;
        }
        this.m_current = current;
        return current;
    }

    void dump(PrintWriter out) {
        this.m_root.dump(out, "");
    }
}

