/*
 * Decompiled with CFR 0.152.
 */
package hep.rootio.reps;

import hep.rootio.RootInput;
import hep.rootio.RootObjectRepresentation;
import hep.rootio.implementation.SpecificRootObject;
import java.io.IOException;
import java.util.AbstractList;

public class TObjArray
extends SpecificRootObject {
    private RootObjectRepresentation[] array;
    private int lowerBound;

    @Override
    public void readMembers(RootInput in, int v) throws IOException {
        if (v > 3) {
            throw new IOException("Version mismatch TObjArray: " + v);
        }
        if (v > 2) {
            this.put("fobject", in.readObject("TObject"));
        }
        if (v > 1) {
            this.put("fname", in.readObject("TString"));
        }
        int nobjects = in.readInt();
        this.lowerBound = in.readInt();
        this.put("fLowerBound", this.lowerBound);
        this.array = new RootObjectRepresentation[nobjects];
        for (int i = 0; i < nobjects; ++i) {
            this.array[i] = in.readObjectRef();
        }
        this.put("fArray", this.array);
    }

    @Override
    public void read(RootInput in) throws IOException {
        try {
            int v = in.readVersion(this);
            this.readMembers(in, v);
            in.checkLength(this);
        }
        catch (IOException x) {
            System.err.println("Error occured while reading " + this.getRootClass());
            this.dump();
            throw x;
        }
    }

    @Override
    public Object createProxy() {
        return new TObjArrayProxy();
    }

    RootObjectRepresentation elementAt(int index) {
        RootObjectRepresentation[] array = (RootObjectRepresentation[])this.get("fArray");
        return array[index];
    }

    int size() {
        int n;
        for (n = this.array.length; n > 0 && this.array[n - 1] == null; --n) {
        }
        return n;
    }

    void setElementAt(int index, RootObjectRepresentation value) {
        RootObjectRepresentation[] array = (RootObjectRepresentation[])this.get("fArray");
        array[index] = value;
    }

    private class TObjArrayProxy
    extends AbstractList
    implements hep.rootio.interfaces.TObjArray {
        @Override
        public int size() {
            return TObjArray.this.size();
        }

        public Object get(int index) {
            return TObjArray.this.array[index] != null ? TObjArray.this.array[index].getProxy() : null;
        }

        @Override
        public int getLowerBound() {
            return TObjArray.this.lowerBound;
        }

        @Override
        public int getUpperBound() {
            return TObjArray.this.lowerBound + TObjArray.this.array.length - 1;
        }

        @Override
        public Object getElementAt(int index) {
            return this.get(index - TObjArray.this.lowerBound);
        }

        private TObjArrayProxy() {
        }
    }
}

