/*
 * Decompiled with CFR 0.152.
 */
package hep.rootio.implementation;

import hep.rootio.RootClass;
import hep.rootio.RootClassFactory;
import hep.rootio.RootClassNotFound;
import hep.rootio.RootInput;
import hep.rootio.RootObjectRepresentation;
import hep.rootio.implementation.GenericRootObject;
import hep.rootio.implementation.IntrinsicRootClass;
import hep.rootio.implementation.StreamerInfo;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.Vector;

public class StreamerInfoString
extends StreamerInfo {
    private String description;

    public StreamerInfoString(String description) {
        this.description = description;
    }

    @Override
    void resolve(RootClassFactory factory) throws RootClassNotFound {
        if (this.description != null) {
            Vector<RootClass> sv = new Vector<RootClass>();
            Vector<MemberString> mv = new Vector<MemberString>();
            StringTokenizer tokenizer = new StringTokenizer(this.description, ";");
            while (tokenizer.hasMoreTokens()) {
                int pos;
                String token = tokenizer.nextToken();
                StringTokenizer t2 = new StringTokenizer(token, " ");
                if (t2.countTokens() == 1) {
                    String className = t2.nextToken();
                    RootClass superClass = factory.create(className);
                    sv.addElement(superClass);
                    continue;
                }
                int index = 1;
                String type = t2.nextToken();
                String name = t2.nextToken();
                boolean pointer = type.endsWith("*");
                if (pointer) {
                    type = type.substring(0, type.length() - 1);
                }
                if ((pos = type.indexOf(91)) > 0) {
                    int l = type.length();
                    index = Integer.parseInt(type.substring(pos + 1, l - 1));
                    type = type.substring(0, pos);
                }
                RootClass memberClass = factory.create(type);
                mv.addElement(new MemberString(memberClass, name, pointer, index));
            }
            this.superClasses = new RootClass[sv.size()];
            sv.copyInto(this.superClasses);
            this.members = new MemberString[mv.size()];
            mv.copyInto(this.members);
            this.description = null;
        }
    }

    @Override
    int getVersion() {
        return 0;
    }

    @Override
    int getCheckSum() {
        return 0;
    }

    private class MemberString
    extends StreamerInfo.Member {
        private RootClass type;
        private String name;
        private boolean pointer;
        private int dim;

        boolean isPointer() {
            return this.pointer;
        }

        @Override
        void read(RootInput in, GenericRootObject obj) throws IOException {
            try {
                if (this.pointer) {
                    RootObjectRepresentation rep = in.readObjectRef();
                    obj.put(this.name, rep);
                } else if (this.dim == 1) {
                    obj.put(this.name, this.type.read(in));
                } else {
                    obj.put(this.name, ((IntrinsicRootClass)this.type).readArray(in, this.dim));
                }
            }
            catch (IOException x) {
                x.printStackTrace();
                System.err.println("Error reading member " + this.name + " of " + obj.getRootClass());
                throw x;
            }
        }

        @Override
        public String getComment() {
            return null;
        }

        @Override
        public RootClass getType() {
            return this.type;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public int getArrayDim() {
            return this.dim != 1 ? 1 : 0;
        }

        MemberString(RootClass type, String name, boolean pointer, int dim) {
            this.type = type;
            this.name = name;
            this.pointer = pointer;
            this.dim = dim;
        }
    }
}

