/*
 * Decompiled with CFR 0.152.
 */
package hep.rootio.implementation;

import hep.rootio.NameMangler;
import hep.rootio.RootClass;
import hep.rootio.RootMember;
import hep.rootio.implementation.AbstractRootObject;
import hep.rootio.interfaces.TBranch;
import java.io.IOException;
import java.lang.reflect.Array;

public abstract class HollowRootObject
extends AbstractRootObject {
    private TBranch branch;
    private int index;
    private int cloneIndex = -1;
    private Object result = null;
    private static final NameMangler nameMangler = NameMangler.instance();

    public void setHollow(TBranch branch) {
        this.branch = branch;
    }

    public void setHollowIndex(int index) {
        this.index = index;
    }

    public void setCloneIndex(int index) {
        this.cloneIndex = index;
    }

    @Override
    public Object get(String name) {
        if (this.branch == null) {
            return super.get(name);
        }
        try {
            TBranch sub = this.branch.getBranchForName(name);
            if (sub != null) {
                Object result = sub.getEntry(this.index);
                if (this.cloneIndex >= 0 && result.getClass().isArray()) {
                    return Array.get(result, this.cloneIndex);
                }
                return result;
            }
            RootMember[] members = this.getRootClass().getMembers();
            for (int j = 0; j < members.length; ++j) {
                if (!members[j].getName().equals(name)) continue;
                RootClass k = members[j].getType();
                HollowRootObject ho = (HollowRootObject)k.newInstance();
                ho.setHollow(this.branch);
                ho.setHollowIndex(this.index);
                if (this.cloneIndex >= 0) {
                    ho.setCloneIndex(this.cloneIndex);
                }
                return ho;
            }
            return null;
        }
        catch (IOException x) {
            x.printStackTrace();
            throw new RuntimeException("IOException while accessing " + name);
        }
    }

    @Override
    public Object getMangled(String name) {
        if (this.branch == null) {
            return super.getMangled(name);
        }
        try {
            TBranch sub = this.branch.getBranchForMangledName(name);
            if (sub != null) {
                Object result = sub.getEntry(this.index);
                if (this.cloneIndex >= 0 && result.getClass().isArray()) {
                    return Array.get(result, this.cloneIndex);
                }
                return result;
            }
            RootMember[] members = this.getRootClass().getMembers();
            for (int j = 0; j < members.length; ++j) {
                if (!nameMangler.mangleMember(members[j].getName()).equals(name)) continue;
                RootClass k = members[j].getType();
                HollowRootObject ho = (HollowRootObject)k.newInstance();
                ho.setHollow(this.branch);
                ho.setHollowIndex(this.index);
                if (this.cloneIndex >= 0) {
                    ho.setCloneIndex(this.cloneIndex);
                }
                return ho;
            }
            return null;
        }
        catch (IOException x) {
            x.printStackTrace();
            throw new RuntimeException("IOException while accessing " + name);
        }
    }
}

