/*
 * Decompiled with CFR 0.152.
 */
package hep.rootio.implementation;

import hep.rootio.RootClass;
import hep.rootio.RootClassFactory;
import hep.rootio.RootClassNotFound;
import hep.rootio.RootFileReader;
import hep.rootio.implementation.GenericRootClass;
import hep.rootio.implementation.IntrinsicRootClass;
import hep.rootio.implementation.SpecificRootClass;
import hep.rootio.implementation.StreamerInfoString;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public class DefaultClassFactory
implements RootClassFactory {
    private Hashtable classMap = new Hashtable();
    private String[] packageList;
    private RootFileReader rfr;

    public DefaultClassFactory(RootFileReader rfr) {
        try {
            Properties typedef = new Properties();
            InputStream in = this.getClass().getResourceAsStream("Typedef.properties");
            typedef.load(in);
            in.close();
            Properties streamerInfo = new Properties();
            in = this.getClass().getResourceAsStream("StreamerInfo.properties");
            streamerInfo.load(in);
            in.close();
            String[] classPackages = new String[]{"hep.rootio.reps"};
            this.init(typedef, streamerInfo, classPackages, rfr);
        }
        catch (IOException ioexception) {
            throw new RuntimeException("Unable to load default properties");
        }
    }

    private void init(Properties typedef, Properties streamerInfo, String[] packageList, RootFileReader rfr) {
        this.packageList = packageList;
        try {
            Enumeration<Object> e = typedef.keys();
            while (e.hasMoreElements()) {
                Object key = e.nextElement();
                Object value = typedef.get(key);
                Class<?> intrinsic = Class.forName("hep.rootio.implementation." + value);
                if (!IntrinsicRootClass.class.isAssignableFrom(intrinsic)) {
                    throw new RuntimeException("Typedef class is not an intrinsic: " + value);
                }
                this.classMap.put(key, intrinsic.newInstance());
            }
        }
        catch (Exception exception) {
            throw new RuntimeException("Error interpreting typedef table");
        }
        try {
            Enumeration<Object> e = streamerInfo.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                Object value = streamerInfo.get(key);
                StreamerInfoString info = new StreamerInfoString((String)value);
                Class c = this.findClass(key);
                if (c != null) {
                    this.classMap.put(key, new SpecificRootClass(c, key, info, rfr));
                    continue;
                }
                this.classMap.put(key, new GenericRootClass(key, info, rfr));
            }
        }
        catch (Exception exception1) {
            throw new RuntimeException("Error interpreting typedef table");
        }
        try {
            Enumeration e = this.classMap.elements();
            while (e.hasMoreElements()) {
                RootClass info = (RootClass)e.nextElement();
                info.resolve(this);
            }
        }
        catch (RootClassNotFound x) {
            throw new RuntimeException("Could not resolve class " + x.getClassName());
        }
    }

    @Override
    public RootClass create(String name) throws RootClassNotFound {
        RootClass result = (RootClass)this.classMap.get(name);
        if (result != null) {
            return result;
        }
        throw new RootClassNotFound(name);
    }

    Class findClass(String name) {
        for (int i = 0; i < this.packageList.length; ++i) {
            try {
                return Class.forName(this.packageList[i] + "." + name);
            }
            catch (Exception exception) {
                continue;
            }
        }
        return null;
    }
}

