/*
 * Decompiled with CFR 0.152.
 */
package org.homedns.dade.jcgrid.worker.impl.mandel;

import org.homedns.dade.jcgrid.client.GridClient;
import org.homedns.dade.jcgrid.client.GridNodeClientConfig;
import org.homedns.dade.jcgrid.message.GridMessageWorkRequest;
import org.homedns.dade.jcgrid.message.GridMessageWorkResult;
import org.homedns.dade.jcgrid.worker.impl.mandel.MandelRenderingClientFeedback;
import org.homedns.dade.jcgrid.worker.impl.mandel.MandelRenderingFrame;
import org.homedns.dade.jcgrid.worker.impl.mandel.MandelWorkRequest;
import org.homedns.dade.jcgrid.worker.impl.mandel.MandelWorkResult;

public class MandelRenderingClient
extends Thread {
    private GridNodeClientConfig clientCfg;
    private MandelRenderingClientFeedback clientFeedback;
    private MandelWorkRequest mandelWReq;
    private MandelRenderingFrame frame;

    public MandelRenderingClient(GridNodeClientConfig cfg, MandelRenderingClientFeedback feedback, MandelWorkRequest req) {
        this.clientCfg = cfg;
        this.clientFeedback = feedback;
        this.mandelWReq = req;
        this.frame = new MandelRenderingFrame(req.getXStep(), req.getYStep(), req.getMaxIter());
    }

    public MandelRenderingFrame getFrame() {
        return this.frame;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            GridClient gc = new GridClient();
            gc.setNodeConfig(this.clientCfg);
            gc.start();
            long t1 = System.currentTimeMillis();
            try {
                int i;
                MandelWorkRequest[] workList = this.mandelWReq.split();
                int fragCount = this.mandelWReq.fragmentPerFrame();
                this.clientFeedback.setProgressMaximum(0);
                this.clientFeedback.setProgressMaximum(2 * workList.length - 1);
                this.clientFeedback.renderingBegin();
                for (i = 0; i < workList.length; ++i) {
                    this.clientFeedback.setProgressValue(i);
                    this.clientFeedback.sendingFrgamentRequest(workList[i]);
                    gc.send(new GridMessageWorkRequest(workList[i]));
                    if (this.isInterrupted()) break;
                }
                for (i = 0; i < workList.length; ++i) {
                    this.clientFeedback.setProgressValue(i + workList.length);
                    GridMessageWorkResult gmwr = (GridMessageWorkResult)gc.recv(0);
                    MandelWorkResult mandelWRes = (MandelWorkResult)gmwr.getWorkResult();
                    int idx = mandelWRes.getRID();
                    this.frame.addFragmentResult(workList[idx], mandelWRes, this.frame);
                    this.clientFeedback.receivedFragmentResult(workList[idx], mandelWRes, this.frame);
                    if (!this.isInterrupted()) continue;
                    break;
                }
            }
            finally {
                long t2 = System.currentTimeMillis();
                this.clientFeedback.setRenderingTime(this.mandelWReq, t2 - t1);
                try {
                    gc.stop();
                }
                catch (Exception ex) {}
            }
        }
        catch (Exception ex) {
            this.clientFeedback.error("Error while doing the rendering", ex);
        }
        this.clientFeedback.renderingEnd();
    }
}

