/*
 * Decompiled with CFR 0.152.
 */
package org.homedns.dade.jcgrid.worker;

import java.io.IOException;
import org.apache.log4j.Logger;
import org.homedns.dade.jcgrid.WorkRequest;
import org.homedns.dade.jcgrid.WorkResult;
import org.homedns.dade.jcgrid.message.GridMessage;
import org.homedns.dade.jcgrid.message.GridMessagePing;
import org.homedns.dade.jcgrid.message.GridMessagePingAck;
import org.homedns.dade.jcgrid.message.GridMessageShutdown;
import org.homedns.dade.jcgrid.message.GridMessageVFSSessionBegin;
import org.homedns.dade.jcgrid.message.GridMessageVFSSessionEnd;
import org.homedns.dade.jcgrid.message.GridMessageWorkRequest;
import org.homedns.dade.jcgrid.message.GridMessageWorkResult;
import org.homedns.dade.jcgrid.util.GridMessageChannel;
import org.homedns.dade.jcgrid.vfs.vfsSession;
import org.homedns.dade.jcgrid.worker.GridWorker;
import org.homedns.dade.jcgrid.worker.GridWorkerFeedback;

public class WorkerThread
extends Thread {
    private static final String className = WorkerThread.class.getName();
    private static Logger log = Logger.getLogger((String)className);
    private static Logger logDetail = Logger.getLogger((String)("DETAIL." + className));
    private GridWorker gridWorker;
    private GridWorkerFeedback feedback;

    public WorkerThread(GridWorker gw) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Start WorkerThread(" + gw + ")"));
        }
        this.gridWorker = gw;
        this.feedback = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)"End WorkerThread()");
        }
    }

    public void setWorkerFeedback(GridWorkerFeedback f) {
        if (logDetail.isDebugEnabled()) {
            logDetail.debug((Object)("Start setWorkerFeedback(" + f + ")"));
        }
        this.feedback = f;
        if (logDetail.isDebugEnabled()) {
            logDetail.debug((Object)"End setWorkerFeedback()");
        }
    }

    public void run() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Start run()");
        }
        try {
            if (this.feedback != null) {
                this.feedback.start();
            }
            GridMessageChannel serverChannel = this.gridWorker.getGridMessageChannel();
            while (true) {
                GridMessage msg = serverChannel.recv();
                try {
                    if (!(msg instanceof GridMessageShutdown)) {
                        if (msg instanceof GridMessagePing) {
                            serverChannel.send(new GridMessagePingAck());
                            continue;
                        }
                        if (msg instanceof GridMessageWorkRequest) {
                            GridMessageWorkRequest gmwr = (GridMessageWorkRequest)msg;
                            WorkRequest wr = gmwr.getWorkRequest();
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("  Received work request: " + wr));
                            }
                            String sessionName = wr.getSessionName();
                            log.warn((Object)("Working for: " + sessionName));
                            if (this.feedback != null) {
                                this.feedback.beginWorkingFor(sessionName, wr);
                            }
                            String sessionPath = null;
                            if (this.gridWorker.getNodeConfig().getGridConfig().getUseVFS()) {
                                GridMessage vfsmsg = serverChannel.recv();
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)"  Received VFS session begin");
                                }
                                vfsSession clientSession = ((GridMessageVFSSessionBegin)vfsmsg).getVFSSession();
                                this.gridWorker.getVFSSessionPool().syncVFSSession(sessionName, serverChannel, clientSession);
                                serverChannel.send(new GridMessageVFSSessionEnd());
                                sessionPath = this.gridWorker.getVFSSessionPool().getVFSSession(sessionName).getPath();
                            }
                            WorkResult res = this.gridWorker.getWorker().doWork(wr, sessionPath);
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("  Work result: " + res));
                            }
                            if (this.feedback != null) {
                                this.feedback.endWorkingFor(res);
                            }
                            serverChannel.send(new GridMessageWorkResult(res));
                            continue;
                        }
                        log.warn((Object)("Error in WorkerThread.run(), received an unknown message: " + msg));
                    }
                    break;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    log.warn((Object)"Error in WorkerThread.run.loop()", (Throwable)ex);
                }
            }
        }
        catch (Exception ex) {
            log.warn((Object)"Error in WorkerThread.run()", (Throwable)ex);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"End run()");
        }
    }
}

