/*
 * Decompiled with CFR 0.152.
 */
package org.homedns.dade.jcgrid.worker;

import java.util.Properties;
import org.homedns.dade.jcgrid.GridNodeGenericConfig;

public class GridNodeWorkerConfig
extends GridNodeGenericConfig
implements Cloneable {
    private int workerCount;

    public GridNodeWorkerConfig(Properties prop) {
        super(prop);
        this.workerCount = Integer.parseInt(prop.getProperty("grid.node.worker.count", "1"));
    }

    public GridNodeWorkerConfig() {
        super("WORKER");
        this.workerCount = 1;
    }

    public Object clone() {
        GridNodeWorkerConfig cfg = (GridNodeWorkerConfig)super.clone();
        cfg.workerCount = this.workerCount;
        return cfg;
    }

    public Properties toProperties() {
        Properties prop = super.toProperties();
        prop.put("grid.node.worker.count", Integer.toString(this.workerCount));
        return prop;
    }

    public int getWorkerCount() {
        return this.workerCount;
    }

    public void setWorkerCount(int num) {
        this.workerCount = num;
    }
}

