/*
 * Decompiled with CFR 0.152.
 */
package org.homedns.dade.jcgrid;

import java.io.File;
import java.util.Properties;
import org.homedns.dade.jcgrid.GridConfig;

public abstract class GridNodeConfig
implements Cloneable {
    public static final String TYPE_WORKER = "WORKER";
    public static final String TYPE_CLIENT = "CLIENT";
    public static final String TYPE_ADMIN = "ADMIN";
    public static final String TYPE_SERVER = "SERVER";
    private GridConfig gCfg;
    private String nodeType;
    private String workingDir;

    public GridNodeConfig(Properties prop) {
        this.gCfg = new GridConfig(prop);
        this.nodeType = prop.getProperty("grid.node.type", TYPE_CLIENT);
        this.workingDir = prop.getProperty("grid.node.workingdir", System.getProperty("user.dir") + File.separator + "cache");
    }

    public GridNodeConfig(String type) {
        this.gCfg = new GridConfig();
        this.nodeType = type;
        this.workingDir = System.getProperty("user.dir") + File.separator + "cache";
    }

    public Object clone() {
        try {
            GridNodeConfig cfg = (GridNodeConfig)super.clone();
            cfg.gCfg = this.gCfg;
            cfg.nodeType = this.nodeType;
            cfg.workingDir = this.workingDir;
            return cfg;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e.toString());
        }
    }

    public Properties toProperties() {
        Properties prop = this.gCfg.toProperties();
        prop.put("grid.node.type", this.nodeType);
        prop.put("grid.node.workingdir", this.workingDir);
        return prop;
    }

    public GridConfig getGridConfig() {
        return this.gCfg;
    }

    public void setGridConfig(GridConfig cfg) {
        this.gCfg = cfg;
    }

    public String getWorkingDir() {
        return this.workingDir;
    }

    public void setWorkingDir(String dir) {
        this.workingDir = dir;
    }

    public String getType() {
        return this.nodeType;
    }

    public void setType(String type) {
        this.nodeType = type;
    }
}

