/*
 * Decompiled with CFR 0.152.
 */
package org.python.indexer.demos;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.BaseRecognizer;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonToken;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.RecognizerSharedState;
import org.antlr.runtime.Token;
import org.python.antlr.PythonLexer;
import org.python.antlr.PythonTree;
import org.python.antlr.RecordingErrorHandler;
import org.python.indexer.Indexer;
import org.python.indexer.StyleRun;
import org.python.indexer.ast.DefaultNodeVisitor;
import org.python.indexer.ast.NFunctionDef;
import org.python.indexer.ast.NModule;
import org.python.indexer.ast.NName;
import org.python.indexer.ast.NNode;
import org.python.indexer.ast.NNum;
import org.python.indexer.ast.NStr;
import org.python.indexer.demos.DocStringParser;
import org.python.indexer.demos.Linker;

class Styler
extends DefaultNodeVisitor {
    static final Pattern BUILTIN = Pattern.compile("None|True|False|NotImplemented|Ellipsis|__debug__");
    private static final Pattern TRISTRING_PREFIX = Pattern.compile("^[ruRU]{0,2}['\"]{3}");
    private Indexer indexer;
    private String source;
    private String path;
    private List<StyleRun> styles = new ArrayList<StyleRun>();
    private Linker linker;
    private Set<Integer> docOffsets = new HashSet<Integer>();

    public Styler(Indexer idx, Linker linker) {
        this.indexer = idx;
        this.linker = linker;
    }

    public List<StyleRun> addStyles(String path, String src) throws Exception {
        this.path = path;
        this.source = src;
        NModule m = this.indexer.getAstForFile(path);
        if (m != null) {
            m.visit(this);
            this.highlightLexicalTokens();
        }
        return this.styles;
    }

    @Override
    public boolean visit(NName n) {
        NNode parent = n.getParent();
        if (parent instanceof NFunctionDef) {
            NFunctionDef fn = (NFunctionDef)parent;
            if (n == fn.name) {
                this.addStyle(n, StyleRun.Type.FUNCTION);
            } else if (n == fn.kwargs || n == fn.varargs) {
                this.addStyle(n, StyleRun.Type.PARAMETER);
            }
            return true;
        }
        if (BUILTIN.matcher(n.id).matches()) {
            this.addStyle(n, StyleRun.Type.BUILTIN);
            return true;
        }
        return true;
    }

    @Override
    public boolean visit(NNum n) {
        this.addStyle(n, StyleRun.Type.NUMBER);
        return true;
    }

    @Override
    public boolean visit(NStr n) {
        String s = this.sourceString(n.start(), n.end());
        if (TRISTRING_PREFIX.matcher(s).lookingAt()) {
            this.addStyle(n.start(), n.end() - n.start(), StyleRun.Type.DOC_STRING);
            this.docOffsets.add(n.start());
            this.highlightDocString(n);
        }
        return true;
    }

    private void highlightDocString(NStr node) {
        String s = this.sourceString(node.start(), node.end());
        DocStringParser dsp = new DocStringParser(s, node, this.linker);
        dsp.setResolveReferences(true);
        this.styles.addAll(dsp.highlight());
    }

    private void highlightLexicalTokens() {
        Token tok;
        RecognizerSharedState state = new RecognizerSharedState();
        state.errorRecovery = true;
        PythonLexer lex = new PythonLexer((CharStream)new ANTLRStringStream(this.source){

            public String getSourceName() {
                return Styler.this.path;
            }
        }, state);
        lex.setErrorHandler(new RecordingErrorHandler(){

            @Override
            public void error(String message, PythonTree t) {
            }

            @Override
            public void reportError(BaseRecognizer br, RecognitionException re) {
            }
        });
        while ((tok = lex.nextToken()).getType() != -1) {
            switch (tok.getType()) {
                case 87: {
                    int beg = ((CommonToken)tok).getStartIndex();
                    int end = ((CommonToken)tok).getStopIndex();
                    if (this.docOffsets.contains(beg)) break;
                    this.addStyle(beg, end - beg + 1, StyleRun.Type.STRING);
                    break;
                }
                case 19: {
                    int beg = ((CommonToken)tok).getStartIndex();
                    int end = ((CommonToken)tok).getStopIndex();
                    String comment = tok.getText();
                    this.addStyle(beg, end - beg + 1, StyleRun.Type.COMMENT);
                    break;
                }
                case 7: 
                case 8: 
                case 9: 
                case 13: 
                case 16: 
                case 21: 
                case 24: 
                case 25: 
                case 32: 
                case 35: 
                case 38: 
                case 40: 
                case 41: 
                case 42: 
                case 45: 
                case 46: 
                case 47: 
                case 50: 
                case 51: 
                case 65: 
                case 67: 
                case 68: 
                case 69: 
                case 74: 
                case 75: 
                case 78: 
                case 92: 
                case 95: 
                case 96: 
                case 98: {
                    int beg = ((CommonToken)tok).getStartIndex();
                    int end = ((CommonToken)tok).getStopIndex();
                    this.addStyle(beg, end - beg + 1, StyleRun.Type.KEYWORD);
                    break;
                }
            }
        }
    }

    private void addStyle(NNode e, int start, int len, StyleRun.Type type) {
        if (e == null || e.getFile() == null) {
            return;
        }
        this.addStyle(start, len, type);
    }

    private void addStyle(NNode e, StyleRun.Type type) {
        if (e != null) {
            this.addStyle(e, e.start(), e.end() - e.start(), type);
        }
    }

    private void addStyle(int beg, int len, StyleRun.Type type) {
        this.styles.add(new StyleRun(type, beg, len));
    }

    private String sourceString(NNode e) {
        return this.sourceString(e.start(), e.end());
    }

    private String sourceString(int beg, int end) {
        int a = Math.max(beg, 0);
        int b = Math.min(end, this.source.length());
        b = Math.max(b, 0);
        try {
            return this.source.substring(a, b);
        }
        catch (StringIndexOutOfBoundsException sx) {
            System.out.println("whoops: beg=" + a + ", end=" + b + ", len=" + this.source.length());
            return "";
        }
    }
}

