/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.time.calendars;

import org.jquantlib.lang.annotation.QualityAssurance;
import org.jquantlib.time.Calendar;
import org.jquantlib.time.Date;
import org.jquantlib.time.Month;
import org.jquantlib.time.Weekday;

@QualityAssurance(quality=QualityAssurance.Quality.Q3_DOCUMENTATION, version=QualityAssurance.Version.V097, reviewers={"Zahid Hussain"})
public class Taiwan
extends Calendar {
    public Taiwan() {
        this(Market.TSEC);
    }

    public Taiwan(Market m) {
        this.impl = new TsecImpl();
    }

    private final class TsecImpl
    extends Calendar.Impl {
        private TsecImpl() {
        }

        @Override
        public String name() {
            return "Taiwan stock exchange";
        }

        @Override
        public boolean isWeekend(Weekday w) {
            return w == Weekday.Saturday || w == Weekday.Sunday;
        }

        @Override
        public boolean isBusinessDay(Date date) {
            Weekday w = date.weekday();
            int d = date.dayOfMonth();
            Month m = date.month();
            int y = date.year();
            if (this.isWeekend(w) || d == 1 && m == Month.January || d == 28 && m == Month.February || d == 1 && m == Month.May || d == 10 && m == Month.October) {
                return false;
            }
            if (y == 2002 && (d >= 9 && d <= 17 && m == Month.February || d == 5 && m == Month.April)) {
                return false;
            }
            if (y == 2003 && (d >= 31 && m == Month.January || d <= 5 && m == Month.February || d == 4 && m == Month.June || d == 11 && m == Month.September)) {
                return false;
            }
            if (y == 2004 && (d >= 21 && d <= 26 && m == Month.January || d == 22 && m == Month.June || d == 28 && m == Month.September)) {
                return false;
            }
            if (y == 2005 && (d >= 6 && d <= 13 && m == Month.February || d == 5 && m == Month.April || d == 2 && m == Month.May)) {
                return false;
            }
            if (y == 2006 && (d >= 28 && m == Month.January || d <= 5 && m == Month.February || d == 5 && m == Month.April || d == 31 && m == Month.May || d == 6 && m == Month.October)) {
                return false;
            }
            if (y == 2007 && (d >= 17 && d <= 25 && m == Month.February || d == 5 && m == Month.April || d == 6 && m == Month.April || d == 18 && m == Month.June || d == 19 && m == Month.June || d == 24 && m == Month.September || d == 25 && m == Month.September)) {
                return false;
            }
            return y != 2008 || (d < 4 || d > 11 || m != Month.February) && (d != 4 || m != Month.April);
        }
    }

    public static enum Market {
        TSEC;

    }
}

