/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.time.calendars;

import org.jquantlib.lang.annotation.QualityAssurance;
import org.jquantlib.time.Calendar;
import org.jquantlib.time.Date;
import org.jquantlib.time.Month;
import org.jquantlib.time.Weekday;

@QualityAssurance(quality=QualityAssurance.Quality.Q3_DOCUMENTATION, version=QualityAssurance.Version.V097, reviewers={"no reviewers yet"})
public class SouthAfrica
extends Calendar {
    public SouthAfrica() {
        this.impl = new Impl();
        this.addHoliday(new Date(31, 12, 1999));
        this.addHoliday(new Date(2, 1, 2000));
        this.addHoliday(new Date(3, 1, 2000));
        this.addHoliday(new Date(2, 5, 2008));
        this.addHoliday(new Date(22, 4, 2009));
    }

    private final class Impl
    extends Calendar.WesternImpl {
        private Impl() {
        }

        @Override
        public String name() {
            return "SouthAfrica";
        }

        @Override
        public boolean isBusinessDay(Date date) {
            Weekday w = date.weekday();
            int d = date.dayOfMonth();
            int dd = date.dayOfYear();
            Month m = date.month();
            int y = date.year();
            int em = this.easterMonday(y);
            return !(this.isWeekend(w) || (d == 1 || d == 2 && w == Weekday.Monday) && m == Month.January || (d == 21 || d == 22 && w == Weekday.Monday) && m == Month.March || dd == em - 3 || dd == em || (d == 27 || d == 28 && w == Weekday.Monday) && m == Month.April || (d == 1 || d == 2 && w == Weekday.Monday) && m == Month.May || (d == 16 || d == 17 && w == Weekday.Monday) && m == Month.June || (d == 9 || d == 10 && w == Weekday.Monday) && m == Month.August || (d == 24 || d == 25 && w == Weekday.Monday) && m == Month.September || (d == 16 || d == 17 && w == Weekday.Monday) && m == Month.December || (d == 25 || d == 26 && w == Weekday.Monday) && m == Month.December) && (d != 26 && (d != 27 || w != Weekday.Monday) || m != Month.December);
        }
    }
}

