/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.time.calendars;

import org.jquantlib.lang.annotation.QualityAssurance;
import org.jquantlib.lang.exceptions.LibraryException;
import org.jquantlib.time.Calendar;
import org.jquantlib.time.Date;
import org.jquantlib.time.Month;
import org.jquantlib.time.Weekday;

@QualityAssurance(quality=QualityAssurance.Quality.Q3_DOCUMENTATION, version=QualityAssurance.Version.V097, reviewers={"Zahid Hussain"})
public class Mexico
extends Calendar {
    public Mexico() {
        this(Market.BMV);
    }

    public Mexico(Market m) {
        switch (m) {
            case BMV: {
                this.impl = new BmvImpl();
                break;
            }
            default: {
                throw new LibraryException("Unknown market");
            }
        }
    }

    private final class BmvImpl
    extends Calendar.WesternImpl {
        private BmvImpl() {
        }

        @Override
        public String name() {
            return "Mexican stock exchange";
        }

        @Override
        public boolean isBusinessDay(Date date) {
            Weekday w = date.weekday();
            int d = date.dayOfMonth();
            int dd = date.dayOfYear();
            Month m = date.month();
            int y = date.year();
            int em = this.easterMonday(y);
            return !(this.isWeekend(w) || d == 1 && m == Month.January || d == 5 && m == Month.February || d == 21 && m == Month.March || dd == em - 4 || dd == em - 3 || d == 1 && m == Month.May || d == 16 && m == Month.September || d == 12 && m == Month.December) && (d != 25 || m != Month.December);
        }
    }

    public static enum Market {
        BMV;

    }
}

