/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.time.calendars;

import org.jquantlib.lang.annotation.QualityAssurance;
import org.jquantlib.lang.exceptions.LibraryException;
import org.jquantlib.time.Calendar;
import org.jquantlib.time.Date;
import org.jquantlib.time.Month;
import org.jquantlib.time.Weekday;

@QualityAssurance(quality=QualityAssurance.Quality.Q3_DOCUMENTATION, version=QualityAssurance.Version.V097, reviewers={"Zahid Hussain"})
public class India
extends Calendar {
    public India() {
        this(Market.NSE);
    }

    public India(Market m) {
        switch (m) {
            case NSE: {
                this.impl = new NseImpl();
                break;
            }
            default: {
                throw new LibraryException("Unknown market");
            }
        }
    }

    private final class NseImpl
    extends Calendar.WesternImpl {
        private NseImpl() {
        }

        @Override
        public String name() {
            return "National Stock Exchange of India";
        }

        @Override
        public boolean isBusinessDay(Date date) {
            Weekday w = date.weekday();
            int d = date.dayOfMonth();
            Month m = date.month();
            int y = date.year();
            int dd = date.dayOfYear();
            int em = this.easterMonday(y);
            if (this.isWeekend(w) || d == 26 && m == Month.January || dd == em - 3 || d == 14 && m == Month.April || d == 15 && m == Month.August || d == 2 && m == Month.October || d == 25 && m == Month.December) {
                return false;
            }
            if (y == 2005 && (d == 21 && m == Month.January || d == 7 && m == Month.September || d == 12 && m == Month.October || d == 1 && m == Month.November || d == 3 && m == Month.November || d == 15 && m == Month.November)) {
                return false;
            }
            if (y == 2006 && (d == 11 && m == Month.January || d == 9 && m == Month.February || d == 15 && m == Month.March || d == 6 && m == Month.April || d == 11 && m == Month.April || d == 1 && m == Month.May || d == 24 && m == Month.October || d == 25 && m == Month.October)) {
                return false;
            }
            if (y == 2007 && (d == 1 && m == Month.January || d == 30 && m == Month.January || d == 16 && m == Month.February || d == 27 && m == Month.March || d == 1 && m == Month.May || d == 2 && m == Month.May || d == 9 && m == Month.November || d == 21 && m == Month.December)) {
                return false;
            }
            return y != 2008 || !(d == 6 && m == Month.March || d == 20 && m == Month.March || d == 18 && m == Month.April || d == 1 && m == Month.May || d == 19 && m == Month.May || d == 3 && m == Month.September || d == 2 && m == Month.October || d == 9 && m == Month.October || d == 28 && m == Month.October || d == 30 && m == Month.October || d == 13 && m == Month.November) && (d != 9 || m != Month.December);
        }
    }

    public static enum Market {
        NSE;

    }
}

