/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.time.calendars;

import org.jquantlib.lang.annotation.QualityAssurance;
import org.jquantlib.lang.exceptions.LibraryException;
import org.jquantlib.time.Calendar;
import org.jquantlib.time.Date;
import org.jquantlib.time.Month;
import org.jquantlib.time.Weekday;

@QualityAssurance(quality=QualityAssurance.Quality.Q3_DOCUMENTATION, version=QualityAssurance.Version.V097, reviewers={"Zahid Hussain"})
public class Iceland
extends Calendar {
    public Iceland() {
        this(Market.ICEX);
    }

    public Iceland(Market m) {
        switch (m) {
            case ICEX: {
                this.impl = new IcexImpl();
                break;
            }
            default: {
                throw new LibraryException("Unknown market");
            }
        }
    }

    private final class IcexImpl
    extends Calendar.WesternImpl {
        private IcexImpl() {
        }

        @Override
        public String name() {
            return "Iceland stock exchange";
        }

        @Override
        public boolean isBusinessDay(Date date) {
            Weekday w = date.weekday();
            int d = date.dayOfMonth();
            int dd = date.dayOfYear();
            Month m = date.month();
            int y = date.year();
            int em = this.easterMonday(y);
            return !(this.isWeekend(w) || (d == 1 || (d == 2 || d == 3) && w == Weekday.Monday) && m == Month.January || dd == em - 4 || dd == em - 3 || dd == em || d >= 19 && d <= 25 && w == Weekday.Thursday && m == Month.April || dd == em + 38 || dd == em + 49 || d == 1 && m == Month.May || d == 17 && m == Month.June || d <= 7 && w == Weekday.Monday && m == Month.August || d == 25 && m == Month.December) && (d != 26 || m != Month.December);
        }
    }

    public static enum Market {
        ICEX;

    }
}

