/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.time.calendars;

import org.jquantlib.lang.annotation.QualityAssurance;
import org.jquantlib.time.Calendar;
import org.jquantlib.time.Date;
import org.jquantlib.time.Month;
import org.jquantlib.time.Weekday;

@QualityAssurance(quality=QualityAssurance.Quality.Q3_DOCUMENTATION, version=QualityAssurance.Version.V097, reviewers={"Zahid Hussain"})
public class Argentina
extends Calendar {
    public Argentina() {
        this(Market.MERVAL);
    }

    public Argentina(Market m) {
        this.impl = new MervalImpl();
    }

    private final class MervalImpl
    extends Calendar.WesternImpl {
        private MervalImpl() {
        }

        @Override
        public String name() {
            return "Buenos Aires stock exchange";
        }

        @Override
        public boolean isBusinessDay(Date date) {
            Weekday w = date.weekday();
            int d = date.dayOfMonth();
            int dd = date.dayOfYear();
            Month m = date.month();
            int y = date.year();
            int em = this.easterMonday(y);
            return !(this.isWeekend(w) || d == 1 && m == Month.January || dd == em - 4 || dd == em - 3 || d == 1 && m == Month.May || d == 25 && m == Month.May || d >= 15 && d <= 21 && w == Weekday.Monday && m == Month.June || d == 9 && m == Month.July || d >= 15 && d <= 21 && w == Weekday.Monday && m == Month.August || (d == 10 || d == 11 || d == 12 || d == 15 || d == 16) && w == Weekday.Monday && m == Month.October || d == 8 && m == Month.December || d == 24 && m == Month.December) && (d != 31 && (d != 30 || w != Weekday.Friday) || m != Month.December);
        }
    }

    public static enum Market {
        MERVAL;

    }
}

