/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.time;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jquantlib.QL;
import org.jquantlib.Settings;
import org.jquantlib.lang.annotation.QualityAssurance;
import org.jquantlib.lang.exceptions.LibraryException;
import org.jquantlib.time.BusinessDayConvention;
import org.jquantlib.time.Calendar;
import org.jquantlib.time.Date;
import org.jquantlib.time.DateGeneration;
import org.jquantlib.time.IMM;
import org.jquantlib.time.Month;
import org.jquantlib.time.Period;
import org.jquantlib.time.TimeUnit;
import org.jquantlib.time.Weekday;
import org.jquantlib.time.calendars.NullCalendar;

@QualityAssurance(quality=QualityAssurance.Quality.Q0_UNFINISHED, version=QualityAssurance.Version.V097, reviewers={"Richard Gomes"})
public class Schedule {
    private final boolean fullInterface_;
    private final Calendar calendar_;
    private final BusinessDayConvention convention_;
    private final BusinessDayConvention terminationDateConvention_;
    private final boolean endOfMonth_;
    private final boolean finalIsRegular_;
    private final List<Date> dates_;
    private final List<Boolean> isRegular_;
    private Period tenor_;
    private DateGeneration.Rule rule_;
    private Date firstDate_;
    private Date nextToLastDate_;

    public Schedule(List<Date> dates) {
        this(dates, new NullCalendar(), BusinessDayConvention.Unadjusted);
    }

    public Schedule(List<Date> dates, Calendar calendar) {
        this(dates, calendar, BusinessDayConvention.Unadjusted);
    }

    public Schedule(List<Date> dates, Calendar calendar, BusinessDayConvention convention) {
        this.dates_ = dates;
        this.isRegular_ = new ArrayList<Boolean>();
        this.calendar_ = calendar;
        this.convention_ = convention;
        this.fullInterface_ = false;
        this.tenor_ = new Period();
        this.terminationDateConvention_ = convention;
        this.rule_ = DateGeneration.Rule.Forward;
        this.endOfMonth_ = false;
        this.finalIsRegular_ = true;
    }

    public Schedule(Date effectiveDate, Date terminationDate, Period tenor, Calendar calendar, BusinessDayConvention convention, BusinessDayConvention terminationDateConvention, DateGeneration.Rule rule, boolean endOfMonth) {
        this(effectiveDate, terminationDate, tenor, calendar, convention, terminationDateConvention, rule, endOfMonth, new Date(), new Date());
    }

    public Schedule(Date effectiveDate, Date terminationDate, Period tenor, Calendar calendar, BusinessDayConvention convention, BusinessDayConvention terminationDateConvention, DateGeneration.Rule rule, boolean endOfMonth, Date firstDate, Date nextToLastDate) {
        this.dates_ = new ArrayList<Date>();
        this.isRegular_ = new ArrayList<Boolean>();
        this.fullInterface_ = true;
        this.tenor_ = tenor;
        this.calendar_ = calendar;
        this.convention_ = convention;
        this.terminationDateConvention_ = terminationDateConvention;
        this.rule_ = rule;
        this.endOfMonth_ = endOfMonth;
        this.firstDate_ = firstDate;
        this.nextToLastDate_ = nextToLastDate;
        this.finalIsRegular_ = true;
        QL.require(effectiveDate != null && !effectiveDate.isNull(), "null effective date");
        QL.require(terminationDate != null && !terminationDate.isNull(), "null termination date");
        QL.require(effectiveDate.lt(terminationDate), "effective date (" + effectiveDate + ") later than or equal to termination date (" + terminationDate + ")");
        if (tenor.length() == 0) {
            this.rule_ = DateGeneration.Rule.Zero;
        } else {
            QL.require(tenor.length() > 0, "non positive tenor (" + tenor + ") not allowed");
        }
        if (firstDate != null && !firstDate.isNull()) {
            switch (this.rule_) {
                case Backward: 
                case Forward: {
                    QL.require(firstDate.gt(effectiveDate) && firstDate.lt(terminationDate), "first date (" + firstDate + ") out of [effective (" + effectiveDate + "), termination (" + terminationDate + ")] date range");
                    break;
                }
                case ThirdWednesday: {
                    QL.require(IMM.isIMMdate(firstDate, false), "first date (" + firstDate + ") is not an IMM date");
                    break;
                }
                case Zero: 
                case Twentieth: 
                case TwentiethIMM: {
                    String errMsg = "first date incompatible with " + (Object)((Object)this.rule_) + " date generation rule";
                    throw new LibraryException(errMsg);
                }
                default: {
                    String errMsg = "unknown Rule (" + (Object)((Object)this.rule_) + ")";
                    throw new LibraryException(errMsg);
                }
            }
        }
        if (nextToLastDate != null && !nextToLastDate.isNull()) {
            switch (this.rule_) {
                case Backward: 
                case Forward: {
                    QL.require(nextToLastDate.gt(effectiveDate) && nextToLastDate.lt(terminationDate), "next to last date (" + nextToLastDate + ") out of [effective (" + effectiveDate + "), termination (" + terminationDate + ")] date range");
                    break;
                }
                case ThirdWednesday: {
                    QL.require(IMM.isIMMdate(nextToLastDate, false), "first date (" + firstDate + ") is not an IMM date");
                }
                case Zero: 
                case Twentieth: 
                case TwentiethIMM: {
                    String errMsg = "next to last date incompatible with " + (Object)((Object)this.rule_) + " date generation rule";
                    throw new LibraryException(errMsg);
                }
                default: {
                    String errMsg = "unknown Rule (" + (Object)((Object)this.rule_) + ")";
                    throw new LibraryException(errMsg);
                }
            }
        }
        NullCalendar nullCalendar = new NullCalendar();
        int periods = 1;
        switch (this.rule_) {
            case Zero: {
                this.tenor_ = new Period(0, TimeUnit.Days);
                this.dates_.add(effectiveDate);
                this.dates_.add(terminationDate);
                this.isRegular_.add(new Boolean(true));
                break;
            }
            case Backward: {
                Date temp;
                this.dates_.add(terminationDate);
                Date seed = terminationDate.clone();
                if (nextToLastDate != null && !nextToLastDate.isNull()) {
                    this.dates_.add(0, nextToLastDate);
                    temp = nullCalendar.advance(seed, this.tenor_.mul(periods).negative(), convention, endOfMonth);
                    if (temp.ne(nextToLastDate)) {
                        this.isRegular_.add(0, new Boolean(false));
                    } else {
                        this.isRegular_.add(0, new Boolean(true));
                    }
                    seed = nextToLastDate.clone();
                }
                Date exitDate = effectiveDate.clone();
                if (firstDate != null && !firstDate.isNull()) {
                    exitDate = firstDate.clone();
                }
                while (!(temp = nullCalendar.advance(seed, this.tenor_.mul(periods).negative(), convention, endOfMonth)).lt(exitDate)) {
                    this.dates_.add(0, temp);
                    this.isRegular_.add(0, new Boolean(true));
                    ++periods;
                }
                if (endOfMonth && calendar.isEndOfMonth(seed)) {
                    convention = BusinessDayConvention.Preceding;
                }
                if (!calendar.adjust(this.dates_.get(0), convention).ne(calendar.adjust(effectiveDate, convention))) break;
                this.dates_.add(0, effectiveDate);
                this.isRegular_.add(0, new Boolean(false));
                break;
            }
            case ThirdWednesday: 
            case Twentieth: 
            case TwentiethIMM: {
                QL.require(!endOfMonth, "endOfMonth convention incompatible with " + (Object)((Object)this.rule_) + " date generation rule");
            }
            case Forward: {
                Date next20th;
                Date temp;
                this.dates_.add(effectiveDate);
                Date seed = effectiveDate.clone();
                if (firstDate != null && !firstDate.isNull()) {
                    this.dates_.add(firstDate);
                    temp = nullCalendar.advance(seed, this.tenor_.mul(periods), convention, endOfMonth);
                    if (temp.ne(firstDate)) {
                        this.isRegular_.add(new Boolean(false));
                    } else {
                        this.isRegular_.add(new Boolean(true));
                    }
                    seed = firstDate.clone();
                } else if ((this.rule_ == DateGeneration.Rule.Twentieth || this.rule_ == DateGeneration.Rule.TwentiethIMM) && (next20th = this.nextTwentieth(effectiveDate, this.rule_)).ne(effectiveDate)) {
                    this.dates_.add(next20th);
                    this.isRegular_.add(new Boolean(false));
                    seed = next20th.clone();
                }
                Date exitDate = terminationDate.clone();
                if (nextToLastDate != null && !nextToLastDate.isNull()) {
                    exitDate = nextToLastDate.clone();
                }
                while (!(temp = nullCalendar.advance(seed, this.tenor_.mul(periods), convention, endOfMonth)).gt(exitDate)) {
                    this.dates_.add(temp);
                    this.isRegular_.add(new Boolean(true));
                    ++periods;
                }
                if (endOfMonth && calendar.isEndOfMonth(seed)) {
                    convention = BusinessDayConvention.Preceding;
                }
                if (!calendar.adjust(this.dates_.get(this.dates_.size() - 1), terminationDateConvention).ne(calendar.adjust(terminationDate, terminationDateConvention))) break;
                if (this.rule_ == DateGeneration.Rule.Twentieth || this.rule_ == DateGeneration.Rule.TwentiethIMM) {
                    this.dates_.add(this.nextTwentieth(terminationDate, this.rule_));
                    this.isRegular_.add(true);
                    break;
                }
                this.dates_.add(terminationDate);
                this.isRegular_.add(false);
                break;
            }
            default: {
                String errMsg = "unknown Rule (" + (Object)((Object)this.rule_) + ")";
                throw new LibraryException(errMsg);
            }
        }
        if (this.rule_ == DateGeneration.Rule.ThirdWednesday) {
            for (int i = 1; i < this.dates_.size() - 1; ++i) {
                this.dates_.set(i, Date.nthWeekday(3, Weekday.Wednesday, this.dates_.get(i).month(), this.dates_.get(i).year()));
            }
        }
        for (int i = 0; i < this.dates_.size() - 1; ++i) {
            this.dates_.set(i, calendar.adjust(this.dates_.get(i), convention));
        }
        if (terminationDateConvention != BusinessDayConvention.Unadjusted || this.rule_ == DateGeneration.Rule.Twentieth || this.rule_ == DateGeneration.Rule.TwentiethIMM) {
            this.dates_.set(this.dates_.size() - 1, calendar.adjust(this.dates_.get(this.dates_.size() - 1), terminationDateConvention));
        }
    }

    public int size() {
        return this.dates_.size();
    }

    public final Date at(int i) {
        return this.dates_.get(i);
    }

    public final Date date(int i) {
        return this.dates_.get(i);
    }

    public Date previousDate(Date refDate) {
        int index = Date.lowerBound(this.dates_, refDate);
        if (index > 0) {
            return this.dates_.get(index - 1).clone();
        }
        return new Date();
    }

    public Date nextDate(Date refDate) {
        int index = Date.lowerBound(this.dates_, refDate);
        if (index < this.dates_.size()) {
            return this.dates_.get(index).clone();
        }
        return new Date();
    }

    public List<Date> dates() {
        return this.dates_;
    }

    public boolean isRegular(int i) {
        QL.require(this.fullInterface_, "full interface not available");
        QL.require(i <= this.isRegular_.size() && i > 0, "index (" + i + ") must be in [1, " + this.isRegular_.size() + "]");
        return this.isRegular_.get(i - 1);
    }

    public boolean empty() {
        return this.dates_.isEmpty();
    }

    public final Calendar calendar() {
        return this.calendar_;
    }

    public final Date startDate() {
        return this.dates_.isEmpty() ? null : this.dates_.get(0);
    }

    public final Date endDate() {
        return this.dates_.isEmpty() ? null : this.dates_.get(this.dates_.size() - 1);
    }

    public final Period tenor() {
        QL.require(this.fullInterface_, "full interface not available");
        return this.tenor_;
    }

    public BusinessDayConvention businessDayConvention() {
        return this.convention_;
    }

    public BusinessDayConvention terminationDateBusinessDayConvention() {
        QL.require(this.fullInterface_, "full interface not available");
        return this.terminationDateConvention_;
    }

    public DateGeneration.Rule rule() {
        QL.require(this.fullInterface_, "full interface not available");
        return this.rule_;
    }

    public boolean endOfMonth() {
        QL.require(this.fullInterface_, "full interface not available");
        return this.endOfMonth_;
    }

    @Deprecated
    public Iterator<Date> begin() {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public Iterator<Date> end() {
        throw new UnsupportedOperationException();
    }

    public int lowerBound() {
        return this.lowerBound(new Date());
    }

    public int lowerBound(Date refDate) {
        Date d = refDate.isNull() ? new Settings().evaluationDate() : refDate;
        return Date.lowerBound(this.dates_, d.clone());
    }

    private Date nextTwentieth(Date d, DateGeneration.Rule rule) {
        Month m;
        int mVal;
        Date result = new Date(20, d.month(), d.year());
        if (result.lt(d)) {
            result.addAssign(new Period(1, TimeUnit.Months));
        }
        if (rule == DateGeneration.Rule.TwentiethIMM && (mVal = (m = result.month()).value()) % 3 != 0) {
            int skip = 3 - mVal % 3;
            result.addAssign(new Period(skip, TimeUnit.Months));
        }
        return result;
    }

    private Iterator<Date> std_lower_bound(Date date) {
        ArrayList<Date> ldates = new ArrayList<Date>();
        if (this.dates_.size() > 0) {
            int i;
            int index = -1;
            for (i = 0; i < this.dates_.size(); ++i) {
                Date d = this.dates_.get(i);
                if (!d.equals(date)) continue;
                index = i;
                break;
            }
            if (index > 0) {
                for (i = index; i < this.dates_.size(); ++i) {
                    ldates.add(this.dates_.get(i));
                }
                return ldates.iterator();
            }
        }
        return ldates.iterator();
    }

    public Iterator<Date> getDatesAfter(Date date) {
        return this.std_lower_bound(date);
    }
}

