/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.time;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Formatter;
import java.util.List;
import java.util.Locale;
import org.jquantlib.QL;
import org.jquantlib.lang.exceptions.LibraryException;
import org.jquantlib.time.Month;
import org.jquantlib.time.Period;
import org.jquantlib.time.TimeUnit;
import org.jquantlib.time.Weekday;
import org.jquantlib.util.DefaultObservable;
import org.jquantlib.util.Observable;
import org.jquantlib.util.Observer;

public class Date
implements Observable,
Comparable<Date>,
Serializable,
Cloneable {
    private static final long serialVersionUID = -7150540867519744332L;
    private long serialNumber;
    private static final int[] monthLength = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private static final int[] monthLeapLength = new int[]{31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private static final int[] monthOffset = new int[]{0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334, 365};
    private static final int[] monthLeapOffset = new int[]{0, 31, 60, 91, 121, 152, 182, 213, 244, 274, 305, 335, 366};
    private static final int[] yearOffset = new int[]{0, 366, 731, 1096, 1461, 1827, 2192, 2557, 2922, 3288, 3653, 4018, 4383, 4749, 5114, 5479, 5844, 6210, 6575, 6940, 7305, 7671, 8036, 8401, 8766, 9132, 9497, 9862, 10227, 10593, 10958, 11323, 11688, 12054, 12419, 12784, 13149, 13515, 13880, 14245, 14610, 14976, 15341, 15706, 16071, 16437, 16802, 17167, 17532, 17898, 18263, 18628, 18993, 19359, 19724, 20089, 20454, 20820, 21185, 21550, 21915, 22281, 22646, 23011, 23376, 23742, 24107, 24472, 24837, 25203, 25568, 25933, 26298, 26664, 27029, 27394, 27759, 28125, 28490, 28855, 29220, 29586, 29951, 30316, 30681, 31047, 31412, 31777, 32142, 32508, 32873, 33238, 33603, 33969, 34334, 34699, 35064, 35430, 35795, 36160, 36525, 36891, 37256, 37621, 37986, 38352, 38717, 39082, 39447, 39813, 40178, 40543, 40908, 41274, 41639, 42004, 42369, 42735, 43100, 43465, 43830, 44196, 44561, 44926, 45291, 45657, 46022, 46387, 46752, 47118, 47483, 47848, 48213, 48579, 48944, 49309, 49674, 50040, 50405, 50770, 51135, 51501, 51866, 52231, 52596, 52962, 53327, 53692, 54057, 54423, 54788, 55153, 55518, 55884, 56249, 56614, 56979, 57345, 57710, 58075, 58440, 58806, 59171, 59536, 59901, 60267, 60632, 60997, 61362, 61728, 62093, 62458, 62823, 63189, 63554, 63919, 64284, 64650, 65015, 65380, 65745, 66111, 66476, 66841, 67206, 67572, 67937, 68302, 68667, 69033, 69398, 69763, 70128, 70494, 70859, 71224, 71589, 71955, 72320, 72685, 73050, 73415, 73780, 74145, 74510, 74876, 75241, 75606, 75971, 76337, 76702, 77067, 77432, 77798, 78163, 78528, 78893, 79259, 79624, 79989, 80354, 80720, 81085, 81450, 81815, 82181, 82546, 82911, 83276, 83642, 84007, 84372, 84737, 85103, 85468, 85833, 86198, 86564, 86929, 87294, 87659, 88025, 88390, 88755, 89120, 89486, 89851, 90216, 90581, 90947, 91312, 91677, 92042, 92408, 92773, 93138, 93503, 93869, 94234, 94599, 94964, 95330, 95695, 96060, 96425, 96791, 97156, 97521, 97886, 98252, 98617, 98982, 99347, 99713, 100078, 100443, 100808, 101174, 101539, 101904, 102269, 102635, 103000, 103365, 103730, 104096, 104461, 104826, 105191, 105557, 105922, 106287, 106652, 107018, 107383, 107748, 108113, 108479, 108844, 109209, 109574};
    private static final boolean[] yearIsLeap = new boolean[]{true, false, false, false, true, false, false, false, true, false, false, false, true, false, false, false, true, false, false, false, true, false, false, false, true, false, false, false, true, false, false, false, true, false, false, false, true, false, false, false, true, false, false, false, true, false, false, false, true, false, false, false, true, false, false, false, true, false, false, false, true, false, false, false, true, false, false, false, true, false, false, false, true, false, false, false, true, false, false, false, true, false, false, false, true, false, false, false, true, false, false, false, true, false, false, false, true, false, false, false, true, false, false, false, true, false, false, false, true, false, false, false, true, false, false, false, true, false, false, false, true, false, false, false, true, false, false, false, true, false, false, false, true, false, false, false, true, false, false, false, true, false, false, false, true, false, false, false, true, false, false, false, true, false, false, false, true, false, false, false, true, false, false, false, true, false, false, false, true, false, false, false, true, false, false, false, true, false, false, false, true, false, false, false, true, false, false, false, true, false, false, false, true, false, false, false, true, false, false, false, false, false, false, false, true, false, false, false, true, false, false, false, true, false, false, false, true, false, false, false, true, false, false, false, true, false, false, false, true, false, false, false, true, false, false, false, true, false, false, false, true, false, false, false, true, false, false, false, true, false, false, false, true, false, false, false, true, false, false, false, true, false, false, false, true, false, false, false, true, false, false, false, true, false, false, false, true, false, false, false, true, false, false, false, true, false, false, false, true, false, false, false, true, false, false, false, true, false, false, false, false};
    private final Observable delegatedObservable = new DefaultObservable(this);

    public Date() {
        this(0L);
    }

    public Date(long serialNumber) {
        this.serialNumber = serialNumber;
    }

    public Date(int day, Month month, int year) {
        this(Date.fromDMY(day, month.value(), year));
    }

    public Date(int day, int month, int year) {
        this(Date.fromDMY(day, month, year));
    }

    public Date(java.util.Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        int d = c.get(5);
        int m = c.get(2);
        int y = c.get(1);
        this.serialNumber = Date.fromDMY(d, m + 1, y);
    }

    public Weekday weekday() {
        int w = (int)(this.serialNumber % 7L);
        return Weekday.valueOf((long)w == 0L ? 7 : w);
    }

    public int dayOfMonth() {
        return this.dayOfYear() - Date.monthOffset(this.month().value(), Date.isLeap(this.year()));
    }

    public int dayOfYear() {
        return (int)(this.serialNumber - Date.yearOffset(this.year()));
    }

    public Month month() {
        int d = this.dayOfYear();
        int m = d / 30 + 1;
        boolean leap = Date.isLeap(this.year());
        while (d <= Date.monthOffset(m, leap)) {
            --m;
        }
        while (d > Date.monthOffset(m + 1, leap)) {
            ++m;
        }
        return Month.valueOf(m);
    }

    public int year() {
        int y = (int)(this.serialNumber / 365L) + 1900;
        if (this.serialNumber <= Date.yearOffset(y)) {
            --y;
        }
        return y;
    }

    public long serialNumber() {
        return this.serialNumber;
    }

    public Date addAssign(int days) {
        this.serialNumber += (long)days;
        this.checkSerialNumber();
        this.delegatedObservable.notifyObservers();
        return this;
    }

    public Date addAssign(Period period) {
        this.serialNumber = this.advance(this, period.length(), period.units());
        this.checkSerialNumber();
        this.delegatedObservable.notifyObservers();
        return this;
    }

    public Date subAssign(int days) {
        this.serialNumber -= (long)days;
        this.checkSerialNumber();
        this.delegatedObservable.notifyObservers();
        return this;
    }

    public Date subAssign(Period period) {
        this.serialNumber = this.advance(this, -1 * period.length(), period.units());
        this.checkSerialNumber();
        this.delegatedObservable.notifyObservers();
        return this;
    }

    public Date inc() {
        ++this.serialNumber;
        this.checkSerialNumber();
        return this;
    }

    public Date dec() {
        --this.serialNumber;
        this.checkSerialNumber();
        return this;
    }

    public Date add(int days) {
        return new Date(this.serialNumber + (long)days);
    }

    public Date add(Period period) {
        return new Date(this.advance(this, period.length(), period.units()));
    }

    public Date sub(int days) {
        return new Date(this.serialNumber - (long)days);
    }

    public Date sub(Period period) {
        return new Date(this.advance(this, -1 * period.length(), period.units()));
    }

    public long sub(Date another) {
        return this.serialNumber - another.serialNumber;
    }

    public boolean eq(Date another) {
        return this.serialNumber == another.serialNumber;
    }

    public boolean ne(Date another) {
        return this.serialNumber != another.serialNumber;
    }

    public boolean lt(Date another) {
        return this.serialNumber < another.serialNumber;
    }

    public boolean le(Date another) {
        return this.serialNumber <= another.serialNumber;
    }

    public boolean gt(Date another) {
        return this.serialNumber > another.serialNumber;
    }

    public boolean ge(Date another) {
        return this.serialNumber >= another.serialNumber;
    }

    public boolean isNull() {
        return this.serialNumber <= 0L;
    }

    public final boolean isToday() {
        int y;
        int m;
        Calendar cal = Calendar.getInstance();
        int d = cal.get(5);
        return this.serialNumber == Date.fromDMY(d, (m = cal.get(2)) + 1, y = cal.get(1));
    }

    public java.util.Date longDate() {
        return new LongDate();
    }

    public java.util.Date shortDate() {
        return new ShortDate();
    }

    public java.util.Date isoDate() {
        return new ISODate();
    }

    @Override
    public int compareTo(Date o) {
        if (this.equals(o)) {
            return 0;
        }
        if (this.le(o)) {
            return -1;
        }
        return 1;
    }

    @Override
    public final void addObserver(Observer observer) {
        this.delegatedObservable.addObserver(observer);
    }

    @Override
    public final int countObservers() {
        return this.delegatedObservable.countObservers();
    }

    @Override
    public final void deleteObserver(Observer observer) {
        this.delegatedObservable.deleteObserver(observer);
    }

    @Override
    public final void notifyObservers() {
        this.delegatedObservable.notifyObservers();
    }

    @Override
    public final void notifyObservers(Object arg) {
        this.delegatedObservable.notifyObservers(arg);
    }

    @Override
    public final void deleteObservers() {
        this.delegatedObservable.deleteObservers();
    }

    @Override
    public final List<Observer> getObservers() {
        return this.delegatedObservable.getObservers();
    }

    public int hashCode() {
        return (int)this.serialNumber;
    }

    public boolean equals(Object anObject) {
        if (this == anObject) {
            return true;
        }
        if (anObject == null) {
            return false;
        }
        return anObject instanceof Date && ((Date)anObject).fEquals(this);
    }

    protected boolean fEquals(Date other) {
        return this.eq(other);
    }

    public String toString() {
        return this.longDate().toString();
    }

    public Date clone() {
        try {
            return (Date)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new LibraryException(e);
        }
    }

    protected final long todaysSerialNumber() {
        Calendar cal = Calendar.getInstance();
        int d = cal.get(5);
        int m = cal.get(2);
        int y = cal.get(1);
        return Date.fromDMY(d, m + 1, y);
    }

    protected final Date assign(long serialNumber) {
        this.serialNumber = serialNumber;
        return this;
    }

    private void checkSerialNumber() {
        QL.ensure(this.serialNumber >= Date.minimumSerialNumber() && this.serialNumber <= Date.maximumSerialNumber(), "Date's serial number is outside allowed range");
    }

    private long advance(Date date, int n, TimeUnit units) {
        switch (units) {
            case Days: {
                return (long)n + date.serialNumber;
            }
            case Weeks: {
                return (long)(7 * n) + date.serialNumber;
            }
            case Months: {
                int d = date.dayOfMonth();
                int m = date.month().value() + n;
                int y = date.year();
                while (m > 12) {
                    m -= 12;
                    ++y;
                }
                while (m < 1) {
                    m += 12;
                    --y;
                }
                QL.ensure(y > 1900 && y <= 2199, "year out of bounds. It must be in [1901,2199]");
                int length = Date.monthLength(m, Date.isLeap(y));
                if (d > length) {
                    d = length;
                }
                long result = Date.fromDMY(d, m, y);
                return result;
            }
            case Years: {
                int d = date.dayOfMonth();
                int m = date.month().value();
                int y = date.year() + n;
                QL.ensure(y > 1900 && y <= 2199, "year out of bounds. It must be in [1901,2199]");
                if (d == 29 && m == Month.February.value() && !Date.isLeap(y)) {
                    d = 28;
                }
                long result = Date.fromDMY(d, m, y);
                return result;
            }
        }
        throw new LibraryException("undefined time units");
    }

    public static final Date todaysDate() {
        Calendar cal = Calendar.getInstance();
        int d = cal.get(5);
        int m = cal.get(2);
        int y = cal.get(1);
        return new Date(d, m + 1, y);
    }

    public static final Date minDate() {
        return new Date(Date.minimumSerialNumber());
    }

    public static final Date maxDate() {
        return new Date(Date.maximumSerialNumber());
    }

    public static final boolean isLeap(int year) {
        return yearIsLeap[year - 1900];
    }

    public static final Date endOfMonth(Date d) {
        int m = d.month().value();
        int y = d.year();
        return new Date(Date.monthLength(m, Date.isLeap(y)), m, y);
    }

    public static final boolean isEndOfMonth(Date d) {
        return d.dayOfMonth() == Date.monthLength(d.month().value(), Date.isLeap(d.year()));
    }

    public static final Date nextWeekday(Date d, Weekday w) {
        int wd = d.weekday().value();
        int dow = w.value();
        return new Date(d.serialNumber + (long)(wd > dow ? 7 : 0) - (long)wd + (long)dow);
    }

    public static final Date nthWeekday(int n, Weekday w, Month m, int y) {
        return Date.nthWeekday(n, w, m.value(), y);
    }

    public static final Date nthWeekday(int nth, Weekday dayOfWeek, int month, int year) {
        QL.require(nth > 0, "zeroth day of week in a given (month, year) is undefined");
        QL.require(nth < 6, "no more than 5 weekday in a given (month, year)");
        int m = month;
        int y = year;
        int dow = dayOfWeek.value();
        int first = new Date(1, m, y).weekday().value();
        int skip = nth - (dow >= first ? 1 : 0);
        return new Date(1 + dow - first + skip * 7, m, y);
    }

    public static Date min(Date ... t) {
        QL.require(t != null, "argument cannot be null");
        if (t.length == 0) {
            return new Date();
        }
        Date min = t[0];
        for (int i = 1; i < t.length; ++i) {
            Date curr = t[i];
            if (!curr.lt(min)) continue;
            min = curr;
        }
        return min;
    }

    public static Date max(Date ... t) {
        QL.require(t != null, "argument cannot be null");
        if (t.length == 0) {
            return new Date();
        }
        Date max = t[0];
        for (int i = 1; i < t.length; ++i) {
            Date curr = t[i];
            if (!curr.gt(max)) continue;
            max = curr;
        }
        return max;
    }

    private static long minimumSerialNumber() {
        return 367L;
    }

    private static long maximumSerialNumber() {
        return 109574L;
    }

    private static final long fromDMY(int d, int m, int y) {
        QL.require(y > 1900 && y <= 2199, "year(" + y + ") out of bound. It must be in [1901,2199]");
        QL.require(m > 0 && m < 13, "month outside JANUARY-December range [1,12]");
        boolean leap = Date.isLeap(y);
        int len = Date.monthLength(m, leap);
        int offset = Date.monthOffset(m, leap);
        QL.ensure(d > 0 && d <= len, "day outside month day-range");
        long result = (long)(d + offset) + Date.yearOffset(y);
        return result;
    }

    private static final int monthLength(int m, boolean leapYear) {
        return leapYear ? monthLeapLength[m - 1] : monthLength[m - 1];
    }

    private static final int monthOffset(int m, boolean leapYear) {
        return leapYear ? monthLeapOffset[m - 1] : monthOffset[m - 1];
    }

    private static final long yearOffset(int year) {
        return yearOffset[year - 1900];
    }

    public static int lowerBound(List<Date> dates, Date value) {
        int len = dates.size();
        int from = 0;
        while (len > 0) {
            int half = len >> 1;
            int middle = from;
            if (value.compareTo(dates.get(middle += half)) == 1) {
                from = middle;
                ++from;
                len = len - half - 1;
                continue;
            }
            len = half;
        }
        return from;
    }

    public static int upperBound(List<Date> dates, Date value) {
        int len = dates.size();
        int from = 0;
        while (len > 0) {
            int half = len >> 1;
            int middle = from;
            if (value.compareTo(dates.get(middle += half)) == -1) {
                len = half;
                continue;
            }
            from = middle;
            ++from;
            len = len - half - 1;
        }
        return from;
    }

    private final class ISODate
    extends java.util.Date {
        private static final long serialVersionUID = 4824909887446169897L;

        private ISODate() {
            super((Date.this.serialNumber - 25569L) * 86400000L);
        }

        @Override
        public final String toString() {
            if (Date.this.isNull()) {
                return "null date";
            }
            StringBuilder sb = new StringBuilder();
            Formatter formatter = new Formatter(sb, Locale.US);
            Calendar c = Calendar.getInstance();
            c.setTime(this);
            formatter.format("%04d-%02d-%02d", c.get(1), c.get(2) + 1, c.get(5));
            return sb.toString();
        }
    }

    private final class ShortDate
    extends java.util.Date {
        private static final long serialVersionUID = -4372510060405020533L;

        private ShortDate() {
            super((Date.this.serialNumber - 25569L) * 86400000L);
        }

        @Override
        public final String toString() {
            if (Date.this.isNull()) {
                return "null date";
            }
            StringBuilder sb = new StringBuilder();
            Formatter formatter = new Formatter(sb, Locale.US);
            formatter.format("%02d/%02d/%4d", Date.this.month().value(), Date.this.dayOfMonth(), Date.this.year());
            return sb.toString();
        }
    }

    private final class LongDate
    extends java.util.Date {
        private static final long serialVersionUID = -8382775848256835100L;

        private LongDate() {
            super((Date.this.serialNumber - 25569L) * 86400000L);
        }

        @Override
        public final String toString() {
            if (Date.this.isNull()) {
                return "null date";
            }
            StringBuilder sb = new StringBuilder();
            Formatter formatter = new Formatter(sb, Locale.US);
            formatter.format("%s %d, %d", new Object[]{Date.this.month(), Date.this.dayOfMonth(), Date.this.year()});
            return sb.toString();
        }
    }
}

