/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.testsuite.time;

import java.util.ArrayList;
import java.util.Iterator;
import org.jquantlib.QL;
import org.jquantlib.time.BusinessDayConvention;
import org.jquantlib.time.Date;
import org.jquantlib.time.DateGeneration;
import org.jquantlib.time.Month;
import org.jquantlib.time.Period;
import org.jquantlib.time.Schedule;
import org.jquantlib.time.TimeUnit;
import org.jquantlib.time.calendars.Target;
import org.junit.Assert;
import org.junit.Test;

public class ScheduleTest {
    private final Date startDate;

    public ScheduleTest() {
        QL.info("::::: " + this.getClass().getSimpleName() + " :::::");
        this.startDate = new Date(20, Month.August, 2007);
    }

    @Test
    public void testSchedule() {
        Target calendar = new Target();
        Period maturity = new Period(30, TimeUnit.Years);
        Date maturityDate = this.startDate.add(maturity);
        Period accPeriodTenor = new Period(6, TimeUnit.Months);
        BusinessDayConvention modFollow = BusinessDayConvention.ModifiedFollowing;
        DateGeneration.Rule dateRule = DateGeneration.Rule.Backward;
        Schedule firstConstrSchedule = new Schedule(this.startDate, maturityDate, accPeriodTenor, calendar, modFollow, modFollow, dateRule, false, null, null);
        ArrayList<Date> dates = new ArrayList<Date>();
        dates.add(this.startDate);
        dates.add(calendar.advance(this.startDate, new Period(10, TimeUnit.Weeks), modFollow));
        Schedule secondConstrSchedule = new Schedule(dates, calendar, modFollow);
        this.testDateAfter(firstConstrSchedule);
        this.testDateAfter(secondConstrSchedule);
        this.testNextAndPrevDate(firstConstrSchedule);
        this.testNextAndPrevDate(secondConstrSchedule);
        this.testIsRegular(firstConstrSchedule);
    }

    private void testDateAfter(Schedule schedule) {
        Iterator<Date> dates = schedule.getDatesAfter(this.startDate);
        while (dates.hasNext()) {
            Assert.assertTrue((boolean)this.startDate.lt(dates.next()));
        }
        dates = schedule.getDatesAfter(this.startDate);
        while (dates.hasNext()) {
            Assert.assertTrue((boolean)this.startDate.lt(dates.next()));
        }
    }

    private void testNextAndPrevDate(Schedule schedule) {
        Date nextDate = schedule.nextDate(this.startDate);
        Assert.assertTrue((boolean)nextDate.ge(this.startDate));
        Date prevDate = schedule.previousDate(nextDate);
        Assert.assertTrue((boolean)nextDate.gt(prevDate));
        Assert.assertTrue((boolean)prevDate.lt(nextDate));
    }

    private void testIsRegular(Schedule schedule) {
        for (int i = 0; i < 2; ++i) {
            schedule.isRegular(i + 1);
        }
    }
}

