/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.testsuite.pricingengines;

import java.util.HashMap;
import java.util.Map;
import org.jquantlib.QL;
import org.jquantlib.Settings;
import org.jquantlib.daycounters.Actual360;
import org.jquantlib.daycounters.DayCounter;
import org.jquantlib.exercise.EuropeanExercise;
import org.jquantlib.exercise.Exercise;
import org.jquantlib.instruments.AssetOrNothingPayoff;
import org.jquantlib.instruments.CashOrNothingPayoff;
import org.jquantlib.instruments.EuropeanOption;
import org.jquantlib.instruments.GapPayoff;
import org.jquantlib.instruments.Option;
import org.jquantlib.instruments.PlainVanillaPayoff;
import org.jquantlib.instruments.StrikedTypePayoff;
import org.jquantlib.pricingengines.vanilla.JumpDiffusionEngine;
import org.jquantlib.processes.Merton76Process;
import org.jquantlib.quotes.Handle;
import org.jquantlib.quotes.SimpleQuote;
import org.jquantlib.termstructures.BlackVolTermStructure;
import org.jquantlib.termstructures.YieldTermStructure;
import org.jquantlib.testsuite.util.Utilities;
import org.jquantlib.time.Date;
import org.junit.Assert;
import org.junit.Test;

public class JumpDiffusionEngineTest {
    public JumpDiffusionEngineTest() {
        QL.info("::::: " + this.getClass().getSimpleName() + " :::::");
    }

    @Test
    public void testMerton76() {
        QL.info("Testing Merton 76 jump-diffusion model for European options...");
        HaugMertonData[] values = new HaugMertonData[]{new HaugMertonData(Option.Type.Call, 80.0, 100.0, 0.0, 0.08, 0.1, 0.25, 1.0, 0.25, 20.67, 0.01), new HaugMertonData(Option.Type.Call, 80.0, 100.0, 0.0, 0.08, 0.25, 0.25, 1.0, 0.25, 21.74, 0.01), new HaugMertonData(Option.Type.Call, 80.0, 100.0, 0.0, 0.08, 0.5, 0.25, 1.0, 0.25, 23.63, 0.01), new HaugMertonData(Option.Type.Call, 80.0, 100.0, 0.0, 0.08, 0.1, 0.25, 5.0, 0.25, 20.65, 0.01), new HaugMertonData(Option.Type.Call, 80.0, 100.0, 0.0, 0.08, 0.25, 0.25, 5.0, 0.25, 21.7, 0.01), new HaugMertonData(Option.Type.Call, 80.0, 100.0, 0.0, 0.08, 0.5, 0.25, 5.0, 0.25, 23.61, 0.01), new HaugMertonData(Option.Type.Call, 80.0, 100.0, 0.0, 0.08, 0.1, 0.25, 10.0, 0.25, 20.64, 0.01), new HaugMertonData(Option.Type.Call, 80.0, 100.0, 0.0, 0.08, 0.25, 0.25, 10.0, 0.25, 21.7, 0.01), new HaugMertonData(Option.Type.Call, 80.0, 100.0, 0.0, 0.08, 0.5, 0.25, 10.0, 0.25, 23.61, 0.01), new HaugMertonData(Option.Type.Call, 90.0, 100.0, 0.0, 0.08, 0.1, 0.25, 1.0, 0.25, 11.0, 0.01), new HaugMertonData(Option.Type.Call, 90.0, 100.0, 0.0, 0.08, 0.25, 0.25, 1.0, 0.25, 12.74, 0.01), new HaugMertonData(Option.Type.Call, 90.0, 100.0, 0.0, 0.08, 0.5, 0.25, 1.0, 0.25, 15.4, 0.01), new HaugMertonData(Option.Type.Call, 90.0, 100.0, 0.0, 0.08, 0.1, 0.25, 5.0, 0.25, 10.98, 0.01), new HaugMertonData(Option.Type.Call, 90.0, 100.0, 0.0, 0.08, 0.25, 0.25, 5.0, 0.25, 12.75, 0.01), new HaugMertonData(Option.Type.Call, 90.0, 100.0, 0.0, 0.08, 0.5, 0.25, 5.0, 0.25, 15.42, 0.01), new HaugMertonData(Option.Type.Call, 90.0, 100.0, 0.0, 0.08, 0.1, 0.25, 10.0, 0.25, 10.98, 0.01), new HaugMertonData(Option.Type.Call, 90.0, 100.0, 0.0, 0.08, 0.25, 0.25, 10.0, 0.25, 12.75, 0.01), new HaugMertonData(Option.Type.Call, 90.0, 100.0, 0.0, 0.08, 0.5, 0.25, 10.0, 0.25, 15.42, 0.01), new HaugMertonData(Option.Type.Call, 100.0, 100.0, 0.0, 0.08, 0.1, 0.25, 1.0, 0.25, 3.42, 0.01), new HaugMertonData(Option.Type.Call, 100.0, 100.0, 0.0, 0.08, 0.25, 0.25, 1.0, 0.25, 5.88, 0.01), new HaugMertonData(Option.Type.Call, 100.0, 100.0, 0.0, 0.08, 0.5, 0.25, 1.0, 0.25, 8.95, 0.01), new HaugMertonData(Option.Type.Call, 100.0, 100.0, 0.0, 0.08, 0.1, 0.25, 5.0, 0.25, 3.51, 0.01), new HaugMertonData(Option.Type.Call, 100.0, 100.0, 0.0, 0.08, 0.25, 0.25, 5.0, 0.25, 5.96, 0.01), new HaugMertonData(Option.Type.Call, 100.0, 100.0, 0.0, 0.08, 0.5, 0.25, 5.0, 0.25, 9.02, 0.01), new HaugMertonData(Option.Type.Call, 100.0, 100.0, 0.0, 0.08, 0.1, 0.25, 10.0, 0.25, 3.53, 0.01), new HaugMertonData(Option.Type.Call, 100.0, 100.0, 0.0, 0.08, 0.25, 0.25, 10.0, 0.25, 5.97, 0.01), new HaugMertonData(Option.Type.Call, 100.0, 100.0, 0.0, 0.08, 0.5, 0.25, 10.0, 0.25, 9.03, 0.01), new HaugMertonData(Option.Type.Call, 110.0, 100.0, 0.0, 0.08, 0.1, 0.25, 1.0, 0.25, 0.55, 0.01), new HaugMertonData(Option.Type.Call, 110.0, 100.0, 0.0, 0.08, 0.25, 0.25, 1.0, 0.25, 2.11, 0.01), new HaugMertonData(Option.Type.Call, 110.0, 100.0, 0.0, 0.08, 0.5, 0.25, 1.0, 0.25, 4.67, 0.01), new HaugMertonData(Option.Type.Call, 110.0, 100.0, 0.0, 0.08, 0.1, 0.25, 5.0, 0.25, 0.56, 0.01), new HaugMertonData(Option.Type.Call, 110.0, 100.0, 0.0, 0.08, 0.25, 0.25, 5.0, 0.25, 2.16, 0.01), new HaugMertonData(Option.Type.Call, 110.0, 100.0, 0.0, 0.08, 0.5, 0.25, 5.0, 0.25, 4.73, 0.01), new HaugMertonData(Option.Type.Call, 110.0, 100.0, 0.0, 0.08, 0.1, 0.25, 10.0, 0.25, 0.56, 0.01), new HaugMertonData(Option.Type.Call, 110.0, 100.0, 0.0, 0.08, 0.25, 0.25, 10.0, 0.25, 2.17, 0.01), new HaugMertonData(Option.Type.Call, 110.0, 100.0, 0.0, 0.08, 0.5, 0.25, 10.0, 0.25, 4.74, 0.01), new HaugMertonData(Option.Type.Call, 120.0, 100.0, 0.0, 0.08, 0.1, 0.25, 1.0, 0.25, 0.1, 0.01), new HaugMertonData(Option.Type.Call, 120.0, 100.0, 0.0, 0.08, 0.25, 0.25, 1.0, 0.25, 0.64, 0.01), new HaugMertonData(Option.Type.Call, 120.0, 100.0, 0.0, 0.08, 0.5, 0.25, 1.0, 0.25, 2.23, 0.01), new HaugMertonData(Option.Type.Call, 120.0, 100.0, 0.0, 0.08, 0.1, 0.25, 5.0, 0.25, 0.06, 0.01), new HaugMertonData(Option.Type.Call, 120.0, 100.0, 0.0, 0.08, 0.25, 0.25, 5.0, 0.25, 0.63, 0.01), new HaugMertonData(Option.Type.Call, 120.0, 100.0, 0.0, 0.08, 0.5, 0.25, 5.0, 0.25, 2.25, 0.01), new HaugMertonData(Option.Type.Call, 120.0, 100.0, 0.0, 0.08, 0.1, 0.25, 10.0, 0.25, 0.05, 0.01), new HaugMertonData(Option.Type.Call, 120.0, 100.0, 0.0, 0.08, 0.25, 0.25, 10.0, 0.25, 0.62, 0.01), new HaugMertonData(Option.Type.Call, 120.0, 100.0, 0.0, 0.08, 0.5, 0.25, 10.0, 0.25, 2.25, 0.01), new HaugMertonData(Option.Type.Call, 80.0, 100.0, 0.0, 0.08, 0.1, 0.25, 1.0, 0.5, 20.72, 0.01), new HaugMertonData(Option.Type.Call, 80.0, 100.0, 0.0, 0.08, 0.25, 0.25, 1.0, 0.5, 21.83, 0.01), new HaugMertonData(Option.Type.Call, 80.0, 100.0, 0.0, 0.08, 0.5, 0.25, 1.0, 0.5, 23.71, 0.01), new HaugMertonData(Option.Type.Call, 80.0, 100.0, 0.0, 0.08, 0.1, 0.25, 5.0, 0.5, 20.66, 0.01), new HaugMertonData(Option.Type.Call, 80.0, 100.0, 0.0, 0.08, 0.25, 0.25, 5.0, 0.5, 21.73, 0.01), new HaugMertonData(Option.Type.Call, 80.0, 100.0, 0.0, 0.08, 0.5, 0.25, 5.0, 0.5, 23.63, 0.01), new HaugMertonData(Option.Type.Call, 80.0, 100.0, 0.0, 0.08, 0.1, 0.25, 10.0, 0.5, 20.65, 0.01), new HaugMertonData(Option.Type.Call, 80.0, 100.0, 0.0, 0.08, 0.25, 0.25, 10.0, 0.5, 21.71, 0.01), new HaugMertonData(Option.Type.Call, 80.0, 100.0, 0.0, 0.08, 0.5, 0.25, 10.0, 0.5, 23.61, 0.01), new HaugMertonData(Option.Type.Call, 90.0, 100.0, 0.0, 0.08, 0.1, 0.25, 1.0, 0.5, 11.04, 0.01), new HaugMertonData(Option.Type.Call, 90.0, 100.0, 0.0, 0.08, 0.25, 0.25, 1.0, 0.5, 12.72, 0.01), new HaugMertonData(Option.Type.Call, 90.0, 100.0, 0.0, 0.08, 0.5, 0.25, 1.0, 0.5, 15.34, 0.01), new HaugMertonData(Option.Type.Call, 90.0, 100.0, 0.0, 0.08, 0.1, 0.25, 5.0, 0.5, 11.02, 0.01), new HaugMertonData(Option.Type.Call, 90.0, 100.0, 0.0, 0.08, 0.25, 0.25, 5.0, 0.5, 12.76, 0.01), new HaugMertonData(Option.Type.Call, 90.0, 100.0, 0.0, 0.08, 0.5, 0.25, 5.0, 0.5, 15.41, 0.01), new HaugMertonData(Option.Type.Call, 90.0, 100.0, 0.0, 0.08, 0.1, 0.25, 10.0, 0.5, 11.0, 0.01), new HaugMertonData(Option.Type.Call, 90.0, 100.0, 0.0, 0.08, 0.25, 0.25, 10.0, 0.5, 12.75, 0.01), new HaugMertonData(Option.Type.Call, 90.0, 100.0, 0.0, 0.08, 0.5, 0.25, 10.0, 0.5, 15.41, 0.01), new HaugMertonData(Option.Type.Call, 100.0, 100.0, 0.0, 0.08, 0.1, 0.25, 1.0, 0.5, 3.14, 0.01), new HaugMertonData(Option.Type.Call, 100.0, 100.0, 0.0, 0.08, 0.25, 0.25, 1.0, 0.5, 5.58, 0.01), new HaugMertonData(Option.Type.Call, 100.0, 100.0, 0.0, 0.08, 0.5, 0.25, 1.0, 0.5, 8.71, 0.01), new HaugMertonData(Option.Type.Call, 100.0, 100.0, 0.0, 0.08, 0.1, 0.25, 5.0, 0.5, 3.39, 0.01), new HaugMertonData(Option.Type.Call, 100.0, 100.0, 0.0, 0.08, 0.25, 0.25, 5.0, 0.5, 5.87, 0.01), new HaugMertonData(Option.Type.Call, 100.0, 100.0, 0.0, 0.08, 0.5, 0.25, 5.0, 0.5, 8.96, 0.01), new HaugMertonData(Option.Type.Call, 100.0, 100.0, 0.0, 0.08, 0.1, 0.25, 10.0, 0.5, 3.46, 0.01), new HaugMertonData(Option.Type.Call, 100.0, 100.0, 0.0, 0.08, 0.25, 0.25, 10.0, 0.5, 5.93, 0.01), new HaugMertonData(Option.Type.Call, 100.0, 100.0, 0.0, 0.08, 0.5, 0.25, 10.0, 0.5, 9.0, 0.01), new HaugMertonData(Option.Type.Call, 110.0, 100.0, 0.0, 0.08, 0.1, 0.25, 1.0, 0.5, 0.53, 0.01), new HaugMertonData(Option.Type.Call, 110.0, 100.0, 0.0, 0.08, 0.25, 0.25, 1.0, 0.5, 1.93, 0.01), new HaugMertonData(Option.Type.Call, 110.0, 100.0, 0.0, 0.08, 0.5, 0.25, 1.0, 0.5, 4.42, 0.01), new HaugMertonData(Option.Type.Call, 110.0, 100.0, 0.0, 0.08, 0.1, 0.25, 5.0, 0.5, 0.58, 0.01), new HaugMertonData(Option.Type.Call, 110.0, 100.0, 0.0, 0.08, 0.25, 0.25, 5.0, 0.5, 2.11, 0.01), new HaugMertonData(Option.Type.Call, 110.0, 100.0, 0.0, 0.08, 0.5, 0.25, 5.0, 0.5, 4.67, 0.01), new HaugMertonData(Option.Type.Call, 110.0, 100.0, 0.0, 0.08, 0.1, 0.25, 10.0, 0.5, 0.57, 0.01), new HaugMertonData(Option.Type.Call, 110.0, 100.0, 0.0, 0.08, 0.25, 0.25, 10.0, 0.5, 2.14, 0.01), new HaugMertonData(Option.Type.Call, 110.0, 100.0, 0.0, 0.08, 0.5, 0.25, 10.0, 0.5, 4.71, 0.01), new HaugMertonData(Option.Type.Call, 120.0, 100.0, 0.0, 0.08, 0.1, 0.25, 1.0, 0.5, 0.19, 0.01), new HaugMertonData(Option.Type.Call, 120.0, 100.0, 0.0, 0.08, 0.25, 0.25, 1.0, 0.5, 0.71, 0.01), new HaugMertonData(Option.Type.Call, 120.0, 100.0, 0.0, 0.08, 0.5, 0.25, 1.0, 0.5, 2.15, 0.01), new HaugMertonData(Option.Type.Call, 120.0, 100.0, 0.0, 0.08, 0.1, 0.25, 5.0, 0.5, 0.1, 0.01), new HaugMertonData(Option.Type.Call, 120.0, 100.0, 0.0, 0.08, 0.25, 0.25, 5.0, 0.5, 0.66, 0.01), new HaugMertonData(Option.Type.Call, 120.0, 100.0, 0.0, 0.08, 0.5, 0.25, 5.0, 0.5, 2.23, 0.01), new HaugMertonData(Option.Type.Call, 120.0, 100.0, 0.0, 0.08, 0.1, 0.25, 10.0, 0.5, 0.07, 0.01), new HaugMertonData(Option.Type.Call, 120.0, 100.0, 0.0, 0.08, 0.25, 0.25, 10.0, 0.5, 0.64, 0.01), new HaugMertonData(Option.Type.Call, 120.0, 100.0, 0.0, 0.08, 0.5, 0.25, 10.0, 0.5, 2.24, 0.01), new HaugMertonData(Option.Type.Call, 80.0, 100.0, 0.0, 0.08, 0.1, 0.25, 1.0, 0.75, 20.79, 0.01), new HaugMertonData(Option.Type.Call, 80.0, 100.0, 0.0, 0.08, 0.25, 0.25, 1.0, 0.75, 21.96, 0.01), new HaugMertonData(Option.Type.Call, 80.0, 100.0, 0.0, 0.08, 0.5, 0.25, 1.0, 0.75, 23.86, 0.01), new HaugMertonData(Option.Type.Call, 80.0, 100.0, 0.0, 0.08, 0.1, 0.25, 5.0, 0.75, 20.68, 0.01), new HaugMertonData(Option.Type.Call, 80.0, 100.0, 0.0, 0.08, 0.25, 0.25, 5.0, 0.75, 21.78, 0.01), new HaugMertonData(Option.Type.Call, 80.0, 100.0, 0.0, 0.08, 0.5, 0.25, 5.0, 0.75, 23.67, 0.01), new HaugMertonData(Option.Type.Call, 80.0, 100.0, 0.0, 0.08, 0.1, 0.25, 10.0, 0.75, 20.66, 0.01), new HaugMertonData(Option.Type.Call, 80.0, 100.0, 0.0, 0.08, 0.25, 0.25, 10.0, 0.75, 21.74, 0.01), new HaugMertonData(Option.Type.Call, 80.0, 100.0, 0.0, 0.08, 0.5, 0.25, 10.0, 0.75, 23.64, 0.01), new HaugMertonData(Option.Type.Call, 90.0, 100.0, 0.0, 0.08, 0.1, 0.25, 1.0, 0.75, 11.11, 0.01), new HaugMertonData(Option.Type.Call, 90.0, 100.0, 0.0, 0.08, 0.25, 0.25, 1.0, 0.75, 12.75, 0.01), new HaugMertonData(Option.Type.Call, 90.0, 100.0, 0.0, 0.08, 0.5, 0.25, 1.0, 0.75, 15.3, 0.01), new HaugMertonData(Option.Type.Call, 90.0, 100.0, 0.0, 0.08, 0.1, 0.25, 5.0, 0.75, 11.09, 0.01), new HaugMertonData(Option.Type.Call, 90.0, 100.0, 0.0, 0.08, 0.25, 0.25, 5.0, 0.75, 12.78, 0.01), new HaugMertonData(Option.Type.Call, 90.0, 100.0, 0.0, 0.08, 0.5, 0.25, 5.0, 0.75, 15.39, 0.01), new HaugMertonData(Option.Type.Call, 90.0, 100.0, 0.0, 0.08, 0.1, 0.25, 10.0, 0.75, 11.04, 0.01), new HaugMertonData(Option.Type.Call, 90.0, 100.0, 0.0, 0.08, 0.25, 0.25, 10.0, 0.75, 12.76, 0.01), new HaugMertonData(Option.Type.Call, 90.0, 100.0, 0.0, 0.08, 0.5, 0.25, 10.0, 0.75, 15.4, 0.01), new HaugMertonData(Option.Type.Call, 100.0, 100.0, 0.0, 0.08, 0.1, 0.25, 1.0, 0.75, 2.7, 0.01), new HaugMertonData(Option.Type.Call, 100.0, 100.0, 0.0, 0.08, 0.25, 0.25, 1.0, 0.75, 5.08, 0.01), new HaugMertonData(Option.Type.Call, 100.0, 100.0, 0.0, 0.08, 0.5, 0.25, 1.0, 0.75, 8.24, 0.01), new HaugMertonData(Option.Type.Call, 100.0, 100.0, 0.0, 0.08, 0.1, 0.25, 5.0, 0.75, 3.16, 0.01), new HaugMertonData(Option.Type.Call, 100.0, 100.0, 0.0, 0.08, 0.25, 0.25, 5.0, 0.75, 5.71, 0.01), new HaugMertonData(Option.Type.Call, 100.0, 100.0, 0.0, 0.08, 0.5, 0.25, 5.0, 0.75, 8.85, 0.01), new HaugMertonData(Option.Type.Call, 100.0, 100.0, 0.0, 0.08, 0.1, 0.25, 10.0, 0.75, 3.33, 0.01), new HaugMertonData(Option.Type.Call, 100.0, 100.0, 0.0, 0.08, 0.25, 0.25, 10.0, 0.75, 5.85, 0.01), new HaugMertonData(Option.Type.Call, 100.0, 100.0, 0.0, 0.08, 0.5, 0.25, 10.0, 0.75, 8.95, 0.01), new HaugMertonData(Option.Type.Call, 110.0, 100.0, 0.0, 0.08, 0.1, 0.25, 1.0, 0.75, 0.54, 0.01), new HaugMertonData(Option.Type.Call, 110.0, 100.0, 0.0, 0.08, 0.25, 0.25, 1.0, 0.75, 1.69, 0.01), new HaugMertonData(Option.Type.Call, 110.0, 100.0, 0.0, 0.08, 0.5, 0.25, 1.0, 0.75, 3.99, 0.01), new HaugMertonData(Option.Type.Call, 110.0, 100.0, 0.0, 0.08, 0.1, 0.25, 5.0, 0.75, 0.62, 0.01), new HaugMertonData(Option.Type.Call, 110.0, 100.0, 0.0, 0.08, 0.25, 0.25, 5.0, 0.75, 2.05, 0.01), new HaugMertonData(Option.Type.Call, 110.0, 100.0, 0.0, 0.08, 0.5, 0.25, 5.0, 0.75, 4.57, 0.01), new HaugMertonData(Option.Type.Call, 110.0, 100.0, 0.0, 0.08, 0.1, 0.25, 10.0, 0.75, 0.6, 0.01), new HaugMertonData(Option.Type.Call, 110.0, 100.0, 0.0, 0.08, 0.25, 0.25, 10.0, 0.75, 2.11, 0.01), new HaugMertonData(Option.Type.Call, 110.0, 100.0, 0.0, 0.08, 0.5, 0.25, 10.0, 0.75, 4.66, 0.01), new HaugMertonData(Option.Type.Call, 120.0, 100.0, 0.0, 0.08, 0.1, 0.25, 1.0, 0.75, 0.29, 0.01), new HaugMertonData(Option.Type.Call, 120.0, 100.0, 0.0, 0.08, 0.25, 0.25, 1.0, 0.75, 0.84, 0.01), new HaugMertonData(Option.Type.Call, 120.0, 100.0, 0.0, 0.08, 0.5, 0.25, 1.0, 0.75, 2.09, 0.01), new HaugMertonData(Option.Type.Call, 120.0, 100.0, 0.0, 0.08, 0.1, 0.25, 5.0, 0.75, 0.15, 0.01), new HaugMertonData(Option.Type.Call, 120.0, 100.0, 0.0, 0.08, 0.25, 0.25, 5.0, 0.75, 0.71, 0.01), new HaugMertonData(Option.Type.Call, 120.0, 100.0, 0.0, 0.08, 0.5, 0.25, 5.0, 0.75, 2.21, 0.01), new HaugMertonData(Option.Type.Call, 120.0, 100.0, 0.0, 0.08, 0.1, 0.25, 10.0, 0.75, 0.11, 0.01), new HaugMertonData(Option.Type.Call, 120.0, 100.0, 0.0, 0.08, 0.25, 0.25, 10.0, 0.75, 0.67, 0.01), new HaugMertonData(Option.Type.Call, 120.0, 100.0, 0.0, 0.08, 0.5, 0.25, 10.0, 0.75, 2.23, 0.01)};
        Date today = new Settings().evaluationDate();
        Actual360 dc = new Actual360();
        SimpleQuote spot = new SimpleQuote(0.0);
        SimpleQuote qRate = new SimpleQuote(0.0);
        YieldTermStructure qTS = Utilities.flatRate(today, qRate, (DayCounter)dc);
        SimpleQuote rRate = new SimpleQuote(0.0);
        YieldTermStructure rTS = Utilities.flatRate(today, rRate, (DayCounter)dc);
        SimpleQuote vol = new SimpleQuote(0.0);
        BlackVolTermStructure volTS = Utilities.flatVol(today, vol, (DayCounter)dc);
        SimpleQuote jumpIntensity = new SimpleQuote(0.0);
        SimpleQuote meanLogJump = new SimpleQuote(0.0);
        SimpleQuote jumpVol = new SimpleQuote(0.0);
        Merton76Process stochProcess = new Merton76Process(new Handle<SimpleQuote>(spot), new Handle<YieldTermStructure>(qTS), new Handle<YieldTermStructure>(rTS), new Handle<BlackVolTermStructure>(volTS), new Handle<SimpleQuote>(jumpIntensity), new Handle<SimpleQuote>(meanLogJump), new Handle<SimpleQuote>(jumpVol));
        JumpDiffusionEngine engine = new JumpDiffusionEngine(stochProcess);
        for (HaugMertonData value : values) {
            PlainVanillaPayoff payoff = new PlainVanillaPayoff(value.type, value.strike);
            Date exDate = today.add((int)(value.t * 360.0 + 0.5));
            EuropeanExercise exercise = new EuropeanExercise(exDate);
            spot.setValue(value.s);
            qRate.setValue(value.q);
            rRate.setValue(value.r);
            jumpIntensity.setValue(value.jumpIntensity);
            double jVol = value.v * Math.sqrt(value.gamma / value.jumpIntensity);
            jumpVol.setValue(jVol);
            double diffusionVol = value.v * Math.sqrt(1.0 - value.gamma);
            vol.setValue(diffusionVol);
            double meanJump = 0.0;
            meanLogJump.setValue(Math.log(1.0) - 0.5 * jVol * jVol);
            double totalVol = Math.sqrt(value.jumpIntensity * jVol * jVol + diffusionVol * diffusionVol);
            double volError = Math.abs(totalVol - value.v);
            if (volError >= 1.0E-13) {
                throw new ArithmeticException(" mismatch");
            }
            EuropeanOption option = new EuropeanOption(payoff, exercise);
            option.setPricingEngine(engine);
            double calculated = option.NPV();
            double error = Math.abs(calculated - value.result);
            if (!(error > value.tol)) continue;
            this.REPORT_FAILURE_2("value", payoff, exercise, value.s, value.q, value.r, today, value.v, value.jumpIntensity, value.gamma, value.result, calculated, error, value.tol);
        }
    }

    private void REPORT_FAILURE_2(String greekName, StrikedTypePayoff payoff, Exercise exercise, double s, double q, double r, Date today, double v, double intensity, double gamma, double expected, double calculated, double error, double tolerance) {
        Assert.fail((String)(exercise + " " + (Object)((Object)payoff.optionType()) + " option with " + payoff + " payoff:\n" + "    underlying value: " + s + "\n" + "    strike:           " + payoff.strike() + "\n" + "    dividend yield:   " + q + "\n" + "    risk-free rate:   " + r + "\n" + "    reference date:   " + today + "\n" + "    maturity:         " + exercise.lastDate() + "\n" + "    volatility:       " + v + "\n" + "    intensity:        " + intensity + "\n" + "    gamma:            " + gamma + "\n\n" + "    expected   " + greekName + ": " + expected + "\n" + "    calculated " + greekName + ": " + calculated + "\n" + "    error:            " + error + "\n" + "    tolerance:        " + tolerance));
    }

    @Test
    public void testGreeks() {
        QL.info("Testing jump-diffusion option greeks...");
        HashMap<String, Double> calculated = new HashMap<String, Double>();
        HashMap<String, Double> expected = new HashMap<String, Double>();
        HashMap<String, Double> tolerance = new HashMap<String, Double>();
        tolerance.put("delta", 1.0E-4);
        tolerance.put("gamma", 1.0E-4);
        tolerance.put("theta", 1.1E-4);
        tolerance.put("rho", 1.0E-4);
        tolerance.put("divRho", 1.0E-4);
        tolerance.put("vega", 1.0E-4);
        Option.Type[] types = new Option.Type[]{Option.Type.Put, Option.Type.Call};
        double[] strikes = new double[]{50.0, 100.0, 150.0};
        double[] underlyings = new double[]{100.0};
        double[] qRates = new double[]{-0.05, 0.0, 0.05};
        double[] rRates = new double[]{0.0, 0.01, 0.2};
        double[] residualTimes = new double[]{5.0};
        double[] vols = new double[]{0.11};
        double[] jInt = new double[]{1.0, 5.0};
        double[] mLJ = new double[]{-0.2, 0.0, 0.2};
        double[] jV = new double[]{0.01, 0.25};
        Actual360 dc = new Actual360();
        new Settings().setEvaluationDate(Date.todaysDate());
        Date today = new Settings().evaluationDate();
        SimpleQuote spot = new SimpleQuote(0.0);
        SimpleQuote qRate = new SimpleQuote(0.0);
        YieldTermStructure qTS = Utilities.flatRate(qRate, (DayCounter)dc);
        SimpleQuote rRate = new SimpleQuote(0.0);
        YieldTermStructure rTS = Utilities.flatRate(rRate, (DayCounter)dc);
        SimpleQuote vol = new SimpleQuote(0.0);
        BlackVolTermStructure volTS = Utilities.flatVol(vol, (DayCounter)dc);
        SimpleQuote jumpIntensity = new SimpleQuote(0.0);
        SimpleQuote meanLogJump = new SimpleQuote(0.0);
        SimpleQuote jumpVol = new SimpleQuote(0.0);
        Merton76Process stochProcess = new Merton76Process(new Handle<SimpleQuote>(spot), new Handle<YieldTermStructure>(qTS), new Handle<YieldTermStructure>(rTS), new Handle<BlackVolTermStructure>(volTS), new Handle<SimpleQuote>(jumpIntensity), new Handle<SimpleQuote>(meanLogJump), new Handle<SimpleQuote>(jumpVol));
        JumpDiffusionEngine engine = new JumpDiffusionEngine(stochProcess, 1.0E-8);
        for (Option.Type type : types) {
            for (double strike : strikes) {
                for (double element : jInt) {
                    jumpIntensity.setValue(element);
                    for (double element2 : mLJ) {
                        meanLogJump.setValue(element2);
                        for (double element3 : jV) {
                            jumpVol.setValue(element3);
                            for (double residualTime : residualTimes) {
                                Date exDate = today.add((int)(residualTime * 360.0 + 0.5));
                                EuropeanExercise exercise = new EuropeanExercise(exDate);
                                for (int kk = 0; kk < 1; ++kk) {
                                    StrikedTypePayoff payoff = null;
                                    if (kk == 0) {
                                        payoff = new PlainVanillaPayoff(type, strike);
                                    } else if (kk == 1) {
                                        payoff = new CashOrNothingPayoff(type, strike, 100.0);
                                    } else if (kk == 2) {
                                        payoff = new AssetOrNothingPayoff(type, strike);
                                    } else if (kk == 3) {
                                        payoff = new GapPayoff(type, strike, 100.0);
                                    }
                                    EuropeanOption option = new EuropeanOption(payoff, exercise);
                                    option.setPricingEngine(engine);
                                    for (double u : underlyings) {
                                        for (double q : qRates) {
                                            for (double r : rRates) {
                                                for (double v : vols) {
                                                    spot.setValue(u);
                                                    qRate.setValue(q);
                                                    rRate.setValue(r);
                                                    vol.setValue(v);
                                                    double value = option.NPV();
                                                    calculated.put("delta", option.delta());
                                                    calculated.put("gamma", option.gamma());
                                                    calculated.put("theta", option.theta());
                                                    calculated.put("rho", option.rho());
                                                    calculated.put("divRho", option.dividendRho());
                                                    calculated.put("vega", option.vega());
                                                    if (!(value > spot.value() * 1.0E-5)) continue;
                                                    double du = u * 1.0E-5;
                                                    spot.setValue(u + du);
                                                    double value_p = option.NPV();
                                                    double delta_p = option.delta();
                                                    spot.setValue(u - du);
                                                    double value_m = option.NPV();
                                                    double delta_m = option.delta();
                                                    spot.setValue(u);
                                                    expected.put("delta", (value_p - value_m) / (2.0 * du));
                                                    expected.put("gamma", (delta_p - delta_m) / (2.0 * du));
                                                    double dr = 1.0E-5;
                                                    rRate.setValue(r + 1.0E-5);
                                                    value_p = option.NPV();
                                                    rRate.setValue(r - 1.0E-5);
                                                    value_m = option.NPV();
                                                    rRate.setValue(r);
                                                    expected.put("rho", (value_p - value_m) / 2.0E-5);
                                                    double dq = 1.0E-5;
                                                    qRate.setValue(q + 1.0E-5);
                                                    value_p = option.NPV();
                                                    qRate.setValue(q - 1.0E-5);
                                                    value_m = option.NPV();
                                                    qRate.setValue(q);
                                                    expected.put("divRho", (value_p - value_m) / 2.0E-5);
                                                    double dv = v * 1.0E-4;
                                                    vol.setValue(v + dv);
                                                    value_p = option.NPV();
                                                    vol.setValue(v - dv);
                                                    value_m = option.NPV();
                                                    vol.setValue(v);
                                                    expected.put("vega", (value_p - value_m) / (2.0 * dv));
                                                    Date yesterday = today.sub(1);
                                                    Date tomorrow = today.add(1);
                                                    double dT = dc.yearFraction(yesterday, tomorrow);
                                                    new Settings().setEvaluationDate(yesterday);
                                                    value_m = option.NPV();
                                                    new Settings().setEvaluationDate(tomorrow);
                                                    value_p = option.NPV();
                                                    new Settings().setEvaluationDate(today);
                                                    expected.put("theta", (value_p - value_m) / dT);
                                                    for (Map.Entry it : calculated.entrySet()) {
                                                        String greek = (String)it.getKey();
                                                        double expct = (Double)expected.get(greek);
                                                        double calcl = (Double)calculated.get(greek);
                                                        double tol = (Double)tolerance.get(greek);
                                                        double error = Math.abs(expct - calcl);
                                                        if (!(error > tol)) continue;
                                                        Assert.fail((String)("Failed on greek: " + greek));
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    private static class HaugMertonData {
        public Option.Type type;
        public double strike;
        public double s;
        public double q;
        public double r;
        public double t;
        public double v;
        public double jumpIntensity;
        public double gamma;
        public double result;
        public double tol;

        public HaugMertonData(Option.Type type, double strike, double spot, double q, double r, double t, double vol, double intensity, double gamma, double value, double tol) {
            this.type = type;
            this.strike = strike;
            this.s = spot;
            this.q = q;
            this.r = r;
            this.t = t;
            this.v = vol;
            this.jumpIntensity = intensity;
            this.gamma = gamma;
            this.result = value;
            this.tol = tol;
        }
    }
}

