/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.testsuite.patterns;

import org.jquantlib.QL;
import org.jquantlib.util.PolymorphicVisitable;
import org.jquantlib.util.PolymorphicVisitor;
import org.jquantlib.util.Visitor;
import org.junit.Assert;
import org.junit.Test;

public class VisitorTest {
    public VisitorTest() {
        QL.info("::::: " + this.getClass().getSimpleName() + " :::::");
    }

    @Test
    public void testPolymorphicVisitorPattern() {
        NumberPolymorphicVisitable numberPolymorphicVisitable = new NumberPolymorphicVisitable();
        DoublePolymorphicVisitable doublePolymorphicVisitable = new DoublePolymorphicVisitable();
        IntegerPolymorphicVisitable integerPolymorphicVisitable = new IntegerPolymorphicVisitable();
        NumberPolymorphicVisitor numberPolymorphicVisitor = new NumberPolymorphicVisitor();
        DoublePolymorphicVisitor doublePolymorphicVisitor = new DoublePolymorphicVisitor();
        IntegerPolymorphicVisitor integerPolymorphicVisitor = new IntegerPolymorphicVisitor();
        numberPolymorphicVisitable.accept(numberPolymorphicVisitor);
        doublePolymorphicVisitable.accept(numberPolymorphicVisitor);
        doublePolymorphicVisitable.accept(doublePolymorphicVisitor);
        integerPolymorphicVisitable.accept(numberPolymorphicVisitor);
        integerPolymorphicVisitable.accept(integerPolymorphicVisitor);
        try {
            numberPolymorphicVisitable.accept(doublePolymorphicVisitor);
            Assert.fail((String)"numberPolymorphicVisitable.accept(doublePolymorphicVisitor) should fail!");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            numberPolymorphicVisitable.accept(integerPolymorphicVisitor);
            Assert.fail((String)"numberPolymorphicVisitable.accept(integerPolymorphicVisitor) should fail");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            doublePolymorphicVisitable.accept(integerPolymorphicVisitor);
            Assert.fail((String)"doublePolymorphicVisitable.accept(integerPolymorphicVisitor) should fail");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            integerPolymorphicVisitable.accept(doublePolymorphicVisitor);
            Assert.fail((String)"integerPolymorphicVisitable.accept(doublePolymorphicVisitor) should fail");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static class IntegerPolymorphicVisitor
    extends NumberPolymorphicVisitor {
        private final IntegerVisitor integerVisitor = new IntegerVisitor();

        private IntegerPolymorphicVisitor() {
        }

        @Override
        public <Number> Visitor<Number> visitor(Class<? extends Number> klass) {
            return klass == Integer.class ? this.integerVisitor : null;
        }

        private static class IntegerVisitor
        implements Visitor<Number> {
            private IntegerVisitor() {
            }

            @Override
            public void visit(Number o) {
                Integer obj = (Integer)o;
                QL.info("Integer :: " + obj);
            }
        }
    }

    private static class DoublePolymorphicVisitor
    extends NumberPolymorphicVisitor {
        private final DoubleVisitor doubleVisitor = new DoubleVisitor();

        private DoublePolymorphicVisitor() {
        }

        @Override
        public <Number> Visitor<Number> visitor(Class<? extends Number> klass) {
            return klass == Double.class ? this.doubleVisitor : null;
        }

        private static class DoubleVisitor
        implements Visitor<Number> {
            private DoubleVisitor() {
            }

            @Override
            public void visit(Number o) {
                double obj = (Double)o;
                QL.info("Double :: " + obj);
            }
        }
    }

    private static class NumberPolymorphicVisitor
    implements PolymorphicVisitor {
        private final NumberVisitor numberVisitor = new NumberVisitor();

        private NumberPolymorphicVisitor() {
        }

        public <Number> Visitor<Number> visitor(Class<? extends Number> klass) {
            return klass == Number.class ? this.numberVisitor : null;
        }

        private static class NumberVisitor
        implements Visitor<Number> {
            private NumberVisitor() {
            }

            @Override
            public void visit(Number o) {
                QL.info("Number :: " + o);
            }
        }
    }

    private class IntegerPolymorphicVisitable
    extends NumberPolymorphicVisitable {
        private final int data = 3456;

        private IntegerPolymorphicVisitable() {
            this.data = 3456;
        }

        @Override
        public void accept(PolymorphicVisitor pv) {
            Visitor<Integer> v;
            Visitor<Integer> visitor = v = pv != null ? pv.visitor(Integer.class) : null;
            if (v != null) {
                v.visit(3456);
            } else {
                super.accept(pv);
            }
        }
    }

    private class DoublePolymorphicVisitable
    extends NumberPolymorphicVisitable {
        private final double data = 5.6;

        private DoublePolymorphicVisitable() {
            this.data = 5.6;
        }

        @Override
        public void accept(PolymorphicVisitor pv) {
            Visitor<Double> v;
            Visitor<Double> visitor = v = pv != null ? pv.visitor(Double.class) : null;
            if (v != null) {
                v.visit(5.6);
            } else {
                super.accept(pv);
            }
        }
    }

    private class NumberPolymorphicVisitable
    implements PolymorphicVisitable {
        private NumberPolymorphicVisitable() {
        }

        @Override
        public void accept(PolymorphicVisitor pv) {
            Visitor<Number> v;
            Visitor<Number> visitor = v = pv != null ? pv.visitor(Number.class) : null;
            if (v == null) {
                throw new IllegalArgumentException("not a Number visitor");
            }
            v.visit(1.0);
        }
    }
}

