/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.testsuite.methods.lattices;

import java.util.HashMap;
import java.util.Map;
import org.jquantlib.QL;
import org.jquantlib.daycounters.Actual360;
import org.jquantlib.daycounters.DayCounter;
import org.jquantlib.exercise.EuropeanExercise;
import org.jquantlib.exercise.Exercise;
import org.jquantlib.experimental.lattices.ExtendedAdditiveEQPBinomialTree;
import org.jquantlib.experimental.lattices.ExtendedCoxRossRubinstein;
import org.jquantlib.experimental.lattices.ExtendedJarrowRudd;
import org.jquantlib.experimental.lattices.ExtendedJoshi4;
import org.jquantlib.experimental.lattices.ExtendedLeisenReimer;
import org.jquantlib.experimental.lattices.ExtendedTian;
import org.jquantlib.experimental.lattices.ExtendedTrigeorgis;
import org.jquantlib.instruments.EuropeanOption;
import org.jquantlib.instruments.OneAssetOption;
import org.jquantlib.instruments.Option;
import org.jquantlib.instruments.PlainVanillaPayoff;
import org.jquantlib.instruments.StrikedTypePayoff;
import org.jquantlib.instruments.VanillaOption;
import org.jquantlib.pricingengines.AnalyticEuropeanEngine;
import org.jquantlib.pricingengines.vanilla.BinomialVanillaEngine;
import org.jquantlib.processes.BlackScholesMertonProcess;
import org.jquantlib.processes.GeneralizedBlackScholesProcess;
import org.jquantlib.quotes.Handle;
import org.jquantlib.quotes.Quote;
import org.jquantlib.quotes.SimpleQuote;
import org.jquantlib.termstructures.BlackVolTermStructure;
import org.jquantlib.termstructures.YieldTermStructure;
import org.jquantlib.testsuite.util.Utilities;
import org.jquantlib.time.Date;
import org.junit.Test;

public class ExtendedTrees {
    public ExtendedTrees() {
        QL.info("::::: " + this.getClass().getSimpleName() + " :::::");
    }

    @Test
    public void testJRBinomialEngines() {
        QL.info("Testing time-dependent JR binomial European engines against analytic results...");
        EngineType engine = EngineType.JR;
        int steps = 251;
        int samples = Integer.MAX_VALUE;
        HashMap<String, Double> relativeTol = new HashMap<String, Double>();
        relativeTol.put("value", 0.002);
        relativeTol.put("delta", 0.001);
        relativeTol.put("gamma", 1.0E-4);
        relativeTol.put("theta", 0.03);
        this.testEngineConsistency(engine, 251, Integer.MAX_VALUE, relativeTol);
    }

    @Test
    public void testCRRBinomialEngines() {
        QL.info("Testing time-dependent CRR binomial European engines against analytic results...");
        EngineType engine = EngineType.CRR;
        int steps = 501;
        int samples = Integer.MAX_VALUE;
        HashMap<String, Double> relativeTol = new HashMap<String, Double>();
        relativeTol.put("value", 0.02);
        relativeTol.put("delta", 0.001);
        relativeTol.put("gamma", 1.0E-4);
        relativeTol.put("theta", 0.03);
        this.testEngineConsistency(engine, 501, Integer.MAX_VALUE, relativeTol);
    }

    @Test
    public void testEQPBinomialEngines() {
        QL.info("Testing time-dependent EQP binomial European engines against analytic results...");
        EngineType engine = EngineType.EQP;
        int steps = 501;
        int samples = Integer.MAX_VALUE;
        HashMap<String, Double> relativeTol = new HashMap<String, Double>();
        relativeTol.put("value", 0.02);
        relativeTol.put("delta", 0.001);
        relativeTol.put("gamma", 1.0E-4);
        relativeTol.put("theta", 0.03);
        this.testEngineConsistency(engine, 501, Integer.MAX_VALUE, relativeTol);
    }

    @Test
    public void testTGEOBinomialEngines() {
        QL.info("Testing time-dependent TGEO binomial European engines against analytic results...");
        EngineType engine = EngineType.TGEO;
        int steps = 251;
        int samples = Integer.MAX_VALUE;
        HashMap<String, Double> relativeTol = new HashMap<String, Double>();
        relativeTol.put("value", 0.002);
        relativeTol.put("delta", 0.001);
        relativeTol.put("gamma", 1.0E-4);
        relativeTol.put("theta", 0.03);
        this.testEngineConsistency(engine, 251, Integer.MAX_VALUE, relativeTol);
    }

    @Test
    public void testTIANBinomialEngines() {
        QL.info("Testing time-dependent TIAN binomial European engines against analytic results...");
        EngineType engine = EngineType.TIAN;
        int steps = 251;
        int samples = Integer.MAX_VALUE;
        HashMap<String, Double> relativeTol = new HashMap<String, Double>();
        relativeTol.put("value", 0.002);
        relativeTol.put("delta", 0.001);
        relativeTol.put("gamma", 1.0E-4);
        relativeTol.put("theta", 0.03);
        this.testEngineConsistency(engine, 251, Integer.MAX_VALUE, relativeTol);
    }

    @Test
    public void testLRBinomialEngines() {
        QL.info("Testing time-dependent LR binomial European engines against analytic results...");
        EngineType engine = EngineType.LR;
        int steps = 251;
        int samples = Integer.MAX_VALUE;
        HashMap<String, Double> relativeTol = new HashMap<String, Double>();
        relativeTol.put("value", 1.0E-6);
        relativeTol.put("delta", 0.001);
        relativeTol.put("gamma", 1.0E-4);
        relativeTol.put("theta", 0.03);
        this.testEngineConsistency(engine, 251, Integer.MAX_VALUE, relativeTol);
    }

    @Test
    public void testJOSHIBinomialEngines() {
        QL.info("Testing time-dependent Joshi binomial European engines against analytic results...");
        EngineType engine = EngineType.JOSHI;
        int steps = 251;
        int samples = Integer.MAX_VALUE;
        HashMap<String, Double> relativeTol = new HashMap<String, Double>();
        relativeTol.put("value", 1.0E-7);
        relativeTol.put("delta", 0.001);
        relativeTol.put("gamma", 1.0E-4);
        relativeTol.put("theta", 0.03);
        this.testEngineConsistency(engine, 251, Integer.MAX_VALUE, relativeTol);
    }

    private void testEngineConsistency(EngineType engine, int binomialSteps, int samples, Map<String, Double> tolerance) {
        HashMap<String, Double> calculated = new HashMap<String, Double>();
        HashMap<String, Double> expected = new HashMap<String, Double>();
        Option.Type[] types = new Option.Type[]{Option.Type.Call, Option.Type.Put};
        double[] strikes = new double[]{75.0, 100.0, 125.0};
        int[] lengths = new int[]{1};
        double[] underlyings = new double[]{100.0};
        double[] qRates = new double[]{0.0, 0.05};
        double[] rRates = new double[]{0.01, 0.05, 0.15};
        double[] vols = new double[]{0.11, 0.5, 1.2};
        Actual360 dc = new Actual360();
        Date today = Date.todaysDate();
        SimpleQuote spot = new SimpleQuote(0.0);
        SimpleQuote vol = new SimpleQuote(0.0);
        BlackVolTermStructure volTS = Utilities.flatVol(today, vol, (DayCounter)dc);
        SimpleQuote qRate = new SimpleQuote(0.0);
        YieldTermStructure qTS = Utilities.flatRate(today, qRate, (DayCounter)dc);
        SimpleQuote rRate = new SimpleQuote(0.0);
        YieldTermStructure rTS = Utilities.flatRate(today, rRate, (DayCounter)dc);
        for (Option.Type type : types) {
            for (double strike : strikes) {
                for (int length : lengths) {
                    Date exDate = today.add(length * 360);
                    EuropeanExercise exercise = new EuropeanExercise(exDate);
                    PlainVanillaPayoff payoff = new PlainVanillaPayoff(type, strike);
                    VanillaOption refOption = this.makeOption(payoff, exercise, spot, qTS, rTS, volTS, EngineType.Analytic, Integer.MAX_VALUE, Integer.MAX_VALUE);
                    VanillaOption option = this.makeOption(payoff, exercise, spot, qTS, rTS, volTS, engine, binomialSteps, samples);
                    for (double u : underlyings) {
                        for (double q : qRates) {
                            for (double r : rRates) {
                                for (double v : vols) {
                                    spot.setValue(u);
                                    qRate.setValue(q);
                                    rRate.setValue(r);
                                    vol.setValue(v);
                                    expected.clear();
                                    calculated.clear();
                                    expected.put("value", refOption.NPV());
                                    calculated.put("value", option.NPV());
                                    if (option.NPV() > spot.value() * 1.0E-5) {
                                        expected.put("delta", refOption.delta());
                                        expected.put("gamma", refOption.gamma());
                                        expected.put("theta", refOption.theta());
                                        calculated.put("delta", option.delta());
                                        calculated.put("gamma", option.gamma());
                                        calculated.put("theta", option.theta());
                                    }
                                    for (Map.Entry it : calculated.entrySet()) {
                                        String greek = (String)it.getKey();
                                        double expct = (Double)expected.get(greek);
                                        double calcl = (Double)it.getValue();
                                        double tol = tolerance.get(greek);
                                        double error = Utilities.relativeError(expct, calcl, u);
                                        if (!(error > tol)) continue;
                                        this.REPORT_FAILURE(greek, payoff, exercise, u, q, r, today, v, expct, calcl, error, tol);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    private GeneralizedBlackScholesProcess makeProcess(Quote u, YieldTermStructure q, YieldTermStructure r, BlackVolTermStructure vol) {
        return new BlackScholesMertonProcess(new Handle<Quote>(u), new Handle<YieldTermStructure>(q), new Handle<YieldTermStructure>(r), new Handle<BlackVolTermStructure>(vol));
    }

    private VanillaOption makeOption(StrikedTypePayoff payoff, Exercise exercise, Quote u, YieldTermStructure q, YieldTermStructure r, BlackVolTermStructure vol, EngineType engineType, int binomialSteps, int samples) {
        OneAssetOption.EngineImpl engine;
        GeneralizedBlackScholesProcess stochProcess = this.makeProcess(u, q, r, vol);
        switch (engineType) {
            case Analytic: {
                engine = new AnalyticEuropeanEngine(stochProcess);
                break;
            }
            case JR: {
                engine = new BinomialVanillaEngine(ExtendedJarrowRudd.class, stochProcess, binomialSteps);
                break;
            }
            case CRR: {
                engine = new BinomialVanillaEngine(ExtendedCoxRossRubinstein.class, stochProcess, binomialSteps);
                break;
            }
            case EQP: {
                engine = new BinomialVanillaEngine(ExtendedAdditiveEQPBinomialTree.class, stochProcess, binomialSteps);
                break;
            }
            case TGEO: {
                engine = new BinomialVanillaEngine(ExtendedTrigeorgis.class, stochProcess, binomialSteps);
                break;
            }
            case TIAN: {
                engine = new BinomialVanillaEngine(ExtendedTian.class, stochProcess, binomialSteps);
                break;
            }
            case LR: {
                engine = new BinomialVanillaEngine(ExtendedLeisenReimer.class, stochProcess, binomialSteps);
                break;
            }
            case JOSHI: {
                engine = new BinomialVanillaEngine(ExtendedJoshi4.class, stochProcess, binomialSteps);
                break;
            }
            default: {
                throw new IllegalStateException("unknown engine type");
            }
        }
        EuropeanOption option = new EuropeanOption(payoff, exercise);
        option.setPricingEngine(engine);
        return option;
    }

    private String engineTypeToString(EngineType type) {
        switch (type) {
            case Analytic: {
                return "analytic";
            }
            case JR: {
                return "Jarrow-Rudd";
            }
            case CRR: {
                return "Cox-Ross-Rubinstein";
            }
            case EQP: {
                return "EQP";
            }
            case TGEO: {
                return "Trigeorgis";
            }
            case TIAN: {
                return "Tian";
            }
            case LR: {
                return "LeisenReimer";
            }
            case JOSHI: {
                return "Joshi";
            }
        }
        throw new IllegalStateException("unknown engine type");
    }

    private void REPORT_FAILURE(String greekName, StrikedTypePayoff payoff, Exercise exercise, double s, double q, double r, Date today, double v, double expected, double calculated, double error, double tolerance) {
        StringBuilder sb = new StringBuilder();
        sb.append(exercise).append(" ");
        sb.append((Object)payoff.optionType()).append(" option with ");
        sb.append(payoff).append(" payoff:\n");
        sb.append("    spot value:       ").append(s).append("\n");
        sb.append("    strike:           ").append(payoff.strike()).append("\n");
        sb.append("    dividend yield:   ").append(q).append("\n");
        sb.append("    risk-free rate:   ").append(r).append("\n");
        sb.append("    reference date:   ").append(today).append("\n");
        sb.append("    maturity:         ").append(exercise.lastDate()).append("\n");
        sb.append("    volatility:       ").append(v).append("\n\n");
        sb.append("    expected ").append(greekName).append(":   ").append(expected).append("\n");
        sb.append("    calculated ").append(greekName).append(": ").append(calculated).append("\n");
        sb.append("    error:            ").append(error).append("\n");
        sb.append("    tolerance:        ").append(tolerance);
    }

    private static enum EngineType {
        Analytic,
        JR,
        CRR,
        EQP,
        TGEO,
        TIAN,
        LR,
        JOSHI;

    }
}

