/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.testsuite.math.interpolations;

import org.jquantlib.QL;
import org.jquantlib.math.interpolations.Interpolation;
import org.jquantlib.math.interpolations.factories.Linear;
import org.jquantlib.math.matrixutilities.Array;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class LinearInterpolationTest {
    private static final Array x = new Array(new double[]{0.0, 1.0, 2.0, 3.0, 4.0});
    private static final Array y = new Array(new double[]{5.0, 4.0, 3.0, 2.0, 1.0});
    private static final Array x2 = new Array(new double[]{-2.0, -1.0, 0.0, 1.0, 3.0, 4.0, 5.0, 6.0, 7.0});
    private static double[] y2;
    private static Interpolation interpolation;
    private static int length;
    private static double tolerance;

    public LinearInterpolationTest() {
        QL.info("::::: " + this.getClass().getSimpleName() + " :::::");
    }

    @BeforeClass
    public static void setUpLinearInterpolation() {
        QL.info("::::: Testing use of interpolations as functors... :::::");
        interpolation = new Linear().interpolate(x, y);
        interpolation.update();
        length = x2.size();
        y2 = new double[length];
        tolerance = 1.0E-12;
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldThrowIllegalArgumentExceptionWithoutEnableExtrapolation() {
        for (int i = 0; i < length; ++i) {
            LinearInterpolationTest.y2[i] = interpolation.op(x2.get(i));
        }
    }

    @Test
    public void testEnableExtrapolation() {
        int i;
        interpolation.enableExtrapolation();
        for (i = 0; i < length; ++i) {
            LinearInterpolationTest.y2[i] = interpolation.op(x2.get(i));
        }
        for (i = 0; i < length; ++i) {
            double expected = 5.0 - x2.get(i);
            if (!(Math.abs(y2[i] - expected) > tolerance)) continue;
            StringBuilder sb = new StringBuilder();
            sb.append("failed to reproduce ").append(i + 1).append("o. expected datum");
            sb.append("\n    expected:   ").append(expected);
            sb.append("\n    calculated: ").append(y2[i]);
            sb.append("\n    error:      ").append(Math.abs(y2[i] - expected));
            if (!(Math.abs(y2[i] - expected) > tolerance)) continue;
            Assert.fail((String)sb.toString());
        }
    }
}

