/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.testsuite.math.distributions;

import org.jquantlib.QL;
import org.jquantlib.math.distributions.GammaDistribution;
import org.junit.Assert;
import org.junit.Test;

public class GammaDistributionTest {
    public GammaDistributionTest() {
        QL.info("::::: " + this.getClass().getSimpleName() + " :::::");
    }

    @Test
    public void testGammaDisribution() {
        double[][] testvalues = new double[][]{{1.0, 0.6321205487807914}, {2.0, 0.1353352832366127}, {3.0, 0.04978706836786395}, {4.0, 0.018315638888734182}, {5.0, 0.006737946999085468}, {6.0, 0.002478752176666357}, {7.0, 9.118819655545164E-4}, {8.0, 3.354626279025119E-4}, {9.0, 1.2340980408667962E-4}, {10.0, 4.539992976248486E-5}, {11.0, 1.6701700790245663E-5}, {12.0, 6.144212353328207E-6}, {13.0, 2.2603294069810534E-6}, {14.0, 8.315287191035681E-7}, {15.0, 3.0590232050182594E-7}};
        double[][] testvalues2 = new double[][]{{1.0, 0.9758726484126121}, {2.0, 0.005673823979811235}, {3.0, 0.001565271747114275}, {4.0, 4.6461128723220273E-4}, {5.0, 1.439389658467268E-4}, {6.0, 4.587266119320674E-5}, {7.0, 1.4917168148427797E-5}, {8.0, 4.924807948019276E-6}, {9.0, 1.645169609700308E-6}, {10.0, 5.547985717901634E-7}, {11.0, 1.8854922924246192E-7}, {12.0, 6.449477029349438E-8}, {13.0, 2.2182342798583913E-8}, {14.0, 7.665444025768806E-9}, {15.0, 2.659774281674882E-9}};
        double a = 1.0;
        GammaDistribution gammDistribution = new GammaDistribution(a);
        for (double[] testvalue : testvalues) {
            double expected = testvalue[1];
            double x = testvalue[0];
            double computed = gammDistribution.op(x);
            double tolerance = 1.0E-15;
            if (!(Math.abs(expected - computed) > 1.0E-15)) continue;
            Assert.fail((String)("x: " + x + " expected: " + expected + " realised: " + computed));
        }
        a = 0.1;
        GammaDistribution gammDist = new GammaDistribution(a);
        for (double[] element : testvalues2) {
            double expected = element[1];
            double x = element[0];
            double computed = gammDist.op(x);
            double tolerance = 1.0E-15;
            if (!(Math.abs(expected - computed) > 1.0E-15)) continue;
            Assert.fail((String)("x: " + x + " expected: " + expected + " realised: " + computed));
        }
    }
}

