/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.testsuite.math.distributions;

import org.jquantlib.QL;
import org.jquantlib.math.distributions.CumulativeNormalDistribution;
import org.junit.Assert;
import org.junit.Test;

public class CumulativeNormalDistributionTest {
    public CumulativeNormalDistributionTest() {
        QL.info("::::: " + this.getClass().getSimpleName() + " :::::");
    }

    @Test
    public void testKnownGoodValuesFromAbramStegun() {
        double[][] testvalues = new double[][]{{0.0, 0.5}, {0.1, 0.539827837277029}, {0.2, 0.579259709439103}, {0.3, 0.617911422188953}, {0.4, 0.655421741610324}, {0.5, 0.691462461274013}, {0.6, 0.725746882249927}, {0.7, 0.758036347776927}, {0.8, 0.788144601416604}, {0.9, 0.815939874653241}, {1.0, 0.841344746068543}, {1.2, 0.884930329778292}, {1.4, 0.919243340766229}, {1.6, 0.945200708300442}, {1.8, 0.964069680887074}, {2.0, 0.977249868051821}, {2.5, 0.993790334674224}, {3.0, 0.99865010196837}, {3.5, 0.9997673709}, {4.0, 0.9999683288}, {5.0, 0.9999997133}};
        CumulativeNormalDistribution cnd = new CumulativeNormalDistribution();
        for (double[] testvalue : testvalues) {
            double tolerance;
            double z = testvalue[0];
            double expected = testvalue[1];
            double computed = cnd.op(z);
            double d = tolerance = Math.abs(z) < 3.01 ? 1.0E-15 : 1.0E-10;
            if (expected - computed > tolerance) {
                Assert.fail((String)("expected:  + " + expected + " but was " + computed));
            }
            if (!(Math.abs(1.0 - (computed + cnd.op(-z))) > tolerance)) continue;
            Assert.fail((String)("expected: 1.0 but is: " + computed + cnd.op(-z)));
        }
    }

    @Test
    public void testExtremes() {
        double z = -40.0;
        double tolerance = 1.0E-15;
        CumulativeNormalDistribution cnd = new CumulativeNormalDistribution();
        if (Math.abs(0.0 - cnd.op(z)) > 1.0E-15) {
            Assert.fail((String)("expected: 1.0 but is: " + cnd.op(z)));
        }
        if (Math.abs(0.0 - cnd.op(z = -10.0)) > 1.0E-15) {
            Assert.fail((String)("expected: 1.0 but is: " + cnd.op(z)));
        }
        if (Math.abs(1.0 - cnd.op(z = 10.0)) > 1.0E-15) {
            Assert.fail((String)("expected: 1.0 but is: " + cnd.op(z)));
        }
        if (Math.abs(1.0 - cnd.op(z = 40.0)) > 1.0E-15) {
            Assert.fail((String)("expected: 1.0 but is: " + cnd.op(z)));
        }
    }
}

