/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.testsuite.instruments;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.jquantlib.QL;
import org.jquantlib.Settings;
import org.jquantlib.daycounters.Actual360;
import org.jquantlib.daycounters.DayCounter;
import org.jquantlib.exercise.AmericanExercise;
import org.jquantlib.exercise.EuropeanExercise;
import org.jquantlib.exercise.Exercise;
import org.jquantlib.instruments.DividendVanillaOption;
import org.jquantlib.instruments.Option;
import org.jquantlib.instruments.PlainVanillaPayoff;
import org.jquantlib.instruments.StrikedTypePayoff;
import org.jquantlib.instruments.VanillaOption;
import org.jquantlib.lang.exceptions.LibraryException;
import org.jquantlib.pricingengines.AnalyticEuropeanEngine;
import org.jquantlib.pricingengines.PricingEngine;
import org.jquantlib.pricingengines.vanilla.AnalyticDividendEuropeanEngine;
import org.jquantlib.pricingengines.vanilla.finitedifferences.FDDividendAmericanEngine;
import org.jquantlib.pricingengines.vanilla.finitedifferences.FDDividendEuropeanEngine;
import org.jquantlib.pricingengines.vanilla.finitedifferences.FDEngineAdapter;
import org.jquantlib.processes.BlackScholesMertonProcess;
import org.jquantlib.processes.GeneralizedBlackScholesProcess;
import org.jquantlib.quotes.Handle;
import org.jquantlib.quotes.SimpleQuote;
import org.jquantlib.termstructures.BlackVolTermStructure;
import org.jquantlib.termstructures.YieldTermStructure;
import org.jquantlib.testsuite.util.Utilities;
import org.jquantlib.time.Date;
import org.jquantlib.time.Month;
import org.jquantlib.time.Period;
import org.jquantlib.time.TimeUnit;
import org.junit.Assert;
import org.junit.Test;

public class DividendOptionTest {
    @Test
    public void testEuropeanValues() {
        QL.info("Testing dividend European option values with no dividends...");
        double tolerance = 1.0E-5;
        Option.Type[] types = new Option.Type[]{Option.Type.Call, Option.Type.Put};
        double[] strikes = new double[]{50.0, 99.5, 100.0, 100.5, 150.0};
        double[] underlyings = new double[]{100.0};
        double[] qRates = new double[]{0.0, 0.1, 0.3};
        double[] rRates = new double[]{0.01, 0.05, 0.15};
        int[] lengths = new int[]{1, 2};
        double[] vols = new double[]{0.05, 0.2, 0.7};
        Actual360 dc = new Actual360();
        Date today = Date.todaysDate();
        new Settings().setEvaluationDate(today);
        SimpleQuote spot = new SimpleQuote(0.0);
        SimpleQuote qRate = new SimpleQuote(0.0);
        Handle<YieldTermStructure> qTS = new Handle<YieldTermStructure>(Utilities.flatRate(qRate, (DayCounter)dc));
        SimpleQuote rRate = new SimpleQuote(0.0);
        Handle<YieldTermStructure> rTS = new Handle<YieldTermStructure>(Utilities.flatRate(rRate, (DayCounter)dc));
        SimpleQuote vol = new SimpleQuote(0.0);
        Handle<BlackVolTermStructure> volTS = new Handle<BlackVolTermStructure>(Utilities.flatVol(vol, (DayCounter)dc));
        for (Option.Type type : types) {
            for (double strike : strikes) {
                for (int length : lengths) {
                    Date exDate = today.add(new Period(length, TimeUnit.Years));
                    EuropeanExercise exercise = new EuropeanExercise(exDate);
                    ArrayList<Date> dividendDates = new ArrayList<Date>();
                    ArrayList<Double> dividends = new ArrayList<Double>();
                    Date d = today.add(new Period(3, TimeUnit.Months));
                    while (d.lt(exercise.lastDate())) {
                        dividendDates.add(d.clone());
                        dividends.add(0.0);
                        d.addAssign(new Period(6, TimeUnit.Months));
                    }
                    PlainVanillaPayoff payoff = new PlainVanillaPayoff(type, strike);
                    BlackScholesMertonProcess stochProcess = new BlackScholesMertonProcess(new Handle<SimpleQuote>(spot), qTS, rTS, volTS);
                    AnalyticEuropeanEngine ref_engine = new AnalyticEuropeanEngine(stochProcess);
                    AnalyticDividendEuropeanEngine engine = new AnalyticDividendEuropeanEngine(stochProcess);
                    DividendVanillaOption option = new DividendVanillaOption(payoff, exercise, dividendDates, dividends);
                    option.setPricingEngine(engine);
                    VanillaOption ref_option = new VanillaOption(payoff, exercise);
                    ref_option.setPricingEngine(ref_engine);
                    for (double u : underlyings) {
                        for (double q : qRates) {
                            for (double r : rRates) {
                                for (double v : vols) {
                                    spot.setValue(u);
                                    qRate.setValue(q);
                                    rRate.setValue(r);
                                    vol.setValue(v);
                                    double calculated = option.NPV();
                                    double expected = ref_option.NPV();
                                    double error = Math.abs(calculated - expected);
                                    if (!(error > 1.0E-5)) continue;
                                    this.REPORT_FAILURE("value start limit", payoff, exercise, u, q, r, today, v, expected, calculated, error, 1.0E-5);
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Test
    public void testEuropeanKnownValue() {
        QL.info("Testing dividend European option values with known value...");
        double tolerance = 0.01;
        double expected = 3.67;
        Actual360 dc = new Actual360();
        Date today = Date.todaysDate();
        new Settings().setEvaluationDate(today);
        SimpleQuote spot = new SimpleQuote(0.0);
        SimpleQuote qRate = new SimpleQuote(0.0);
        Handle<YieldTermStructure> qTS = new Handle<YieldTermStructure>(Utilities.flatRate(qRate, (DayCounter)dc));
        SimpleQuote rRate = new SimpleQuote(0.0);
        Handle<YieldTermStructure> rTS = new Handle<YieldTermStructure>(Utilities.flatRate(rRate, (DayCounter)dc));
        SimpleQuote vol = new SimpleQuote(0.0);
        Handle<BlackVolTermStructure> volTS = new Handle<BlackVolTermStructure>(Utilities.flatVol(vol, (DayCounter)dc));
        Date exDate = today.add(new Period(6, TimeUnit.Months));
        EuropeanExercise exercise = new EuropeanExercise(exDate);
        ArrayList<Date> dividendDates = new ArrayList<Date>();
        ArrayList<Double> dividends = new ArrayList<Double>();
        dividendDates.add(today.add(new Period(2, TimeUnit.Months)));
        dividends.add(0.5);
        dividendDates.add(today.add(new Period(5, TimeUnit.Months)));
        dividends.add(0.5);
        PlainVanillaPayoff payoff = new PlainVanillaPayoff(Option.Type.Call, 40.0);
        BlackScholesMertonProcess stochProcess = new BlackScholesMertonProcess(new Handle<SimpleQuote>(spot), qTS, rTS, volTS);
        AnalyticDividendEuropeanEngine engine = new AnalyticDividendEuropeanEngine(stochProcess);
        DividendVanillaOption option = new DividendVanillaOption(payoff, exercise, dividendDates, dividends);
        option.setPricingEngine(engine);
        double u = 40.0;
        double q = 0.0;
        double r = 0.09;
        double v = 0.3;
        spot.setValue(40.0);
        qRate.setValue(0.0);
        rRate.setValue(0.09);
        vol.setValue(0.3);
        double calculated = option.NPV();
        double error = Math.abs(calculated - 3.67);
        if (error > 0.01) {
            this.REPORT_FAILURE("value start limit", payoff, exercise, 40.0, 0.0, 0.09, today, 0.3, 3.67, calculated, error, 0.01);
        }
    }

    @Test
    public void testEuropeanStartLimit() {
        QL.info("Testing dividend European option with a dividend on today's date...");
        double tolerance = 1.0E-5;
        double dividendValue = 10.0;
        Option.Type[] types = new Option.Type[]{Option.Type.Call, Option.Type.Put};
        double[] strikes = new double[]{50.0, 99.5, 100.0, 100.5, 150.0};
        double[] underlyings = new double[]{100.0};
        double[] qRates = new double[]{0.0, 0.1, 0.3};
        double[] rRates = new double[]{0.01, 0.05, 0.15};
        int[] lengths = new int[]{1, 2};
        double[] vols = new double[]{0.05, 0.2, 0.7};
        Actual360 dc = new Actual360();
        Date today = Date.todaysDate();
        new Settings().setEvaluationDate(today);
        SimpleQuote spot = new SimpleQuote(0.0);
        SimpleQuote qRate = new SimpleQuote(0.0);
        Handle<YieldTermStructure> qTS = new Handle<YieldTermStructure>(Utilities.flatRate(qRate, (DayCounter)dc));
        SimpleQuote rRate = new SimpleQuote(0.0);
        Handle<YieldTermStructure> rTS = new Handle<YieldTermStructure>(Utilities.flatRate(rRate, (DayCounter)dc));
        SimpleQuote vol = new SimpleQuote(0.0);
        Handle<BlackVolTermStructure> volTS = new Handle<BlackVolTermStructure>(Utilities.flatVol(vol, (DayCounter)dc));
        for (Option.Type type : types) {
            for (double strike : strikes) {
                for (int length : lengths) {
                    Date exDate = today.add(new Period(length, TimeUnit.Months));
                    EuropeanExercise exercise = new EuropeanExercise(exDate);
                    ArrayList<Date> dividendDates = new ArrayList<Date>();
                    ArrayList<Double> dividends = new ArrayList<Double>();
                    dividendDates.add(today);
                    dividends.add(10.0);
                    PlainVanillaPayoff payoff = new PlainVanillaPayoff(type, strike);
                    BlackScholesMertonProcess stochProcess = new BlackScholesMertonProcess(new Handle<SimpleQuote>(spot), qTS, rTS, volTS);
                    AnalyticDividendEuropeanEngine engine = new AnalyticDividendEuropeanEngine(stochProcess);
                    AnalyticEuropeanEngine ref_engine = new AnalyticEuropeanEngine(stochProcess);
                    DividendVanillaOption option = new DividendVanillaOption(payoff, exercise, dividendDates, dividends);
                    option.setPricingEngine(engine);
                    VanillaOption ref_option = new VanillaOption(payoff, exercise);
                    ref_option.setPricingEngine(ref_engine);
                    for (double u : underlyings) {
                        for (double q : qRates) {
                            for (double r : rRates) {
                                for (double v : vols) {
                                    spot.setValue(u);
                                    qRate.setValue(q);
                                    rRate.setValue(r);
                                    vol.setValue(v);
                                    double calculated = option.NPV();
                                    spot.setValue(u - 10.0);
                                    double expected = ref_option.NPV();
                                    double error = Math.abs(calculated - expected);
                                    if (!(error > 1.0E-5)) continue;
                                    this.REPORT_FAILURE("value", payoff, exercise, u, q, r, today, v, expected, calculated, error, 1.0E-5);
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Test
    public void testEuropeanEndLimit() {
        QL.info("Testing dividend European option values with end limits...");
        double tolerance = 1.0E-5;
        double dividendValue = 10.0;
        Option.Type[] types = new Option.Type[]{Option.Type.Call, Option.Type.Put};
        double[] strikes = new double[]{50.0, 99.5, 100.0, 100.5, 150.0};
        double[] underlyings = new double[]{100.0};
        double[] qRates = new double[]{0.0, 0.1, 0.3};
        double[] rRates = new double[]{0.01, 0.05, 0.15};
        int[] lengths = new int[]{1, 2};
        double[] vols = new double[]{0.05, 0.2, 0.7};
        Actual360 dc = new Actual360();
        Date today = Date.todaysDate();
        new Settings().setEvaluationDate(today);
        SimpleQuote spot = new SimpleQuote(0.0);
        SimpleQuote qRate = new SimpleQuote(0.0);
        Handle<YieldTermStructure> qTS = new Handle<YieldTermStructure>(Utilities.flatRate(qRate, (DayCounter)dc));
        SimpleQuote rRate = new SimpleQuote(0.0);
        Handle<YieldTermStructure> rTS = new Handle<YieldTermStructure>(Utilities.flatRate(rRate, (DayCounter)dc));
        SimpleQuote vol = new SimpleQuote(0.0);
        Handle<BlackVolTermStructure> volTS = new Handle<BlackVolTermStructure>(Utilities.flatVol(vol, (DayCounter)dc));
        for (Option.Type type : types) {
            for (double strike : strikes) {
                for (int length : lengths) {
                    Date exDate = today.add(new Period(length, TimeUnit.Years));
                    EuropeanExercise exercise = new EuropeanExercise(exDate);
                    ArrayList<Date> dividendDates = new ArrayList<Date>();
                    ArrayList<Double> dividends = new ArrayList<Double>();
                    dividendDates.add(exercise.lastDate());
                    dividends.add(10.0);
                    PlainVanillaPayoff payoff = new PlainVanillaPayoff(type, strike);
                    PlainVanillaPayoff refPayoff = new PlainVanillaPayoff(type, strike + 10.0);
                    BlackScholesMertonProcess stochProcess = new BlackScholesMertonProcess(new Handle<SimpleQuote>(spot), qTS, rTS, volTS);
                    AnalyticDividendEuropeanEngine engine = new AnalyticDividendEuropeanEngine(stochProcess);
                    AnalyticEuropeanEngine ref_engine = new AnalyticEuropeanEngine(stochProcess);
                    DividendVanillaOption option = new DividendVanillaOption(payoff, exercise, dividendDates, dividends);
                    option.setPricingEngine(engine);
                    VanillaOption ref_option = new VanillaOption(refPayoff, exercise);
                    ref_option.setPricingEngine(ref_engine);
                    for (double u : underlyings) {
                        for (double q : qRates) {
                            for (double r : rRates) {
                                for (double v : vols) {
                                    spot.setValue(u);
                                    qRate.setValue(q);
                                    rRate.setValue(r);
                                    vol.setValue(v);
                                    double calculated = option.NPV();
                                    double expected = ref_option.NPV();
                                    double error = Math.abs(calculated - expected);
                                    if (!(error > 1.0E-5)) continue;
                                    this.REPORT_FAILURE("value", payoff, exercise, u, q, r, today, v, expected, calculated, error, 1.0E-5);
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Test
    public void testEuropeanGreeks() {
        QL.info("Testing dividend European option greeks...");
        HashMap<String, Double> calculated = new HashMap<String, Double>();
        HashMap<String, Double> expected = new HashMap<String, Double>();
        HashMap<String, Double> tolerance = new HashMap<String, Double>();
        tolerance.put("delta", 1.0E-5);
        tolerance.put("gamma", 1.0E-5);
        tolerance.put("theta", 1.0E-5);
        tolerance.put("rho", 1.0E-5);
        tolerance.put("vega", 1.0E-5);
        Option.Type[] types = new Option.Type[]{Option.Type.Call, Option.Type.Put};
        double[] strikes = new double[]{50.0, 99.5, 100.0, 100.5, 150.0};
        double[] underlyings = new double[]{100.0};
        double[] qRates = new double[]{0.0, 0.1, 0.3};
        double[] rRates = new double[]{0.01, 0.05, 0.15};
        int[] lengths = new int[]{1, 2};
        double[] vols = new double[]{0.05, 0.2, 0.4};
        Actual360 dc = new Actual360();
        Date today = Date.todaysDate();
        new Settings().setEvaluationDate(today);
        SimpleQuote spot = new SimpleQuote(0.0);
        SimpleQuote qRate = new SimpleQuote(0.0);
        Handle<YieldTermStructure> qTS = new Handle<YieldTermStructure>(Utilities.flatRate(qRate, (DayCounter)dc));
        SimpleQuote rRate = new SimpleQuote(0.0);
        Handle<YieldTermStructure> rTS = new Handle<YieldTermStructure>(Utilities.flatRate(rRate, (DayCounter)dc));
        SimpleQuote vol = new SimpleQuote(0.0);
        Handle<BlackVolTermStructure> volTS = new Handle<BlackVolTermStructure>(Utilities.flatVol(vol, (DayCounter)dc));
        for (Option.Type type : types) {
            for (double strike : strikes) {
                for (int length : lengths) {
                    Date exDate = today.add(new Period(length, TimeUnit.Years));
                    EuropeanExercise exercise = new EuropeanExercise(exDate);
                    ArrayList<Date> dividendDates = new ArrayList<Date>();
                    ArrayList<Double> dividends = new ArrayList<Double>();
                    Date d = today.add(new Period(3, TimeUnit.Months));
                    while (d.lt(exercise.lastDate())) {
                        dividendDates.add(d.clone());
                        dividends.add(5.0);
                        d.addAssign(new Period(6, TimeUnit.Months));
                    }
                    PlainVanillaPayoff payoff = new PlainVanillaPayoff(type, strike);
                    BlackScholesMertonProcess stochProcess = new BlackScholesMertonProcess(new Handle<SimpleQuote>(spot), qTS, rTS, volTS);
                    AnalyticDividendEuropeanEngine engine = new AnalyticDividendEuropeanEngine(stochProcess);
                    DividendVanillaOption option = new DividendVanillaOption(payoff, exercise, dividendDates, dividends);
                    option.setPricingEngine(engine);
                    for (double u : underlyings) {
                        for (double q : qRates) {
                            for (double r : rRates) {
                                for (double v : vols) {
                                    spot.setValue(u);
                                    qRate.setValue(q);
                                    rRate.setValue(r);
                                    vol.setValue(v);
                                    double value = option.NPV();
                                    calculated.put("delta", option.delta());
                                    calculated.put("gamma", option.gamma());
                                    calculated.put("theta", option.theta());
                                    calculated.put("rho", option.rho());
                                    calculated.put("vega", option.vega());
                                    if (!(value > spot.value() * 1.0E-5)) continue;
                                    double du = u * 1.0E-4;
                                    spot.setValue(u + du);
                                    double value_p = option.NPV();
                                    double delta_p = option.delta();
                                    spot.setValue(u - du);
                                    double value_m = option.NPV();
                                    double delta_m = option.delta();
                                    spot.setValue(u);
                                    expected.put("delta", (value_p - value_m) / (2.0 * du));
                                    expected.put("gamma", (delta_p - delta_m) / (2.0 * du));
                                    double dr = r * 1.0E-4;
                                    rRate.setValue(r + dr);
                                    value_p = option.NPV();
                                    rRate.setValue(r - dr);
                                    value_m = option.NPV();
                                    rRate.setValue(r);
                                    expected.put("rho", (value_p - value_m) / (2.0 * dr));
                                    double dv = v * 1.0E-4;
                                    vol.setValue(v + dv);
                                    value_p = option.NPV();
                                    vol.setValue(v - dv);
                                    value_m = option.NPV();
                                    vol.setValue(v);
                                    expected.put("vega", (value_p - value_m) / (2.0 * dv));
                                    double dT = dc.yearFraction(today.sub(1), today.add(1));
                                    new Settings().setEvaluationDate(today.sub(1));
                                    value_m = option.NPV();
                                    new Settings().setEvaluationDate(today.add(1));
                                    value_p = option.NPV();
                                    new Settings().setEvaluationDate(today);
                                    expected.put("theta", (value_p - value_m) / dT);
                                    for (Map.Entry it : calculated.entrySet()) {
                                        String greek = (String)it.getKey();
                                        double expct = (Double)expected.get(greek);
                                        double calcl = (Double)it.getValue();
                                        double tol = (Double)tolerance.get(greek);
                                        double error = Utilities.relativeError(expct, calcl, u);
                                        if (!(error > tol)) continue;
                                        this.REPORT_FAILURE(greek, payoff, exercise, u, q, r, today, v, expct, calcl, error, tol);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Test
    public void testFdEuropeanValues() {
        QL.info("Testing finite-difference dividend European option values...");
        double tolerance = 0.01;
        int gridPoints = 300;
        int timeSteps = 40;
        Option.Type[] types = new Option.Type[]{Option.Type.Call, Option.Type.Put};
        double[] strikes = new double[]{50.0, 99.5, 100.0, 100.5, 150.0};
        double[] underlyings = new double[]{100.0};
        double[] qRates = new double[]{0.0};
        double[] rRates = new double[]{0.01, 0.05, 0.15};
        int[] lengths = new int[]{1, 2};
        double[] vols = new double[]{0.05, 0.2, 0.4};
        Actual360 dc = new Actual360();
        Date today = Date.todaysDate();
        new Settings().setEvaluationDate(today);
        SimpleQuote spot = new SimpleQuote(0.0);
        SimpleQuote qRate = new SimpleQuote(0.0);
        Handle<YieldTermStructure> qTS = new Handle<YieldTermStructure>(Utilities.flatRate(qRate, (DayCounter)dc));
        SimpleQuote rRate = new SimpleQuote(0.0);
        Handle<YieldTermStructure> rTS = new Handle<YieldTermStructure>(Utilities.flatRate(rRate, (DayCounter)dc));
        SimpleQuote vol = new SimpleQuote(0.0);
        Handle<BlackVolTermStructure> volTS = new Handle<BlackVolTermStructure>(Utilities.flatVol(vol, (DayCounter)dc));
        for (Option.Type type : types) {
            for (double strike : strikes) {
                for (int length : lengths) {
                    Date exDate = today.add(new Period(length, TimeUnit.Years));
                    EuropeanExercise exercise = new EuropeanExercise(exDate);
                    ArrayList<Date> dividendDates = new ArrayList<Date>();
                    ArrayList<Double> dividends = new ArrayList<Double>();
                    Date d = today.add(new Period(3, TimeUnit.Months));
                    while (d.lt(exercise.lastDate())) {
                        dividendDates.add(d.clone());
                        dividends.add(5.0);
                        d.addAssign(new Period(6, TimeUnit.Months));
                    }
                    PlainVanillaPayoff payoff = new PlainVanillaPayoff(type, strike);
                    BlackScholesMertonProcess stochProcess = new BlackScholesMertonProcess(new Handle<SimpleQuote>(spot), qTS, rTS, volTS);
                    FDDividendEuropeanEngine engine = new FDDividendEuropeanEngine(stochProcess, 40, 300);
                    AnalyticDividendEuropeanEngine ref_engine = new AnalyticDividendEuropeanEngine(stochProcess);
                    DividendVanillaOption option = new DividendVanillaOption(payoff, exercise, dividendDates, dividends);
                    option.setPricingEngine(engine);
                    DividendVanillaOption ref_option = new DividendVanillaOption(payoff, exercise, dividendDates, dividends);
                    ref_option.setPricingEngine(ref_engine);
                    for (double u : underlyings) {
                        for (double q : qRates) {
                            for (double r : rRates) {
                                for (double v : vols) {
                                    double expected;
                                    double error;
                                    spot.setValue(u);
                                    qRate.setValue(q);
                                    rRate.setValue(r);
                                    vol.setValue(v);
                                    double calculated = option.NPV();
                                    if (!(calculated > spot.value() * 1.0E-5) || !((error = Math.abs(calculated - (expected = ref_option.NPV()))) > 0.01)) continue;
                                    this.REPORT_FAILURE("value", payoff, exercise, u, q, r, today, v, expected, calculated, error, 0.01);
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Test
    public void testFdEuropeanGreeks() {
        int[] lengths;
        QL.info("Testing finite-differences dividend European option greeks...");
        Date today = Date.todaysDate();
        new Settings().setEvaluationDate(today);
        for (int length : lengths = new int[]{1, 2}) {
            Date exDate = today.add(new Period(length, TimeUnit.Years));
            EuropeanExercise exercise = new EuropeanExercise(exDate);
            this.testFdGreeks(FDDividendEuropeanEngine.class, today, exercise);
        }
    }

    @Test
    public void testFdAmericanGreeks() {
        int[] lengths;
        QL.info("Testing finite-differences dividend American option greeks...");
        Date today = Date.todaysDate();
        new Settings().setEvaluationDate(today);
        for (int length : lengths = new int[]{1, 2}) {
            Date exDate = today.add(new Period(length, TimeUnit.Years));
            AmericanExercise exercise = new AmericanExercise(today, exDate);
            this.testFdGreeks(FDDividendAmericanEngine.class, today, exercise);
        }
    }

    @Test
    public void testFdEuropeanDegenerate() {
        QL.info("Testing degenerate finite-differences dividend European option...");
        Date today = new Date(27, Month.February, 2005);
        new Settings().setEvaluationDate(today);
        Date exDate = new Date(13, Month.April, 2005);
        EuropeanExercise exercise = new EuropeanExercise(exDate);
        this.testFdDegenerate(FDDividendEuropeanEngine.class, today, exercise);
    }

    @Test
    public void testFdAmericanDegenerate() {
        QL.info("Testing degenerate finite-differences dividend American option...");
        Date today = new Date(27, Month.February, 2005);
        new Settings().setEvaluationDate(today);
        Date exDate = new Date(13, Month.April, 2005);
        AmericanExercise exercise = new AmericanExercise(today, exDate);
        this.testFdDegenerate(FDDividendAmericanEngine.class, today, exercise);
    }

    private <T extends FDEngineAdapter> void testFdGreeks(Class<T> engineClass, Date today, Exercise exercise) {
        HashMap<String, Double> calculated = new HashMap<String, Double>();
        HashMap<String, Double> expected = new HashMap<String, Double>();
        HashMap<String, Double> tolerance = new HashMap<String, Double>();
        tolerance.put("delta", 0.005);
        tolerance.put("gamma", 0.007);
        Option.Type[] types = new Option.Type[]{Option.Type.Call, Option.Type.Put};
        double[] strikes = new double[]{50.0, 99.5, 100.0, 100.5, 150.0};
        double[] underlyings = new double[]{100.0};
        double[] qRates = new double[]{0.0, 0.1, 0.2};
        double[] rRates = new double[]{0.01, 0.05, 0.15};
        double[] vols = new double[]{0.05, 0.2, 0.5};
        Actual360 dc = new Actual360();
        SimpleQuote spot = new SimpleQuote(0.0);
        SimpleQuote qRate = new SimpleQuote(0.0);
        Handle<YieldTermStructure> qTS = new Handle<YieldTermStructure>(Utilities.flatRate(qRate, (DayCounter)dc));
        SimpleQuote rRate = new SimpleQuote(0.0);
        Handle<YieldTermStructure> rTS = new Handle<YieldTermStructure>(Utilities.flatRate(rRate, (DayCounter)dc));
        SimpleQuote vol = new SimpleQuote(0.0);
        Handle<BlackVolTermStructure> volTS = new Handle<BlackVolTermStructure>(Utilities.flatVol(vol, (DayCounter)dc));
        for (Option.Type type : types) {
            for (double strike : strikes) {
                PricingEngine engine;
                ArrayList<Date> dividendDates = new ArrayList<Date>();
                ArrayList<Double> dividends = new ArrayList<Double>();
                Date d = today.add(new Period(3, TimeUnit.Months));
                while (d.lt(exercise.lastDate())) {
                    dividendDates.add(d.clone());
                    dividends.add(5.0);
                    d.addAssign(new Period(6, TimeUnit.Months));
                }
                BlackScholesMertonProcess stochProcess = new BlackScholesMertonProcess(new Handle<SimpleQuote>(spot), qTS, rTS, volTS);
                try {
                    Constructor<T> baseConstructor = engineClass.getConstructor(GeneralizedBlackScholesProcess.class);
                    engine = (PricingEngine)baseConstructor.newInstance(stochProcess);
                }
                catch (Exception e) {
                    throw new LibraryException(e);
                }
                PlainVanillaPayoff payoff = new PlainVanillaPayoff(type, strike);
                DividendVanillaOption option = new DividendVanillaOption(payoff, exercise, dividendDates, dividends);
                option.setPricingEngine(engine);
                for (double u : underlyings) {
                    for (double q : qRates) {
                        for (double r : rRates) {
                            for (double v : vols) {
                                spot.setValue(u);
                                qRate.setValue(q);
                                rRate.setValue(r);
                                vol.setValue(v);
                                double value = option.NPV();
                                calculated.put("delta", option.delta());
                                calculated.put("gamma", option.gamma());
                                if (!(value > spot.value() * 1.0E-5)) continue;
                                double du = u * 1.0E-4;
                                spot.setValue(u + du);
                                double value_p = option.NPV();
                                double delta_p = option.delta();
                                spot.setValue(u - du);
                                double value_m = option.NPV();
                                double delta_m = option.delta();
                                spot.setValue(u);
                                expected.put("delta", (value_p - value_m) / (2.0 * du));
                                expected.put("gamma", (delta_p - delta_m) / (2.0 * du));
                                for (Map.Entry it : calculated.entrySet()) {
                                    String greek = (String)it.getKey();
                                    double expct = (Double)expected.get(greek);
                                    double calcl = (Double)it.getValue();
                                    double tol = (Double)tolerance.get(greek);
                                    double error = Utilities.relativeError(expct, calcl, u);
                                    if (!(error > tol)) continue;
                                    this.REPORT_FAILURE(greek, payoff, exercise, u, q, r, today, v, expct, calcl, error, tol);
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    private <T extends FDEngineAdapter> void testFdDegenerate(Class<T> engineClass, Date today, Exercise exercise) {
        PricingEngine engine;
        Actual360 dc = new Actual360();
        SimpleQuote spot = new SimpleQuote(54.625);
        Handle<YieldTermStructure> rTS = new Handle<YieldTermStructure>(Utilities.flatRate(0.052706, (DayCounter)dc));
        Handle<YieldTermStructure> qTS = new Handle<YieldTermStructure>(Utilities.flatRate(0.0, (DayCounter)dc));
        Handle<BlackVolTermStructure> volTS = new Handle<BlackVolTermStructure>(Utilities.flatVol(0.282922, (DayCounter)dc));
        BlackScholesMertonProcess process = new BlackScholesMertonProcess(new Handle<SimpleQuote>(spot), qTS, rTS, volTS);
        int timeSteps = 40;
        int gridPoints = 300;
        try {
            Constructor<T> baseConstructor = engineClass.getConstructor(GeneralizedBlackScholesProcess.class, Integer.TYPE, Integer.TYPE);
            engine = (PricingEngine)baseConstructor.newInstance(process, 40, 300);
        }
        catch (Exception e) {
            throw new LibraryException(e);
        }
        PlainVanillaPayoff payoff = new PlainVanillaPayoff(Option.Type.Call, 55.0);
        double tolerance = 0.003;
        ArrayList<Date> dividendDates = new ArrayList<Date>();
        ArrayList<Double> dividends = new ArrayList<Double>();
        DividendVanillaOption option1 = new DividendVanillaOption(payoff, exercise, dividendDates, dividends);
        option1.setPricingEngine(engine);
        double refValue = option1.NPV();
        for (int i = 0; i <= 6; ++i) {
            dividends.add(0.0);
            dividendDates.add(today.add(i));
            DividendVanillaOption option = new DividendVanillaOption(payoff, exercise, dividendDates, dividends);
            option.setPricingEngine(engine);
            double value = option.NPV();
            if (!(Math.abs(refValue - value) > 0.003)) continue;
            StringBuilder sb = new StringBuilder();
            sb.append("NPV changed by null dividend :\n");
            sb.append("    previous value: ").append(refValue).append('\n');
            sb.append("    current value:  ").append(value).append('\n');
            sb.append("    change:         ").append(value - refValue);
            Assert.fail((String)sb.toString());
        }
    }

    private void REPORT_FAILURE(String greekName, StrikedTypePayoff payoff, Exercise exercise, double s, double q, double r, Date today, double v, double expected, double calculated, double error, double tolerance) {
        StringBuilder sb = new StringBuilder();
        sb.append(exercise).append(" ");
        sb.append((Object)payoff.optionType()).append(" option with ");
        sb.append(payoff).append(" payoff:\n");
        sb.append("    spot value:       ").append(s).append("\n");
        sb.append("    strike:           ").append(payoff.strike()).append("\n");
        sb.append("    dividend yield:   ").append(q).append("\n");
        sb.append("    risk-free rate:   ").append(r).append("\n");
        sb.append("    reference date:   ").append(today).append("\n");
        sb.append("    maturity:         ").append(exercise.lastDate()).append("\n");
        sb.append("    volatility:       ").append(v).append("\n\n");
        sb.append("    expected ").append(greekName).append(":   ").append(expected).append("\n");
        sb.append("    calculated ").append(greekName).append(": ").append(calculated).append("\n");
        sb.append("    error:            ").append(error).append("\n");
        sb.append("    tolerance:        ").append(tolerance);
    }
}

