/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.testsuite.calendars;

import java.util.ArrayList;
import org.jquantlib.QL;
import org.jquantlib.testsuite.calendars.CalendarUtil;
import org.jquantlib.time.Calendar;
import org.jquantlib.time.Date;
import org.jquantlib.time.Month;
import org.jquantlib.time.calendars.Ukraine;
import org.junit.Test;

public class UkraineCalendarTest {
    private final Calendar exchange;

    public UkraineCalendarTest() {
        QL.info("::::: " + this.getClass().getSimpleName() + " :::::");
        this.exchange = new Ukraine(Ukraine.Market.USE);
    }

    @Test
    public void testUkraineUSEHolidaysYear2004() {
        int year = 2004;
        QL.info("Testing " + (Object)((Object)Ukraine.Market.USE) + " holidays list for the year " + 2004 + "...");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(1, Month.January, 2004));
        expectedHol.add(new Date(7, Month.January, 2004));
        expectedHol.add(new Date(8, Month.March, 2004));
        expectedHol.add(new Date(12, Month.April, 2004));
        expectedHol.add(new Date(3, Month.May, 2004));
        expectedHol.add(new Date(10, Month.May, 2004));
        expectedHol.add(new Date(31, Month.May, 2004));
        expectedHol.add(new Date(28, Month.June, 2004));
        expectedHol.add(new Date(24, Month.August, 2004));
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, this.exchange, 2004);
    }

    @Test
    public void testUkraineUSEHolidaysYear2005() {
        int year = 2005;
        QL.info("Testing " + (Object)((Object)Ukraine.Market.USE) + " holidays list for the year " + 2005 + "...");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(3, Month.January, 2005));
        expectedHol.add(new Date(7, Month.January, 2005));
        expectedHol.add(new Date(8, Month.March, 2005));
        expectedHol.add(new Date(2, Month.May, 2005));
        expectedHol.add(new Date(9, Month.May, 2005));
        expectedHol.add(new Date(20, Month.June, 2005));
        expectedHol.add(new Date(28, Month.June, 2005));
        expectedHol.add(new Date(24, Month.August, 2005));
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, this.exchange, 2005);
    }

    @Test
    public void testUkraineUSEHolidaysYear2006() {
        int year = 2006;
        QL.info("Testing " + (Object)((Object)Ukraine.Market.USE) + " holidays list for the year " + 2006 + "...");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(2, Month.January, 2006));
        expectedHol.add(new Date(9, Month.January, 2006));
        expectedHol.add(new Date(8, Month.March, 2006));
        expectedHol.add(new Date(24, Month.April, 2006));
        expectedHol.add(new Date(1, Month.May, 2006));
        expectedHol.add(new Date(2, Month.May, 2006));
        expectedHol.add(new Date(9, Month.May, 2006));
        expectedHol.add(new Date(12, Month.June, 2006));
        expectedHol.add(new Date(28, Month.June, 2006));
        expectedHol.add(new Date(24, Month.August, 2006));
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, this.exchange, 2006);
    }

    @Test
    public void testUkraineUSEHolidaysYear2007() {
        int year = 2007;
        QL.info("Testing " + (Object)((Object)Ukraine.Market.USE) + " holidays list for the year " + 2007 + "...");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(1, Month.January, 2007));
        expectedHol.add(new Date(8, Month.January, 2007));
        expectedHol.add(new Date(8, Month.March, 2007));
        expectedHol.add(new Date(9, Month.April, 2007));
        expectedHol.add(new Date(1, Month.May, 2007));
        expectedHol.add(new Date(2, Month.May, 2007));
        expectedHol.add(new Date(9, Month.May, 2007));
        expectedHol.add(new Date(28, Month.May, 2007));
        expectedHol.add(new Date(28, Month.June, 2007));
        expectedHol.add(new Date(24, Month.August, 2007));
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, this.exchange, 2007);
    }

    @Test
    public void testUkraineUSEHolidaysYear2008() {
        int year = 2008;
        QL.info("Testing " + (Object)((Object)Ukraine.Market.USE) + " holidays list for the year " + 2008 + "...");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(1, Month.January, 2008));
        expectedHol.add(new Date(7, Month.January, 2008));
        expectedHol.add(new Date(10, Month.March, 2008));
        expectedHol.add(new Date(28, Month.April, 2008));
        expectedHol.add(new Date(1, Month.May, 2008));
        expectedHol.add(new Date(2, Month.May, 2008));
        expectedHol.add(new Date(9, Month.May, 2008));
        expectedHol.add(new Date(16, Month.June, 2008));
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, this.exchange, 2008);
    }

    @Test
    public void testUkraineUSEHolidaysYear2009() {
        int year = 2009;
        QL.info("Testing " + (Object)((Object)Ukraine.Market.USE) + " holidays list for the year " + 2009 + "...");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(1, Month.January, 2009));
        expectedHol.add(new Date(7, Month.January, 2009));
        expectedHol.add(new Date(9, Month.March, 2009));
        expectedHol.add(new Date(20, Month.April, 2009));
        expectedHol.add(new Date(1, Month.May, 2009));
        expectedHol.add(new Date(11, Month.May, 2009));
        expectedHol.add(new Date(8, Month.June, 2009));
        expectedHol.add(new Date(24, Month.August, 2009));
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, this.exchange, 2009);
    }

    @Test
    public void testUkraineUSEHolidaysYear2010() {
        int year = 2010;
        QL.info("Testing " + (Object)((Object)Ukraine.Market.USE) + " holidays list for the year " + 2010 + "...");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(1, Month.January, 2010));
        expectedHol.add(new Date(7, Month.January, 2010));
        expectedHol.add(new Date(8, Month.March, 2010));
        expectedHol.add(new Date(5, Month.April, 2010));
        expectedHol.add(new Date(3, Month.May, 2010));
        expectedHol.add(new Date(10, Month.May, 2010));
        expectedHol.add(new Date(24, Month.May, 2010));
        expectedHol.add(new Date(28, Month.June, 2010));
        expectedHol.add(new Date(24, Month.August, 2010));
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, this.exchange, 2010);
    }

    @Test
    public void testUkraineUSEHolidaysYear2011() {
        int year = 2011;
        QL.info("Testing " + (Object)((Object)Ukraine.Market.USE) + " holidays list for the year " + 2011 + "...");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(3, Month.January, 2011));
        expectedHol.add(new Date(7, Month.January, 2011));
        expectedHol.add(new Date(8, Month.March, 2011));
        expectedHol.add(new Date(25, Month.April, 2011));
        expectedHol.add(new Date(2, Month.May, 2011));
        expectedHol.add(new Date(9, Month.May, 2011));
        expectedHol.add(new Date(13, Month.June, 2011));
        expectedHol.add(new Date(28, Month.June, 2011));
        expectedHol.add(new Date(24, Month.August, 2011));
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, this.exchange, 2011);
    }

    @Test
    public void testUkraineUSEHolidaysYear2012() {
        int year = 2012;
        QL.info("Testing " + (Object)((Object)Ukraine.Market.USE) + " holidays list for the year " + 2012 + "...");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(2, Month.January, 2012));
        expectedHol.add(new Date(9, Month.January, 2012));
        expectedHol.add(new Date(8, Month.March, 2012));
        expectedHol.add(new Date(16, Month.April, 2012));
        expectedHol.add(new Date(1, Month.May, 2012));
        expectedHol.add(new Date(2, Month.May, 2012));
        expectedHol.add(new Date(9, Month.May, 2012));
        expectedHol.add(new Date(4, Month.June, 2012));
        expectedHol.add(new Date(28, Month.June, 2012));
        expectedHol.add(new Date(24, Month.August, 2012));
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, this.exchange, 2012);
    }
}

