/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.testsuite.calendars;

import java.util.ArrayList;
import java.util.List;
import org.jquantlib.QL;
import org.jquantlib.testsuite.calendars.CalendarUtil;
import org.jquantlib.time.Calendar;
import org.jquantlib.time.Date;
import org.jquantlib.time.Month;
import org.jquantlib.time.calendars.Taiwan;
import org.junit.Test;

public class TaiwanCalendarTest {
    private Calendar exchange = null;
    private final List<Date> expectedHol = null;

    public TaiwanCalendarTest() {
        QL.info("::::: " + this.getClass().getSimpleName() + " :::::");
        this.exchange = new Taiwan(Taiwan.Market.TSEC);
    }

    @Test
    public void testTaiwanTSEHolidaysYear2002() {
        int year = 2002;
        QL.info("Testing " + this.exchange.name() + " holidays list for the year " + 2002 + "...");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(1, Month.January, 2002));
        expectedHol.add(new Date(11, Month.February, 2002));
        expectedHol.add(new Date(12, Month.February, 2002));
        expectedHol.add(new Date(13, Month.February, 2002));
        expectedHol.add(new Date(14, Month.February, 2002));
        expectedHol.add(new Date(15, Month.February, 2002));
        expectedHol.add(new Date(28, Month.February, 2002));
        expectedHol.add(new Date(5, Month.April, 2002));
        expectedHol.add(new Date(1, Month.May, 2002));
        expectedHol.add(new Date(10, Month.October, 2002));
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, this.exchange, 2002);
    }

    @Test
    public void testTaiwanTSEHolidaysYear2003() {
        int year = 2003;
        QL.info("Testing " + (Object)((Object)Taiwan.Market.TSEC) + " holidays list for the year " + 2003 + "...");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(1, Month.January, 2003));
        expectedHol.add(new Date(31, Month.January, 2003));
        expectedHol.add(new Date(3, Month.February, 2003));
        expectedHol.add(new Date(4, Month.February, 2003));
        expectedHol.add(new Date(5, Month.February, 2003));
        expectedHol.add(new Date(28, Month.February, 2003));
        expectedHol.add(new Date(1, Month.May, 2003));
        expectedHol.add(new Date(4, Month.June, 2003));
        expectedHol.add(new Date(11, Month.September, 2003));
        expectedHol.add(new Date(10, Month.October, 2003));
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, this.exchange, 2003);
    }

    @Test
    public void testTaiwanTSEHolidaysYear2004() {
        int year = 2004;
        QL.info("Testing " + (Object)((Object)Taiwan.Market.TSEC) + " holidays list for the year " + 2004 + "...");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(1, Month.January, 2004));
        expectedHol.add(new Date(21, Month.January, 2004));
        expectedHol.add(new Date(22, Month.January, 2004));
        expectedHol.add(new Date(23, Month.January, 2004));
        expectedHol.add(new Date(26, Month.January, 2004));
        expectedHol.add(new Date(22, Month.June, 2004));
        expectedHol.add(new Date(28, Month.September, 2004));
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, this.exchange, 2004);
    }

    @Test
    public void testTaiwanTSEHolidaysYear2005() {
        int year = 2005;
        QL.info("Testing " + (Object)((Object)Taiwan.Market.TSEC) + " holidays list for the year " + 2005 + "...");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(7, Month.February, 2005));
        expectedHol.add(new Date(8, Month.February, 2005));
        expectedHol.add(new Date(9, Month.February, 2005));
        expectedHol.add(new Date(10, Month.February, 2005));
        expectedHol.add(new Date(11, Month.February, 2005));
        expectedHol.add(new Date(28, Month.February, 2005));
        expectedHol.add(new Date(5, Month.April, 2005));
        expectedHol.add(new Date(2, Month.May, 2005));
        expectedHol.add(new Date(10, Month.October, 2005));
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, this.exchange, 2005);
    }

    @Test
    public void testTaiwanTSEHolidaysYear2006() {
        int year = 2006;
        QL.info("Testing " + (Object)((Object)Taiwan.Market.TSEC) + " holidays list for the year " + 2006 + "...");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(30, Month.January, 2006));
        expectedHol.add(new Date(31, Month.January, 2006));
        expectedHol.add(new Date(1, Month.February, 2006));
        expectedHol.add(new Date(2, Month.February, 2006));
        expectedHol.add(new Date(3, Month.February, 2006));
        expectedHol.add(new Date(28, Month.February, 2006));
        expectedHol.add(new Date(5, Month.April, 2006));
        expectedHol.add(new Date(1, Month.May, 2006));
        expectedHol.add(new Date(31, Month.May, 2006));
        expectedHol.add(new Date(6, Month.October, 2006));
        expectedHol.add(new Date(10, Month.October, 2006));
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, this.exchange, 2006);
    }

    @Test
    public void testTaiwanTSEHolidaysYear2007() {
        int year = 2007;
        QL.info("Testing " + (Object)((Object)Taiwan.Market.TSEC) + " holidays list for the year " + 2007 + "...");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(1, Month.January, 2007));
        expectedHol.add(new Date(19, Month.February, 2007));
        expectedHol.add(new Date(20, Month.February, 2007));
        expectedHol.add(new Date(21, Month.February, 2007));
        expectedHol.add(new Date(22, Month.February, 2007));
        expectedHol.add(new Date(23, Month.February, 2007));
        expectedHol.add(new Date(28, Month.February, 2007));
        expectedHol.add(new Date(5, Month.April, 2007));
        expectedHol.add(new Date(6, Month.April, 2007));
        expectedHol.add(new Date(1, Month.May, 2007));
        expectedHol.add(new Date(18, Month.June, 2007));
        expectedHol.add(new Date(19, Month.June, 2007));
        expectedHol.add(new Date(24, Month.September, 2007));
        expectedHol.add(new Date(25, Month.September, 2007));
        expectedHol.add(new Date(10, Month.October, 2007));
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, this.exchange, 2007);
    }

    @Test
    public void testTaiwanTSEHolidaysYear2008() {
        int year = 2008;
        QL.info("Testing " + (Object)((Object)Taiwan.Market.TSEC) + " holidays list for the year " + 2008 + "...");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(1, Month.January, 2008));
        expectedHol.add(new Date(4, Month.February, 2008));
        expectedHol.add(new Date(5, Month.February, 2008));
        expectedHol.add(new Date(6, Month.February, 2008));
        expectedHol.add(new Date(7, Month.February, 2008));
        expectedHol.add(new Date(8, Month.February, 2008));
        expectedHol.add(new Date(11, Month.February, 2008));
        expectedHol.add(new Date(28, Month.February, 2008));
        expectedHol.add(new Date(4, Month.April, 2008));
        expectedHol.add(new Date(1, Month.May, 2008));
        expectedHol.add(new Date(10, Month.October, 2008));
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, this.exchange, 2008);
    }

    @Test
    public void testTaiwanTSEHolidaysYear2009() {
        int year = 2009;
        QL.info("Testing " + (Object)((Object)Taiwan.Market.TSEC) + " holidays list for the year " + 2009 + "...");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(1, Month.January, 2009));
        expectedHol.add(new Date(1, Month.May, 2009));
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, this.exchange, 2009);
    }

    @Test
    public void testTaiwanTSEHolidaysYear2010() {
        int year = 2010;
        QL.info("Testing " + (Object)((Object)Taiwan.Market.TSEC) + " holidays list for the year " + 2010 + "...");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(1, Month.January, 2010));
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, this.exchange, 2010);
    }

    @Test
    public void testTaiwanTSEHolidaysYear2011() {
        int year = 2011;
        QL.info("Testing " + (Object)((Object)Taiwan.Market.TSEC) + " holidays list for the year " + 2011 + "...");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(28, Month.February, 2011));
        expectedHol.add(new Date(10, Month.October, 2011));
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, this.exchange, 2011);
    }

    @Test
    public void testTaiwanTSEHolidaysYear2012() {
        int year = 2012;
        QL.info("Testing " + (Object)((Object)Taiwan.Market.TSEC) + " holidays list for the year " + 2012 + "...");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(28, Month.February, 2012));
        expectedHol.add(new Date(1, Month.May, 2012));
        expectedHol.add(new Date(10, Month.October, 2012));
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, this.exchange, 2012);
    }
}

